/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat;

import de.admadic.spiromat.Messages;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.ui.MainView;
import java.awt.BorderLayout;
import java.awt.HeadlessException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class SpiromatApplet
extends JApplet {
    private static final long serialVersionUID = 1L;
    private MainView mainView;
    private AppModel model;
    static Logger logger;
    HashMap<String, String> parameters = new HashMap();

    @Override
    public String getAppletInfo() {
        return "Spiromat Applet - (c) 2007 by admaDIC GbR, Leipzig, Germany, www.admadic.de";
    }

    @Override
    public String[][] getParameterInfo() {
        return new String[][]{{"lang", "string", "language to select"}, {"outerradius", "4..100", "radius of outer gear"}, {"innerradius", "4..100", "radius of inner gear"}, {"penholepos", "0.0 .. 1.0", "position of pen hole in inner gear"}, {"innercolor", "color", "color code for inner gear"}, {"outercolor", "color", "color code for outer gear"}, {"figurecolor", "color", "color code for figure"}};
    }

    @Override
    public void init() {
        logger.debug("init");
        super.init();
        String string = this.getParameter("LANG");
        if (string != null) {
            Messages.setLocaleLanguage(string);
        }
        this.readParameters();
        try {
            this.initSkin();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.model = AppModel.getInstance();
        this.model.setParameters(this.parameters);
        this.mainView = new MainView(this.model);
        this.add(this.mainView);
    }

    private void readParameters() {
        this.readParameter("outerradius", "outerRadius");
        this.readParameter("innerradius", "innerRadius");
        this.readParameter("penholepos", "lambda");
        this.readParameter("figurecolor", "colorFigure");
        this.readParameter("outercolor", "colorOuterGear");
        this.readParameter("innercolor", "colorInnerGear");
    }

    private void readParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 != null) {
            this.parameters.put(string2, string3);
        }
    }

    void initSkin() throws Exception {
        String string = "admadicthemepack.zip";
        URL uRL = string == null ? SpiromatApplet.class.getResource("themepack.zip") : SpiromatApplet.class.getResource(string);
        Class<?> clazz = Class.forName("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
        Method method = clazz.getMethod("loadThemePack", URL.class);
        Class<?> clazz2 = Class.forName("com.l2fprod.gui.plaf.skin.Skin");
        Method method2 = clazz.getMethod("setSkin", clazz2);
        Object object = method.invoke(null, uRL);
        method2.invoke(null, object);
        Object obj = clazz.newInstance();
        UIManager.setLookAndFeel((LookAndFeel)obj);
    }

    @Override
    public void start() {
        logger.debug("start");
        super.start();
        this.mainView.start();
    }

    @Override
    public void stop() {
        logger.debug("stop");
        super.stop();
        this.mainView.stop();
    }

    @Override
    public void destroy() {
        logger.debug("stop");
        super.destroy();
        this.mainView.destroy();
    }

    static {
        Logger.initialize();
        logger = Logger.getLogger(SpiromatApplet.class);
    }
}

