/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.spiromat;

import de.admadic.spiromat.Messages;
import de.admadic.spiromat.log.Logger;
import de.admadic.spiromat.model.AppModel;
import de.admadic.spiromat.splash.SplashWindow;
import de.admadic.spiromat.ui.CfgSpi;
import de.admadic.spiromat.ui.MainFrame;
import de.admadic.util.PathManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SpiromatApp {
    static Logger logger;
    public static CfgSpi cfg;
    static PathManager pathMan;
    static MainFrame frame;

    public static void main(String[] stringArray) {
        try {
            SplashWindow.getInstance().showSplash();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SpiromatApp.execute();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            logger.error("general app error", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error("general app error", invocationTargetException);
        }
        finally {
            SplashWindow.getInstance().hideSplash();
        }
    }

    static void execute() {
        SpiromatApp.initProgramEnvironment();
        try {
            SpiromatApp.initSkin();
        }
        catch (Exception exception) {
            logger.error("skin init error", exception);
            System.err.println(exception.getLocalizedMessage());
        }
        try {
            frame = new MainFrame(AppModel.getInstance());
            frame.initContents();
            frame.setVisible(true);
            SplashWindow.getInstance().hideSplash();
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(null, "Could not start the application.\nMessage: " + throwable.getLocalizedMessage(), "Error starting application", 0);
        }
    }

    private static void initProgramEnvironment() {
        pathMan = new PathManager();
        pathMan.init("admadic", "spiromat", "1.1.0", SpiromatApp.class);
        cfg = new CfgSpi();
        cfg.initCfgPaths(pathMan);
        cfg.initialize(true);
        SplashWindow.getInstance().setMessage(SpiromatApp.buildLicInfo());
    }

    static String buildLicInfo() {
        String string = cfg.getStringValue("ui.main.lic.name", null);
        String string2 = cfg.getStringValue("ui.main.lic.company", null);
        String string3 = cfg.getStringValue("ui.main.lic.sn", null);
        Object object = "";
        if (string != null) {
            object = (String)object + string;
        }
        if (string2 != null) {
            if (!((String)object).equals("")) {
                object = (String)object + " ";
            }
            object = (String)object + string2;
        }
        if (string3 != null && !((String)object).equals("")) {
            object = Messages.getString("SpiromatApp.registeredTo") + (String)object + "<br>";
        }
        if (!((String)object).equals("")) {
            object = "<html>" + (String)object;
        }
        return object;
    }

    static void initSkin() throws Exception {
        String string = "admadicthemepack.zip";
        URL uRL = string == null ? SpiromatApp.class.getResource("themepack.zip") : SpiromatApp.class.getResource(string);
        Class<?> clazz = Class.forName("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");
        Method method = clazz.getMethod("loadThemePack", URL.class);
        Class<?> clazz2 = Class.forName("com.l2fprod.gui.plaf.skin.Skin");
        Method method2 = clazz.getMethod("setSkin", clazz2);
        Object object = method.invoke(null, uRL);
        method2.invoke(null, object);
        Object obj = clazz.newInstance();
        UIManager.setLookAndFeel((LookAndFeel)obj);
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    static {
        Logger.initialize();
        logger = Logger.getLogger(SpiromatApp.class);
    }
}

