/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleOneLineFormatter
extends Formatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = "\n";

    public SimpleOneLineFormatter() {
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.lineSeparator = System.lineSeparator();
    }

    @Override
    public synchronized String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        this.dat.setTime(logRecord.getMillis());
        this.args[0] = this.dat;
        StringBuffer stringBuffer2 = new StringBuffer();
        this.formatter.format(this.args, stringBuffer2, (FieldPosition)null);
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(": ");
        String string = this.formatMessage(logRecord);
        stringBuffer.append(logRecord.getLevel().getName());
        stringBuffer.append(": ");
        stringBuffer.append(string);
        stringBuffer.append(" (");
        if (logRecord.getSourceClassName() != null) {
            stringBuffer.append(" c=");
            stringBuffer.append(logRecord.getSourceClassName());
        } else {
            stringBuffer.append(" l=");
            stringBuffer.append(logRecord.getLoggerName());
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append(" m=");
            stringBuffer.append(logRecord.getSourceMethodName());
        }
        if (logRecord.getThrown() != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringBuffer.append(")");
        stringBuffer.append(this.lineSeparator);
        return stringBuffer.toString();
    }
}

