/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.cfg;

import de.admadic.cfg.CfgException;
import de.admadic.cfg.CfgItem;
import de.admadic.cfg.CfgPersistenceGrouped;
import de.admadic.cfg.CfgPersistenceItemized;
import de.admadic.cfg.CfgProvider;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class CfgPersistencePref
implements CfgPersistenceGrouped,
CfgPersistenceItemized {
    protected static final boolean DBGforce = false;
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    CfgProvider cfgProvider;

    public CfgPersistencePref() {
        this(null);
    }

    public CfgPersistencePref(CfgProvider cfgProvider) {
        this.cfgProvider = cfgProvider;
    }

    @Override
    public void registerCfgProvider(CfgProvider cfgProvider) {
        this.cfgProvider = cfgProvider;
    }

    @Override
    public void removeKeys(String string, Enumeration<String> enumeration) {
        Preferences preferences = Preferences.userRoot();
        preferences = preferences.node(string);
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            preferences.remove(string2 + ".data");
            preferences.remove(string2 + ".meta");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String string) {
        try {
            String[] stringArray;
            Preferences preferences = Preferences.userRoot();
            preferences = preferences.node(string);
            for (String string2 : stringArray = preferences.keys()) {
                if (string2 == null || string2.endsWith(".meta") || !string2.endsWith(".data")) continue;
                String string3 = string2 = string2.replaceAll("\\.data$", "");
                String string4 = preferences.get(string2 + ".data", "");
                String string5 = preferences.get(string2 + ".meta", "");
                CfgItem cfgItem = new CfgItem();
                cfgItem.decodeKey(string3);
                cfgItem.decodeMeta(string5);
                cfgItem.decodeValue(string4);
                this.cfgProvider.putCfgItem(cfgItem.getCiKey(), cfgItem);
            }
        }
        catch (BackingStoreException backingStoreException) {
            if (this.logger != null) {
                this.logger.severe("configuration error (pref): " + backingStoreException.getMessage());
            }
        }
        catch (CfgException cfgException) {
            if (this.logger != null) {
                this.logger.severe("configuration error (pref): " + cfgException.getMessage());
            }
        }
    }

    @Override
    public void store(String string) {
        Preferences preferences = Preferences.userRoot();
        preferences = preferences.node(string);
        Enumeration<String> enumeration = this.cfgProvider.getCfgItemKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            try {
                if (string2 == null) continue;
                CfgItem cfgItem = this.cfgProvider.getCfgItem(string2);
                String string3 = cfgItem.encodeKey();
                String string4 = cfgItem.encodeValue();
                String string5 = cfgItem.encodeMeta();
                preferences.put(string3 + ".data", string4);
                preferences.put(string3 + ".meta", string5);
            }
            catch (CfgException cfgException) {
                if (this.logger == null) continue;
                this.logger.severe("configuration error (pref): " + cfgException.getMessage());
            }
        }
    }

    @Override
    public boolean clear(String string) {
        try {
            String[] stringArray;
            Preferences preferences = Preferences.userRoot();
            preferences = preferences.node(string);
            for (String string2 : stringArray = preferences.keys()) {
                preferences.remove(string2);
            }
            return true;
        }
        catch (BackingStoreException backingStoreException) {
            return false;
        }
    }

    @Override
    public void prepareLoad(String string) {
    }

    @Override
    public void prepareStore(String string) {
    }

    @Override
    public String[] getKeys() {
        return null;
    }

    @Override
    public CfgItem loadCfgItem(String string) {
        return null;
    }

    @Override
    public void storeCfgItem(CfgItem cfgItem) {
    }

    @Override
    public void finalizeLoad() {
    }

    @Override
    public void finalizeStore() {
    }
}

