/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.cfg;

import de.admadic.cfg.Cfg;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class CfgObjectSpecification {
    static boolean DBGforceOS = false;
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    final String path;
    final String name;
    String[] fieldList;
    Object object;
    boolean isClass;
    CfgObjectSpecification classRef;

    public CfgObjectSpecification(String string, String string2, String[] stringArray) {
        this.path = string;
        this.name = string2;
        this.fieldList = stringArray;
        this.isClass = true;
    }

    public CfgObjectSpecification(String string, String string2, String[] stringArray, Object object) {
        this.path = string;
        this.name = string2;
        this.fieldList = stringArray;
        this.object = object;
        this.isClass = false;
    }

    public void setClassRef(CfgObjectSpecification cfgObjectSpecification) {
        this.classRef = cfgObjectSpecification;
    }

    public void loadSettings(Cfg cfg) {
        if (this.isClass) {
            System.err.println("Cfg: CfgObjectSpecification: loadSettings called: isClass=true for name=" + this.name);
            return;
        }
        this.loadAndStoreSettings(cfg, true);
    }

    public void storeSettings(Cfg cfg) {
        if (this.isClass) {
            System.err.println("Cfg: CfgObjectSpecification: loadSettings called: isClass=true for name=" + this.name);
            return;
        }
        this.loadAndStoreSettings(cfg, false);
    }

    protected void loadAndStoreSettings(Cfg cfg, boolean bl) {
        block40: {
            Method method;
            Class<?> clazz;
            String[] stringArray;
            block39: {
                if (DBGforceOS) {
                    System.err.println("ObjSpc: loadAndStoreSettings load=" + bl);
                }
                if (this.isClass) {
                    System.err.println("Cfg: CfgObjectSpecification: load/storeSettings called: isClass=true for name=" + this.name);
                    return;
                }
                stringArray = this.fieldList;
                if (stringArray == null && this.classRef != null) {
                    stringArray = this.classRef.fieldList;
                }
                if (stringArray == null || stringArray.length == 0) {
                    if (DBGforceOS) {
                        System.err.println("ObjSpc: object " + this.name + " has no fields to access.");
                    }
                    return;
                }
                if (this.object == null) {
                    System.err.println("Cfg: CfgObjectSpecification: load/storeSettings called: object==null for name=" + this.name);
                    return;
                }
                clazz = this.object.getClass();
                if (!bl) {
                    try {
                        if (DBGforceOS) {
                            System.err.println("ObjSpc: trying to get preStoreSettings for object " + this.name);
                        }
                        method = clazz.getDeclaredMethod("preStoreSettings", null);
                        method.invoke(this.object, (Object[])null);
                    }
                    catch (SecurityException securityException) {
                        if (this.logger != null) {
                            this.logger.severe("configration error: " + securityException.getMessage());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (this.logger != null) {
                            this.logger.severe("configration error: " + noSuchMethodException.getMessage());
                        }
                        if (DBGforceOS) {
                            System.err.println("ObjSpc: no preStoreSettings for object " + this.name);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (this.logger != null) {
                            this.logger.severe("configration error: " + illegalArgumentException.getMessage());
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (this.logger != null) {
                            this.logger.severe("configration error: " + illegalAccessException.getMessage());
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (this.logger == null) break block39;
                        this.logger.severe("configration error: " + invocationTargetException.getMessage());
                    }
                }
            }
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Object object;
                    String string = this.path + "." + this.name + "." + stringArray[i];
                    if (DBGforceOS) {
                        System.err.println("ObjSpc: accessing field " + stringArray[i] + " for object " + this.name);
                    }
                    Field field = clazz.getDeclaredField(stringArray[i]);
                    if (bl) {
                        object = cfg.getValue(string, null);
                        if (object == null) continue;
                        field.set(this.object, object);
                        continue;
                    }
                    object = field.get(this.object);
                    cfg.putValue(string, object);
                    continue;
                }
                catch (SecurityException securityException) {
                    if (this.logger == null) continue;
                    this.logger.severe("configration error: " + securityException.getMessage());
                    continue;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (this.logger == null) continue;
                    this.logger.severe("configration error: " + noSuchFieldException.getMessage());
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.logger == null) continue;
                    this.logger.severe("configration error: " + illegalArgumentException.getMessage());
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (this.logger == null) continue;
                    this.logger.severe("configration error: " + illegalAccessException.getMessage());
                }
            }
            if (bl) {
                try {
                    if (DBGforceOS) {
                        System.err.println("ObjSpc: trying to get postLoadSettings for object " + this.name);
                    }
                    method = clazz.getDeclaredMethod("postLoadSettings", null);
                    method.invoke(this.object, (Object[])null);
                }
                catch (SecurityException securityException) {
                    if (this.logger != null) {
                        this.logger.severe("configration error: " + securityException.getMessage());
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (DBGforceOS) {
                        System.err.println("ObjSpc: no postLoadSettings for object " + this.name);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.logger != null) {
                        this.logger.severe("configration error: " + illegalArgumentException.getMessage());
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (this.logger != null) {
                        this.logger.severe("configration error: " + illegalAccessException.getMessage());
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (this.logger == null) break block40;
                    this.logger.severe("configration error: " + invocationTargetException.getMessage());
                }
            }
        }
    }
}

