/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.cfg;

import de.admadic.cfg.CfgException;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;

public class CfgItem
implements Cloneable {
    String ciKey;
    String ciValue;
    public static final int FLG_NONE = 0;
    public static final int FLG_NORESET = 1;
    Type ciType;
    String ciObjClassName;
    int ciFlags;

    public static CfgItem create(String string, Object object) {
        CfgItem cfgItem = new CfgItem(string);
        try {
            cfgItem.putObjectValue(object, true);
        }
        catch (CfgException cfgException) {
            return null;
        }
        return cfgItem;
    }

    public static CfgItem createFromEncoded(String string, String string2) {
        CfgItem cfgItem = new CfgItem();
        try {
            cfgItem.decodeKey(string);
            cfgItem.decodeValue(string2);
        }
        catch (Exception exception) {
            return null;
        }
        return cfgItem;
    }

    public CfgItem() {
        this.ciKey = null;
        this.ciFlags = 0;
        try {
            this.putObjectValue(null, true);
        }
        catch (CfgException cfgException) {
            // empty catch block
        }
    }

    public CfgItem(String string) {
        this.ciKey = string;
        this.ciFlags = 0;
        try {
            this.putObjectValue(null, true);
        }
        catch (CfgException cfgException) {
            // empty catch block
        }
    }

    public CfgItem(String string, Object object, int n) throws CfgException {
        this.ciKey = string;
        this.ciFlags = n;
        this.putObjectValue(object, true);
    }

    public CfgItem(String string, Object object) throws CfgException {
        this(string, object, 0);
    }

    protected void setCiValue(String string) {
        this.ciValue = string;
    }

    public String getCiValue() {
        return this.ciValue;
    }

    public void setTypeOfObject(Object object) {
        Type type = CfgItem.getTypeOfObject(object);
        this.ciObjClassName = type == Type.OBJECT ? object.getClass().getName() : null;
        this.ciType = type;
    }

    protected static Type getTypeOfObject(Object object) {
        Type type = object instanceof String ? Type.STRING : (object instanceof Integer ? Type.INT : (object instanceof Boolean ? Type.BOOLEAN : (object instanceof Rectangle ? Type.RECTANGLE : (object instanceof Point ? Type.POINT : Type.OBJECT))));
        return type;
    }

    public CfgItem clone() throws CloneNotSupportedException {
        CfgItem cfgItem = (CfgItem)super.clone();
        cfgItem.ciKey = this.ciKey;
        cfgItem.ciValue = this.ciValue;
        cfgItem.ciType = this.ciType;
        cfgItem.ciFlags = this.ciFlags;
        cfgItem.ciObjClassName = this.ciObjClassName;
        return cfgItem;
    }

    public String encodeKey() {
        String string = this.ciKey;
        return string;
    }

    public void decodeKey(String string) {
        this.ciKey = string;
    }

    public String encodeValue() {
        return this.ciValue;
    }

    public void decodeValue(String string) {
        this.ciValue = string;
    }

    public String encodeMeta() throws CfgException {
        String string = "[" + this.type2String() + "," + this.flags2String() + "]";
        return string;
    }

    public void decodeMeta(String string) throws CfgException {
        int n = string.indexOf(91);
        int n2 = string.indexOf(93);
        if (n < 0 || n2 < 0) {
            throw new CfgException("Invalid encoded representation: " + string + " (missing brackets)");
        }
        if (n >= n2) {
            throw new CfgException("Invalid encoded representation: " + string + " (invalid bracket placement)");
        }
        String string2 = string.substring(n + 1, n2);
        String[] stringArray = string2.split(",");
        if (stringArray.length != 2) {
            throw new CfgException("Invalid encoded representation: " + string + " (specification format invalid)");
        }
        this.string2Type(stringArray[0]);
        this.string2Flags(stringArray[1]);
    }

    protected String type2String() throws CfgException {
        Object object;
        switch (this.ciType) {
            case STRING: {
                object = "s";
                break;
            }
            case BOOLEAN: {
                object = "b";
                break;
            }
            case INT: {
                object = "i";
                break;
            }
            case RECTANGLE: {
                object = "r";
                break;
            }
            case POINT: {
                object = "p";
                break;
            }
            case OBJECT: {
                object = "o";
                object = (String)object + ":";
                object = (String)object + this.ciObjClassName;
                break;
            }
            case ARRAY_OF_OBJECT: {
                object = "a";
                break;
            }
            default: {
                throw new CfgException("Type not supported: " + this.ciType);
            }
        }
        return object;
    }

    protected void string2Type(String string) throws CfgException {
        Type type;
        if (string.equals("s")) {
            type = Type.STRING;
        } else if (string.equals("b")) {
            type = Type.BOOLEAN;
        } else if (string.equals("i")) {
            type = Type.INT;
        } else if (string.equals("r")) {
            type = Type.RECTANGLE;
        } else if (string.equals("p")) {
            type = Type.POINT;
        } else if (string.startsWith("o")) {
            type = Type.OBJECT;
        } else if (string.equals("a")) {
            type = Type.ARRAY_OF_OBJECT;
        } else {
            throw new CfgException("Type code not supported: " + string);
        }
        this.ciType = type;
        if (type == Type.OBJECT) {
            int n = string.indexOf(58);
            this.ciObjClassName = n >= 0 ? string.substring(n + 1) : null;
        }
    }

    protected String flags2String() {
        Object object = "";
        if (((String)(object = (String)object + ((this.ciFlags & 1) != 0 ? "r" : ""))).equals("")) {
            object = "n";
        }
        return object;
    }

    protected void string2Flags(String string) {
        this.ciFlags = 0;
        if (string.indexOf("r") >= 0) {
            this.ciFlags |= 1;
        }
    }

    public int getCiFlags() {
        return this.ciFlags;
    }

    public void setCiFlags(int n) {
        this.ciFlags = n;
    }

    public void setCiFlags(int n, boolean bl) {
        this.ciFlags = bl ? (this.ciFlags |= n) : (this.ciFlags &= ~n);
    }

    public String getCiKey() {
        return this.ciKey;
    }

    public Type getCiType() {
        return this.ciType;
    }

    public void putObjectValue(Object object) throws CfgException {
        this.putObjectValue(object, false);
    }

    public void putObjectValue(Object object, boolean bl) throws CfgException {
        Object object2;
        if (object == null) {
            this.ciValue = "";
            this.ciType = null;
            return;
        }
        Type type = CfgItem.getTypeOfObject(object);
        if (this.getCiType() != type) {
            if (bl) {
                this.setTypeOfObject(object);
            } else {
                throw new CfgException("Type mismatch");
            }
        }
        switch (this.getCiType()) {
            case RECTANGLE: {
                Rectangle rectangle = (Rectangle)object;
                object2 = rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
                break;
            }
            case POINT: {
                Point point = (Point)object;
                object2 = point.x + "," + point.y;
                break;
            }
            default: {
                object2 = object.toString();
            }
        }
        this.ciValue = object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObjectValue(Object object) {
        String string = this.ciValue;
        if (string == null) {
            return object;
        }
        switch (this.ciType) {
            case STRING: {
                return new String(this.ciValue);
            }
            case INT: {
                return Integer.valueOf(string);
            }
            case BOOLEAN: {
                return Boolean.valueOf(string);
            }
            case RECTANGLE: {
                Rectangle rectangle = new Rectangle();
                try {
                    String[] stringArray = string.split(",");
                    if (stringArray.length != 4) {
                        return object;
                    }
                    rectangle.x = Integer.parseInt(stringArray[0]);
                    rectangle.y = Integer.parseInt(stringArray[1]);
                    rectangle.width = Integer.parseInt(stringArray[2]);
                    rectangle.height = Integer.parseInt(stringArray[3]);
                    return rectangle;
                }
                catch (Exception exception) {
                    return object;
                }
            }
            case POINT: {
                Point point = new Point();
                try {
                    String[] stringArray = string.split(",");
                    if (stringArray.length != 2) {
                        return object;
                    }
                    point.x = Integer.parseInt(stringArray[0]);
                    point.y = Integer.parseInt(stringArray[1]);
                    return point;
                }
                catch (Exception exception) {
                    return object;
                }
            }
            case OBJECT: {
                String string2 = this.ciObjClassName;
                String string3 = this.ciValue;
                return this.instantiateObject(string2, string3);
            }
        }
        return new String(string);
    }

    protected Object instantiateObject(String string, String string2) {
        Object object = null;
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getDeclaredMethod("valueOf", String.class);
            object = method.invoke(null, string2);
        }
        catch (Exception exception) {
            return null;
        }
        return object;
    }

    public boolean getBooleanValue(boolean bl) {
        Object object = this.getObjectValue(null);
        if (!(object instanceof Boolean)) {
            return bl;
        }
        Boolean bl2 = (Boolean)object;
        return bl2;
    }

    public String getStringValue(String string) {
        Object object = this.getObjectValue(null);
        if (!(object instanceof String)) {
            return string;
        }
        String string2 = (String)object;
        return string2;
    }

    public int getIntValue(int n) {
        Object object = this.getObjectValue(null);
        if (!(object instanceof Integer)) {
            return n;
        }
        Integer n2 = (Integer)object;
        return n2;
    }

    public Rectangle getRectangleValue(Rectangle rectangle) {
        Object object = this.getObjectValue(null);
        if (!(object instanceof Rectangle)) {
            return rectangle;
        }
        Rectangle rectangle2 = (Rectangle)object;
        return rectangle2;
    }

    public Point getPointValue(Point point) {
        Object object = this.getObjectValue(null);
        if (!(object instanceof Point)) {
            return point;
        }
        Point point2 = (Point)object;
        return point2;
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        INT,
        RECTANGLE,
        POINT,
        OBJECT,
        ARRAY_OF_OBJECT;

    }
}

