/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.util;

import de.admadic.util.VersionName;
import de.admadic.util.VersionRecord;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionUtil {
    static final boolean DBG = false;
    static final boolean LOG = true;
    static final Logger logger = Logger.getLogger("de.admadic");

    private VersionUtil() {
    }

    public static VersionName getVersionNameFromFileName(String string, boolean bl) {
        Pattern pattern;
        Matcher matcher;
        VersionName versionName = null;
        VersionRecord versionRecord = null;
        if (bl) {
            versionName = new VersionName(string, null, "");
        }
        if (!(matcher = (pattern = Pattern.compile("(.*[^0-9]+)?([0-9]++)\\.([0-9]+)\\.([0-9]+)(?:-r([0-9]+))?(.*)")).matcher(string)).matches()) {
            return versionName;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        String string5 = matcher.group(4);
        String string6 = matcher.group(5);
        String string7 = matcher.group(6);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (string3 != null && !string3.equals("")) {
            n = Integer.parseInt(string3);
        }
        if (string4 != null && !string4.equals("")) {
            n2 = Integer.parseInt(string4);
        }
        if (string5 != null && !string5.equals("")) {
            n3 = Integer.parseInt(string5);
        }
        if (string6 != null && !string6.equals("")) {
            n4 = Integer.parseInt(string6);
        }
        versionRecord = new VersionRecord(n, n2, n3, n4);
        versionName = new VersionName(string2, versionRecord, string7);
        return versionName;
    }

    public static VersionName getVersionNameFromFileName(String string) {
        return VersionUtil.getVersionNameFromFileName(string, false);
    }

    public static void removeOldVersions(List<File> list) {
        VersionName versionName;
        ArrayList<VersionName> arrayList = new ArrayList<VersionName>();
        for (int i = 0; i < list.size(); ++i) {
            File file = list.get(i);
            versionName = null;
            if (file == null || (versionName = VersionUtil.getVersionNameFromFileName(file.getName())) != null) {
                // empty if block
            }
            arrayList.add(versionName);
        }
        Vector<VersionName> vector = new Vector<VersionName>();
        for (int i = 0; i < arrayList.size(); ++i) {
            versionName = (VersionName)arrayList.get(i);
            if (versionName == null) continue;
            vector.clear();
            for (int j = 0; j < arrayList.size(); ++j) {
                VersionName versionName2 = (VersionName)arrayList.get(j);
                if (versionName2 == null || versionName2 == versionName || !versionName.equalsIgnoreVersion(versionName2)) continue;
                vector.add(versionName2);
            }
            if (vector.size() <= 0) continue;
            vector.add(versionName);
            VersionName versionName3 = Collections.max(vector, new Comparator<VersionName>(){

                @Override
                public int compare(VersionName versionName, VersionName versionName2) {
                    return versionName.getVersionRecord().compareTo(versionName2.getVersionRecord(), 4, true);
                }
            });
            if (logger != null) {
                logger.config("detected max version: " + versionName3.getCombinedName());
            }
            for (VersionName versionName4 : vector) {
                if (versionName4 == null || versionName4 == versionName3) continue;
                int n = arrayList.indexOf(versionName4);
                if (logger != null) {
                    logger.config("clearing old version: " + versionName4.getCombinedName());
                }
                arrayList.set(n, null);
                list.set(n, null);
            }
        }
        vector.clear();
        arrayList.clear();
    }
}

