/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;

public class PathManager {
    static boolean DBG = false;
    public static final int SYS_BASE_DIR = 0;
    public static final int SYS_VEN_DIR = 1;
    public static final int SYS_APPGRP_DIR = 2;
    public static final int SYS_APP_DIR = 3;
    public static final int SYS_BIN_DIR = 4;
    public static final int SYS_CFG_DIR = 5;
    public static final int SYS_LIB_DIR = 6;
    public static final int SYS_LAF_DIR = 7;
    public static final int SYS_LOG_DIR = 8;
    public static final int SYS_MOD_DIR = 17;
    public static final int SYS_DOC_DIR = 20;
    public static final int USR_BASE_DIR = 9;
    public static final int USR_VEN_DIR = 10;
    public static final int USR_APPGRP_DIR = 11;
    public static final int USR_APP_DIR = 12;
    public static final int USR_CFG_DIR = 13;
    public static final int USR_LIB_DIR = 14;
    public static final int USR_LAF_DIR = 15;
    public static final int USR_LOG_DIR = 16;
    public static final int USR_MOD_DIR = 18;
    public static final int USR_DOC_DIR = 21;
    public static final int USR_TMP_DIR = 19;
    static final int pathCount = 22;
    ArrayList<File> paths;
    boolean canCreateDirs = false;

    public static File expandFilename(String string) {
        if (DBG) {
            System.out.print("PathManager: expanding " + string + " -> ");
        }
        File file = null;
        Object object = "";
        int n = 0;
        int n2 = string.length();
        block7: while (n < n2) {
            char c = string.charAt(n);
            ++n;
            if (c == '%') {
                char c2 = n < n2 ? string.charAt(n) : (char)'\u0000';
                ++n;
                switch (c2) {
                    case '\u0000': 
                    case '%': {
                        object = (String)object + "%";
                        continue block7;
                    }
                    case 'h': {
                        object = "";
                        file = new File(System.getProperty("user.home"));
                        continue block7;
                    }
                    case 'w': {
                        object = "";
                        file = new File(System.getProperty("user.dir"));
                        continue block7;
                    }
                    case 'j': {
                        object = "";
                        file = new File(System.getProperty("java.home"));
                        continue block7;
                    }
                    case 't': {
                        object = "";
                        file = new File(System.getProperty("java.io.tmpdir"));
                        continue block7;
                    }
                }
                continue;
            }
            if (c == '/') {
                if (((String)object).equals("")) {
                    file = new File(file, "/");
                    continue;
                }
                file = new File(file, (String)object);
                object = "";
                continue;
            }
            object = (String)object + c;
        }
        if (!((String)object).equals("")) {
            file = new File(file, (String)object);
        }
        if (DBG) {
            System.out.println(file.toString());
        }
        return file;
    }

    public PathManager() {
        String string = System.getProperty("admadic.debug");
        if (string != null && string.toLowerCase().equals("yes")) {
            DBG = true;
        }
        if (DBG) {
            System.out.println("PathManager: <init>");
        }
        this.paths = new ArrayList();
        for (int i = 0; i < 22; ++i) {
            this.paths.add(i, null);
        }
    }

    public static String getCodeBase(Class clazz) {
        String string;
        URI uRI;
        if (DBG) {
            System.out.println("PathManager: getCodeBase");
        }
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        URL uRL = codeSource.getLocation();
        if (DBG) {
            System.out.println("PathManager: source = " + codeSource.toString());
        }
        if (DBG) {
            System.out.println("PathManager: sourceUrl = " + uRL.toString());
        }
        String string2 = uRL.getProtocol();
        if (DBG) {
            System.out.println("PathManager: prot = " + string2);
        }
        if (!string2.equals("file")) {
            throw new Error("PathManager: cannot handle application store protocols other than 'file://'");
        }
        try {
            uRI = uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                uRI = new URI(null, uRL.getHost(), uRL.getPath(), null);
            }
            catch (URISyntaxException uRISyntaxException2) {
                System.err.println("PathManager: could not create a URI.");
                System.err.println("please contact customer support and send the next line to them:");
                System.err.println("url = " + uRL);
                System.exit(1);
                return null;
            }
        }
        File file = new File(uRI.getPath());
        if (DBG) {
            System.out.println("PathManager: unescaped = " + file.toString());
        }
        if ((string = file.toString()).toLowerCase().endsWith(".jar")) {
            if (DBG) {
                System.out.println("PathManager: is jar! stripping");
            }
            string = file.getParent();
        }
        return string;
    }

    public static File stripTrailers(File file) {
        File file2 = file;
        while (file2.getName().equals(".")) {
            if (file2.getParentFile() == null) {
                return file2;
            }
            file2 = file2.getParentFile();
        }
        return file2;
    }

    public void init(String string, String string2, String string3, Class clazz) {
        Object object;
        if (DBG) {
            System.out.println("PathManager: init: " + string + ", " + string2 + ", " + string3 + ", " + clazz.getName());
        }
        String string4 = PathManager.getCodeBase(clazz);
        if (DBG) {
            System.out.println("PathManager: sysbase = " + string4);
        }
        if (string4.endsWith(File.separator + "bin" + File.separator)) {
            if (DBG) {
                System.out.println("PathManager: stripping /bin/");
            }
            string4 = string4.substring(0, string4.length() - 4);
        } else if (string4.endsWith(File.separator + "bin")) {
            if (DBG) {
                System.out.println("PathManager: stripping /bin");
            }
            string4 = string4.substring(0, string4.length() - 3);
        } else if (string4.endsWith(File.separator + "lib" + File.separator)) {
            if (DBG) {
                System.out.println("PathManager: stripping /lib/");
            }
            string4 = string4.substring(0, string4.length() - 4);
        } else if (string4.endsWith(File.separator + "lib")) {
            if (DBG) {
                System.out.println("PathManager: stripping /lib");
            }
            string4 = string4.substring(0, string4.length() - 3);
        }
        File file = new File(string4);
        if (DBG) {
            System.out.println("PathManager: base = " + file.toString());
        }
        this.paths.set(3, this.createPath(file, ""));
        this.paths.set(4, this.createPath(file, "bin"));
        this.paths.set(5, this.createPath(file, "cfg"));
        this.paths.set(6, this.createPath(file, "lib"));
        this.paths.set(7, this.createPath(file, "laf"));
        this.paths.set(8, this.createPath(file, "log"));
        this.paths.set(17, this.createPath(file, "mod"));
        this.paths.set(20, this.createPath(file, "doc"));
        Object object2 = file;
        object2 = PathManager.stripTrailers((File)object2);
        File file2 = ((File)object2).getParentFile();
        if (file2 == null) {
            if (DBG) {
                System.out.println("PathManager: parent of app failed: " + file.toString());
            }
            this.paths.set(2, this.paths.get(3));
        } else {
            object = file2.getName();
            if (((String)object).equals(string2)) {
                this.paths.set(2, this.createPath(file2, ""));
            } else if (((String)object).equalsIgnoreCase(string2)) {
                this.paths.set(2, this.createPath(file2, ""));
            } else {
                if (DBG) {
                    System.out.println("PathManager: appgrp not detected.");
                }
                this.paths.set(2, this.paths.get(3));
            }
        }
        object2 = this.paths.get(2);
        object2 = PathManager.stripTrailers((File)object2);
        file2 = ((File)object2).getParentFile();
        if (file2 == null) {
            if (DBG) {
                System.out.println("PathManager: parent of appgrp failed: " + ((File)object2).toString());
            }
            this.paths.set(1, this.paths.get(2));
        } else {
            object = file2.getName();
            if (((String)object).equals(string)) {
                this.paths.set(1, this.createPath(file2, ""));
            } else if (((String)object).equalsIgnoreCase(string)) {
                this.paths.set(1, this.createPath(file2, ""));
            } else {
                if (DBG) {
                    System.out.println("PathManager: ven not detected.");
                }
                this.paths.set(1, this.paths.get(2));
            }
        }
        object2 = System.getProperty("user.home");
        if (object2 == null) {
            object2 = string4;
        }
        file2 = new File((String)object2);
        this.paths.set(9, this.createPath(file2, "", false));
        object = "";
        if (string != null) {
            if (!((String)object).equals("")) {
                object = (String)object + File.separator;
            }
            object = (String)object + "." + string;
        }
        this.paths.set(10, this.createPath(file2, (String)object, true));
        if (string2 != null) {
            if (!((String)object).equals("")) {
                object = (String)object + File.separator;
            }
            object = (String)object + string2;
        }
        this.paths.set(11, this.createPath(file2, (String)object, true));
        if (string3 != null) {
            if (!((String)object).equals("")) {
                object = (String)object + File.separator;
            }
            object = (String)object + string3;
        }
        this.paths.set(12, this.createPath(file2, (String)object, true));
        if (!((String)object).equals("")) {
            object = (String)object + File.separator;
        }
        this.paths.set(13, this.createPath(file2, (String)object + "cfg", true));
        this.paths.set(14, this.createPath(file2, (String)object + "lib", true));
        this.paths.set(15, this.createPath(file2, (String)object + "laf", true));
        this.paths.set(16, this.createPath(file2, (String)object + "log", true));
        this.paths.set(18, this.createPath(file2, (String)object + "mod", true));
        this.paths.set(21, this.createPath(file2, (String)object + "doc", true));
        this.paths.set(19, this.createPath(file2, (String)object + "tmp", true));
        if (DBG) {
            this.dump();
        }
    }

    public String getPathString(int n) {
        File file = this.paths.get(n);
        if (file != null) {
            return file.toString();
        }
        return null;
    }

    protected File createPath(File file, String string, boolean bl) {
        File file2 = null;
        if (string.equals("")) {
            return new File(file.toString());
        }
        file2 = new File(file, string);
        if (file2.exists()) {
            return file2;
        }
        if (bl && file2.mkdirs()) {
            return file2;
        }
        return new File(file.toString());
    }

    protected File createPath(File file, String string) {
        return this.createPath(file, string, false);
    }

    protected void dumpEntry(int n, String string) {
        System.out.println(string + ": " + this.paths.get(n));
    }

    public void dump() {
        this.dumpEntry(0, "sys base");
        this.dumpEntry(1, "sys ven");
        this.dumpEntry(2, "sys appgrp");
        this.dumpEntry(3, "sys app");
        this.dumpEntry(4, "sys bin");
        this.dumpEntry(5, "sys cfg");
        this.dumpEntry(6, "sys lib");
        this.dumpEntry(7, "sys laf");
        this.dumpEntry(8, "sys log");
        this.dumpEntry(17, "sys mod");
        this.dumpEntry(20, "sys doc");
        this.dumpEntry(9, "usr base");
        this.dumpEntry(10, "usr ven");
        this.dumpEntry(11, "usr appgrp");
        this.dumpEntry(12, "usr app");
        this.dumpEntry(13, "usr cfg");
        this.dumpEntry(14, "usr lib");
        this.dumpEntry(15, "usr laf");
        this.dumpEntry(16, "usr log");
        this.dumpEntry(18, "usr mod");
        this.dumpEntry(21, "usr doc");
    }
}

