/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.util;

public class BitOp {
    protected BitOp() {
    }

    public static void xor(byte[] byArray, byte[] byArray2) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(byArray[i] ^ byArray2[n]);
            if (++n < byArray2.length) continue;
            n = 0;
        }
    }

    public static byte[] xorOut(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        BitOp.xor(byArray3, byArray2);
        return byArray3;
    }

    static int calculateBitCount(int n) {
        int n2 = 0;
        for (int i = 0; i < 32; ++i) {
            if ((n >> i & 1) == 0) continue;
            ++n2;
        }
        return n2;
    }

    static int calculateByteBase(int n) {
        if (n == 0) {
            return 0;
        }
        for (int i = 3; i >= 0; --i) {
            if ((n >> i * 8 & 0xFF) == 0) continue;
            return i + 1;
        }
        return 0;
    }

    static void calculateBitIndexTable(int n, int[][] nArray) {
        int n2 = 0;
        for (int i = 0; i < 32; ++i) {
            if ((n >> i & 1) == 0) continue;
            nArray[n2][0] = i;
            nArray[n2][1] = i / 8;
            ++n2;
        }
    }

    public static byte[] extractBits(byte[] byArray, int n) {
        byte[] byArray2 = null;
        int n2 = BitOp.calculateBitCount(n);
        int n3 = BitOp.calculateByteBase(n);
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        int n4 = byArray.length * n2 / (n3 * 8);
        byArray2 = new byte[n4];
        int[][] nArray = new int[n2][2];
        BitOp.calculateBitIndexTable(n, nArray);
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = 0;
            for (int j = 0; j < 8; ++j) {
                int n7 = nArray[n5][0];
                int n8 = nArray[n5][1];
                byte by = byArray[n6 + n8];
                by = (byte)(by >> (n7 %= 8) & 1);
                byArray2[i] = (byte)(byArray2[i] | by << j);
                if (++n5 < n2) continue;
                n5 = 0;
                n6 += n3;
            }
        }
        return byArray2;
    }

    public static void insertBits(byte[] byArray, byte[] byArray2, int n) {
        int n2 = BitOp.calculateBitCount(n);
        int n3 = BitOp.calculateByteBase(n);
        int[][] nArray = new int[n2][2];
        BitOp.calculateBitIndexTable(n, nArray);
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n6 = nArray[n4][0];
                int n7 = nArray[n4][1];
                byte by = byArray[n5 + n7];
                byte by2 = byArray2[i];
                by2 = (byte)(by2 >> j & 1);
                by = (byte)(by & ~(1 << (n6 %= 8)));
                byArray[n5 + n7] = by = (byte)(by | by2 << n6);
                if (++n4 < n2) continue;
                n4 = 0;
                n5 += n3;
            }
        }
    }

    public static void maskBits(byte[] byArray, int n, int n2) {
        int n3 = BitOp.calculateByteBase(n);
        if (n3 == 0) {
            return;
        }
        byte[] byArray2 = new byte[4];
        BitOp.int2Bytes(n, byArray2, 0, 4);
        int n4 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = n2 == 0 ? (byte)(byArray[i] & ~byArray2[n4]) : (byte)(byArray[i] | byArray2[n4]);
            if (++n4 < n3) continue;
            n4 = 0;
        }
    }

    public static String bytes2Hex(byte[] byArray) {
        Object object = "";
        boolean bl = false;
        for (byte by : byArray) {
            if (bl) {
                object = (String)object + "-";
            } else {
                bl = true;
            }
            object = (String)object + String.format("%02x", by);
        }
        return object;
    }

    public static void int2Bytes(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[i + n2] = (byte)(n % 256);
            n >>= 8;
        }
    }

    public static int bytes2Int(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n2 - 1; i >= 0; --i) {
            n3 <<= 8;
            n3 += byArray[i + n] & 0xFF;
        }
        return n3;
    }
}

