/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.ui.util.ColumnAccessor;
import de.admadic.ui.util.ListRefTableModel;
import de.admadic.units.core.BaseUnit;
import de.admadic.units.core.CompositeUnit;
import de.admadic.units.core.Domain;
import de.admadic.units.core.Factor;
import de.admadic.units.core.FactorUnit;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.SubstUnit;
import de.admadic.units.core.UnitFactory;
import de.admadic.units.core.UnitFilter;
import de.admadic.units.core.UnitManager;
import de.admadic.units.ui.ActionFunction;
import de.admadic.units.ui.BaseUnitDialog;
import de.admadic.units.ui.CompUnitDialog;
import de.admadic.units.ui.FactorUnitDialog;
import de.admadic.units.ui.SubstUnitDialog;
import de.admadic.units.ui.UnitsUiUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;

public class UnitsTablePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    UnitManager um;
    UnitFilter uf;
    JFrame owner;
    JTable tableUnits;
    JScrollPane scrollUnits;
    ListRefTableModel tableModelUnits;
    ColumnAccessor tableAccessorUnits;
    Vector<IUnit> dataUnits;
    static final String CMD_FILTER = "cmd.filter";
    static final String CMD_NEW_BASE = "cmd.new.base";
    static final String CMD_NEW_FACT = "cmd.new.fact";
    static final String CMD_NEW_SUBS = "cmd.new.subs";
    static final String CMD_NEW_COMP = "cmd.new.comp";
    static final String CMD_EDIT = "cmd.edit";
    boolean filterOn;
    BaseUnitDialog dialogBaseUnit;
    FactorUnitDialog dialogFactorUnit;
    SubstUnitDialog dialogSubstUnit;
    CompUnitDialog dialogCompUnit;

    public UnitsTablePanel(UnitManager unitManager, UnitFilter unitFilter, JFrame jFrame) {
        this.owner = jFrame;
        this.um = unitManager;
        this.uf = unitFilter;
        this.dataUnits = new Vector();
        this.initContents();
    }

    public void initContents() {
        FormLayout formLayout = new FormLayout("12px, p:grow, 12px", "12px, p, 5px, p:grow, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        this.setLayout(formLayout);
        this.tableUnits = new JTable();
        this.scrollUnits = new JScrollPane(this.tableUnits, 22, 32);
        this.add((Component)this.scrollUnits, cellConstraints.xy(2, 4, CellConstraints.FILL, CellConstraints.FILL));
        this.tableUnits.setAutoResizeMode(0);
        this.dataUnits.addAll(this.um.getUnits());
        this.tableModelUnits = new ListRefTableModel();
        this.tableModelUnits.setData(this.dataUnits);
        this.tableModelUnits.setColumns(new String[]{"id", "type", "factor", "symbol", "name", "domain", "lastchg", "SoU", "Fields"});
        this.tableAccessorUnits = new ColumnAccessor(){

            @Override
            public void setValueAt(Object object, Object object2, int n) {
            }

            @Override
            public Object getValueAt(Object object, int n) {
                IUnit iUnit = (IUnit)object;
                switch (n) {
                    case 0: {
                        return iUnit.getId();
                    }
                    case 1: {
                        String string = "";
                        string = iUnit instanceof BaseUnit ? "base" : (iUnit instanceof SubstUnit ? "subs" : (iUnit instanceof CompositeUnit ? "comp" : (iUnit instanceof FactorUnit ? "fact" : "<?>")));
                        return string;
                    }
                    case 2: {
                        return iUnit.getFactor() != null ? iUnit.getFactor().getSymbol() : "-";
                    }
                    case 3: {
                        return iUnit.getSymbol();
                    }
                    case 4: {
                        return iUnit.getName();
                    }
                    case 5: {
                        return iUnit.getDomain() != null ? iUnit.getDomain().getName() : "-";
                    }
                    case 6: {
                        String string = "-";
                        if (iUnit.getLastChange() != null) {
                            string = DateFormat.getDateTimeInstance(3, 3).format(iUnit.getLastChange());
                        }
                        return string;
                    }
                    case 7: {
                        return iUnit.getContext().getSousString();
                    }
                    case 8: {
                        return iUnit.getContext().getFieldsString();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(Object object, int n) {
                return false;
            }

            @Override
            public Class getColumnClass(int n) {
                return String.class;
            }
        };
        this.tableModelUnits.setColumnAccessor(this.tableAccessorUnits);
        this.tableUnits.setModel(this.tableModelUnits);
        this.tableUnits.setSelectionMode(2);
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, cellConstraints.xy(2, 2));
        Vector<AbstractButton> vector = new Vector<AbstractButton>();
        JToggleButton jToggleButton = new JToggleButton("Filter");
        vector.add(jToggleButton);
        jToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                UnitsTablePanel.this.doFilterOn(itemEvent.getStateChange() == 1);
            }
        });
        JButton jButton = new JButton("Edit");
        vector.add(jButton);
        jButton.setActionCommand(CMD_EDIT);
        jButton.addActionListener(this);
        jButton = new JButton("New Base");
        vector.add(jButton);
        jButton.setActionCommand(CMD_NEW_BASE);
        jButton.addActionListener(this);
        jButton = new JButton("New Fact");
        vector.add(jButton);
        jButton.setActionCommand(CMD_NEW_FACT);
        jButton.addActionListener(this);
        jButton = new JButton("New Subs");
        vector.add(jButton);
        jButton.setActionCommand(CMD_NEW_SUBS);
        jButton.addActionListener(this);
        jButton = new JButton("New Comp");
        vector.add(jButton);
        jButton.setActionCommand(CMD_NEW_COMP);
        jButton.addActionListener(this);
        UnitsUiUtil.createHorizontalButtonPanel(jPanel, vector.toArray(new AbstractButton[vector.size()]));
    }

    public void updateFilter() {
        if (this.filterOn) {
            this.doFilterOn(this.filterOn);
        }
    }

    protected void doFilterOn(boolean bl) {
        this.filterOn = bl;
        if (bl) {
            this.dataUnits.clear();
            this.uf.populateUnits(this.dataUnits);
        } else {
            this.dataUnits.clear();
            this.dataUnits.addAll(this.um.getUnits());
        }
        this.tableModelUnits.fireTableDataChanged();
    }

    public IUnit[] getSelectedUnits() {
        IUnit[] iUnitArray = null;
        int[] nArray = this.tableUnits.getSelectedRows();
        iUnitArray = new IUnit[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            iUnitArray[i] = this.dataUnits.get(n);
        }
        return iUnitArray;
    }

    public void fireUnitsTableChanged() {
        int[] nArray = this.tableUnits.getSelectedRows();
        this.tableModelUnits.fireTableDataChanged();
        for (int n : nArray) {
            this.tableUnits.addRowSelectionInterval(n, n);
        }
    }

    protected void initBaseUnitDialog() {
        this.dialogBaseUnit = new BaseUnitDialog((Frame)this.owner, this.um, new ActionFunction(){

            @Override
            public boolean run(Object[] objectArray) {
                return UnitsTablePanel.this.doNewBaseUnit((String)objectArray[0], (String)objectArray[1], (String)objectArray[2], (String)objectArray[3]);
            }
        });
    }

    protected void initFactorUnitDialog() {
        this.dialogFactorUnit = new FactorUnitDialog((Frame)this.owner, this.um, new ActionFunction(){

            @Override
            public boolean run(Object[] objectArray) {
                return UnitsTablePanel.this.doNewFactorUnit((Domain)objectArray[0], (Factor)objectArray[1], (IUnit)objectArray[2]);
            }
        }, new ActionFunction(){

            @Override
            public boolean run(Object[] objectArray) {
                int n = UnitsTablePanel.this.tableUnits.getSelectedRow();
                if (n < 0) {
                    return false;
                }
                IUnit iUnit = UnitsTablePanel.this.dataUnits.get(n);
                UnitsTablePanel.this.dialogFactorUnit.setBaseUnit(iUnit);
                return true;
            }
        });
    }

    protected void initSubstUnitDialog() {
        this.dialogSubstUnit = new SubstUnitDialog((Frame)this.owner, this.um, new ActionFunction(){

            @Override
            public boolean run(Object[] objectArray) {
                return UnitsTablePanel.this.doNewSubstUnit((String)objectArray[0], (String)objectArray[1], (String)objectArray[2], (String)objectArray[3], (Factor)objectArray[4], (IConverter)objectArray[5], (IUnit)objectArray[6]);
            }
        }, new ActionFunction(){

            @Override
            public boolean run(Object[] objectArray) {
                int n = UnitsTablePanel.this.tableUnits.getSelectedRow();
                if (n < 0) {
                    return false;
                }
                IUnit iUnit = UnitsTablePanel.this.dataUnits.get(n);
                UnitsTablePanel.this.dialogSubstUnit.setBaseUnit(iUnit);
                return true;
            }
        });
    }

    protected void initCompUnitDialog() {
        this.dialogCompUnit = new CompUnitDialog((Frame)this.owner, this.um);
        this.dialogCompUnit.setActions(new ActionFunction(){

            @Override
            public boolean run(Object[] objectArray) {
                return UnitsTablePanel.this.doNewCompUnit((String)objectArray[0], (Vector)objectArray[1], (Vector)objectArray[2]);
            }
        }, new ActionFunction(){

            @Override
            public boolean run(Object[] objectArray) {
                int n = UnitsTablePanel.this.tableUnits.getSelectedRow();
                if (n < 0) {
                    return false;
                }
                IUnit iUnit = UnitsTablePanel.this.dataUnits.get(n);
                UnitsTablePanel.this.dialogCompUnit.setPreInit(iUnit);
                return true;
            }
        }, new ActionFunction(){

            @Override
            public boolean run(Object[] objectArray) {
                int[] nArray;
                for (int n : nArray = UnitsTablePanel.this.tableUnits.getSelectedRows()) {
                    IUnit iUnit = UnitsTablePanel.this.dataUnits.get(n);
                    UnitsTablePanel.this.dialogCompUnit.addMulUnit(iUnit);
                }
                return true;
            }
        }, new ActionFunction(){

            @Override
            public boolean run(Object[] objectArray) {
                int[] nArray;
                for (int n : nArray = UnitsTablePanel.this.tableUnits.getSelectedRows()) {
                    IUnit iUnit = UnitsTablePanel.this.dataUnits.get(n);
                    UnitsTablePanel.this.dialogCompUnit.addDivUnit(iUnit);
                }
                return true;
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_NEW_BASE)) {
            if (this.dialogBaseUnit == null) {
                this.initBaseUnitDialog();
            }
            this.dialogBaseUnit.setVisible(true);
        } else if (string.equals(CMD_NEW_FACT)) {
            if (this.dialogFactorUnit == null) {
                this.initFactorUnitDialog();
            }
            this.dialogFactorUnit.setVisible(true);
        } else if (string.equals(CMD_NEW_SUBS)) {
            if (this.dialogSubstUnit == null) {
                this.initSubstUnitDialog();
            }
            this.dialogSubstUnit.setVisible(true);
        } else if (string.equals(CMD_NEW_COMP)) {
            if (this.dialogCompUnit == null) {
                this.initCompUnitDialog();
            }
            this.dialogCompUnit.setVisible(true);
        } else if (string.equals(CMD_EDIT)) {
            this.doEditUnit();
        }
    }

    protected void doEditUnit() {
        int n = this.tableUnits.getSelectedRow();
        if (n < 0) {
            return;
        }
        IUnit iUnit = this.dataUnits.get(n);
        if (iUnit instanceof BaseUnit) {
            if (this.dialogBaseUnit == null) {
                this.initBaseUnitDialog();
            }
            this.dialogBaseUnit.editUnit((BaseUnit)iUnit);
            this.dialogBaseUnit.setVisible(true);
        } else if (iUnit instanceof FactorUnit) {
            if (this.dialogFactorUnit == null) {
                this.initFactorUnitDialog();
            }
            this.dialogFactorUnit.editUnit((FactorUnit)iUnit);
            this.dialogFactorUnit.setVisible(true);
        } else if (iUnit instanceof SubstUnit) {
            if (this.dialogSubstUnit == null) {
                this.initSubstUnitDialog();
            }
            this.dialogSubstUnit.editUnit((SubstUnit)iUnit);
            this.dialogSubstUnit.setVisible(true);
        } else if (iUnit instanceof CompositeUnit) {
            if (this.dialogCompUnit == null) {
                this.initCompUnitDialog();
            }
            this.dialogCompUnit.editUnit((CompositeUnit)iUnit);
            this.dialogCompUnit.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this.owner, "Unknown unit type: " + iUnit.getClass().getSimpleName(), "Unknown unit type", 0);
            return;
        }
    }

    protected boolean doNewCompUnit(String string, Vector<IUnit> vector, Vector<IUnit> vector2) {
        CompositeUnit compositeUnit;
        boolean bl = true;
        if (this.dialogCompUnit.isEditMode()) {
            compositeUnit = this.dialogCompUnit.getEditUnit();
            Domain domain = this.um.getDomain(string);
            compositeUnit.setDomain(domain);
            compositeUnit.clearSubUnits();
            for (IUnit iUnit : vector) {
                compositeUnit.appendUnit(iUnit, 0);
            }
            for (IUnit iUnit : vector2) {
                compositeUnit.appendUnit(iUnit, 1);
            }
            this.tableModelUnits.fireTableDataChanged();
            this.dialogCompUnit.setEditMode(false);
        } else {
            compositeUnit = UnitFactory.createCompUnit(this.um, string);
            for (IUnit iUnit : vector) {
                compositeUnit.appendUnit(iUnit, 0);
            }
            for (IUnit iUnit : vector2) {
                compositeUnit.appendUnit(iUnit, 1);
            }
            if (this.um.existsUnit(compositeUnit.getId())) {
                JOptionPane.showMessageDialog(null, "A unit with that id already exists.", "Invalid id", 0);
                return false;
            }
            this.um.addUnit(compositeUnit);
            if (this.filterOn && this.uf.unitMatchesFilter(compositeUnit)) {
                this.dataUnits.add(compositeUnit);
            } else {
                this.dataUnits.add(compositeUnit);
            }
            this.tableModelUnits.fireTableRowsInserted(this.dataUnits.size() - 1, this.dataUnits.size() - 1);
        }
        compositeUnit.touchLastChange();
        return bl;
    }

    protected boolean doNewSubstUnit(String string, String string2, String string3, String string4, Factor factor, IConverter iConverter, IUnit iUnit) {
        SubstUnit substUnit;
        boolean bl = true;
        if (this.dialogSubstUnit.isEditMode()) {
            substUnit = this.dialogSubstUnit.getEditUnit();
            Domain domain = this.um.getDomain(string4);
            substUnit.setDomain(domain);
            if (factor != null) {
                substUnit.setFactor(factor);
            }
            substUnit.setBaseUnit(iUnit);
            substUnit.setSubstConverter(iConverter);
            this.tableModelUnits.fireTableDataChanged();
            this.dialogSubstUnit.setEditMode(false);
        } else {
            if (this.um.existsUnit(string)) {
                JOptionPane.showMessageDialog(null, "A unit with that id already exists.", "Invalid id", 0);
                return false;
            }
            substUnit = UnitFactory.createSubstUnit(this.um, string, string2, string3, iUnit.getId(), string4);
            if (iConverter != null) {
                substUnit.setBaseConverter(iConverter);
            }
            if (factor != null) {
                substUnit.setFactor(factor);
            }
            this.um.addUnit(substUnit);
            if (this.filterOn && this.uf.unitMatchesFilter(substUnit)) {
                this.dataUnits.add(substUnit);
            } else {
                this.dataUnits.add(substUnit);
            }
            this.tableModelUnits.fireTableRowsInserted(this.dataUnits.size() - 1, this.dataUnits.size() - 1);
        }
        substUnit.touchLastChange();
        return bl;
    }

    protected boolean doNewFactorUnit(Domain domain, Factor factor, IUnit iUnit) {
        FactorUnit factorUnit;
        boolean bl = true;
        if (this.dialogFactorUnit.isEditMode()) {
            factorUnit = this.dialogFactorUnit.getEditUnit();
            factorUnit.setDomain(domain);
            factorUnit.setFactor(factor);
            factorUnit.setBaseUnit(iUnit);
            this.tableModelUnits.fireTableDataChanged();
            this.dialogFactorUnit.setEditMode(false);
            this.um.updateDatabase(factorUnit);
        } else {
            factorUnit = UnitFactory.createFactorUnit(this.um, domain.getId(), iUnit.getId(), factor.getId());
            if (this.um.existsUnit(factorUnit.getId())) {
                JOptionPane.showMessageDialog(null, "A unit with that id already exists.", "Invalid id", 0);
                return false;
            }
            this.um.addUnit(factorUnit);
            if (this.filterOn && this.uf.unitMatchesFilter(factorUnit)) {
                this.dataUnits.add(factorUnit);
            } else {
                this.dataUnits.add(factorUnit);
            }
            this.tableModelUnits.fireTableRowsInserted(this.dataUnits.size() - 1, this.dataUnits.size() - 1);
        }
        factorUnit.touchLastChange();
        return bl;
    }

    protected boolean doNewBaseUnit(String string, String string2, String string3, String string4) {
        BaseUnit baseUnit;
        boolean bl = true;
        if (!this.dialogBaseUnit.isEditMode() && this.um.existsUnit(string)) {
            JOptionPane.showMessageDialog(null, "A unit with that id already exists.", "Invalid id", 0);
            return false;
        }
        if (this.dialogBaseUnit.isEditMode()) {
            baseUnit = this.dialogBaseUnit.getEditUnit();
            baseUnit.setDomain(this.um.getDomain(string4));
            baseUnit.setId(string);
            baseUnit.setSymbol(string2);
            baseUnit.setName(string3);
            this.tableModelUnits.fireTableDataChanged();
            this.dialogBaseUnit.setEditMode(false);
            this.um.updateDatabase(baseUnit);
        } else {
            baseUnit = UnitFactory.createBaseUnit(this.um, string, string2, string3, string4);
            this.um.addUnit(baseUnit);
            if (this.filterOn && this.uf.unitMatchesFilter(baseUnit)) {
                this.dataUnits.add(baseUnit);
            } else {
                this.dataUnits.add(baseUnit);
            }
            this.tableModelUnits.fireTableRowsInserted(this.dataUnits.size() - 1, this.dataUnits.size() - 1);
        }
        baseUnit.touchLastChange();
        return bl;
    }
}

