/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import de.admadic.ui.util.FileChooserUtil;
import de.admadic.units.core.UnitManager;
import de.admadic.units.core.UnitsIo;
import de.admadic.units.ui.ConvertFrame;
import de.admadic.units.ui.ConvertPanel;
import de.admadic.units.ui.ManageFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UnitsFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    boolean DBGtesting = false;
    UnitManager unitManager;
    JPanel panelMain;
    ConvertPanel convertPanel;

    public UnitsFrame() {
        String string = System.getProperty("admadic.testing");
        if (string != null && string.toLowerCase().equals("yes")) {
            this.DBGtesting = true;
        }
        this.initCore();
        this.initComponents();
    }

    private void initCore() {
        this.unitManager = new UnitManager();
    }

    private void initComponents() {
        String[][] stringArrayArray;
        this.panelMain = (JPanel)this.getContentPane();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                UnitsFrame.this.setVisible(false);
                UnitsFrame.this.dispose();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Actions");
        jMenuBar.add(jMenu);
        for (String[] stringArray : stringArrayArray = new String[][]{{"Load...", "load"}, {"Save...", "save"}, {"Convert", "convert"}, {"Manage", "manage"}}) {
            JMenuItem jMenuItem = new JMenuItem(stringArray[0]);
            jMenuItem.setActionCommand(stringArray[1]);
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
        }
        this.setJMenuBar(jMenuBar);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("load")) {
            File file = FileChooserUtil.getFileWithExt(this, "xml", 1);
            if (file == null) {
                return;
            }
            UnitsIo unitsIo = new UnitsIo(this.unitManager);
            unitsIo.readFile(file);
        } else if (string.equals("save")) {
            File file = FileChooserUtil.getFileWithExt(this, "xml", 6);
            if (file == null) {
                return;
            }
            UnitsIo unitsIo = new UnitsIo(this.unitManager);
            unitsIo.saveFileUnits(file);
        } else if (string.equals("convert")) {
            ConvertFrame convertFrame = new ConvertFrame(this.unitManager);
            convertFrame.setVisible(true);
        } else if (string.equals("manage")) {
            ManageFrame manageFrame = new ManageFrame(this.unitManager);
            manageFrame.setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new UnitsFrame().setVisible(true);
            }
        });
    }
}

