/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import de.admadic.units.ui.UnitsCmdItf;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class UnitsActions {
    Vector<Action> actions;
    Hashtable<Class, Action> classToAction;
    UnitsCmdItf itf;

    public UnitsActions(UnitsCmdItf unitsCmdItf) {
        this.itf = unitsCmdItf;
        this.actions = new Vector();
        this.classToAction = new Hashtable();
        this.initStandard();
    }

    public void initStandard() {
        this.actions.add(new FilterFieldsSetAction(this.itf));
        this.actions.add(new FilterFieldsClearAction(this.itf));
        this.actions.add(new FilterFieldsAddAction(this.itf));
        this.actions.add(new FilterFieldsRemoveAction(this.itf));
        this.actions.add(new FilterSousSetAction(this.itf));
        this.actions.add(new FilterSousClearAction(this.itf));
        this.actions.add(new FilterSousAddAction(this.itf));
        this.actions.add(new FilterSousRemoveAction(this.itf));
        this.actions.add(new FilterDomainsSetAction(this.itf));
        this.actions.add(new FilterDomainsClearAction(this.itf));
        this.actions.add(new FilterDomainsAddAction(this.itf));
        this.actions.add(new FilterDomainsRemoveAction(this.itf));
        this.actions.add(new SetFieldsSetAction(this.itf));
        this.actions.add(new SetFieldsClearAction(this.itf));
        this.actions.add(new SetFieldsAddAction(this.itf));
        this.actions.add(new SetFieldsRemoveAction(this.itf));
        this.actions.add(new SetSousSetAction(this.itf));
        this.actions.add(new SetSousClearAction(this.itf));
        this.actions.add(new SetSousAddAction(this.itf));
        this.actions.add(new SetSousRemoveAction(this.itf));
        this.actions.add(new SetDomainsSetAction(this.itf));
        this.actions.add(new SetDomainsClearAction(this.itf));
        this.actions.add(new SetDomainsAddAction(this.itf));
        this.actions.add(new SetDomainsRemoveAction(this.itf));
        for (Action action : this.actions) {
            this.classToAction.put(action.getClass(), action);
        }
    }

    public Action getAction(Class clazz) {
        return this.classToAction.get(clazz);
    }

    public class SetDomainsRemoveAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetDomainsRemoveAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "-");
            this.putValue("ShortDescription", "Remove Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetDomainsRemove();
        }
    }

    public class SetDomainsAddAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetDomainsAddAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "+");
            this.putValue("ShortDescription", "Add Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetDomainsAdd();
        }
    }

    public class SetDomainsClearAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetDomainsClearAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Clr");
            this.putValue("ShortDescription", "Clears Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetDomainsClear();
        }
    }

    public class SetDomainsSetAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetDomainsSetAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Set");
            this.putValue("ShortDescription", "Set Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetDomainsSet();
        }
    }

    public class SetSousRemoveAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetSousRemoveAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "-");
            this.putValue("ShortDescription", "Remove Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetSousRemove();
        }
    }

    public class SetSousAddAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetSousAddAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "+");
            this.putValue("ShortDescription", "Add Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetSousAdd();
        }
    }

    public class SetSousClearAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetSousClearAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Clr");
            this.putValue("ShortDescription", "Clears Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetSousClear();
        }
    }

    public class SetSousSetAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetSousSetAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Set");
            this.putValue("ShortDescription", "Set Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetSousSet();
        }
    }

    public class SetFieldsRemoveAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetFieldsRemoveAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "-");
            this.putValue("ShortDescription", "Remove Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetFieldsRemove();
        }
    }

    public class SetFieldsAddAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetFieldsAddAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "+");
            this.putValue("ShortDescription", "Add Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetFieldsAdd();
        }
    }

    public class SetFieldsClearAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetFieldsClearAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Clr");
            this.putValue("ShortDescription", "Clears Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetFieldsClear();
        }
    }

    public class SetFieldsSetAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public SetFieldsSetAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Set");
            this.putValue("ShortDescription", "Set Fields Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doSetFieldsSet();
        }
    }

    public class FilterDomainsRemoveAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterDomainsRemoveAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "-");
            this.putValue("ShortDescription", "Remove Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterDomainsRemove();
        }
    }

    public class FilterDomainsAddAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterDomainsAddAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "+");
            this.putValue("ShortDescription", "Add Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterDomainsAdd();
        }
    }

    public class FilterDomainsClearAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterDomainsClearAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Clr");
            this.putValue("ShortDescription", "Clears Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterDomainsClear();
        }
    }

    public class FilterDomainsSetAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterDomainsSetAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Set");
            this.putValue("ShortDescription", "Set Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterDomainsSet();
        }
    }

    public class FilterSousRemoveAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterSousRemoveAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "-");
            this.putValue("ShortDescription", "Remove Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterSousRemove();
        }
    }

    public class FilterSousAddAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterSousAddAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "+");
            this.putValue("ShortDescription", "Add Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterSousAdd();
        }
    }

    public class FilterSousClearAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterSousClearAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Clr");
            this.putValue("ShortDescription", "Clears Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterSousClear();
        }
    }

    public class FilterSousSetAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterSousSetAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Set");
            this.putValue("ShortDescription", "Set Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterSousSet();
        }
    }

    public class FilterFieldsRemoveAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterFieldsRemoveAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "-");
            this.putValue("ShortDescription", "Remove Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterFieldsRemove();
        }
    }

    public class FilterFieldsAddAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterFieldsAddAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "+");
            this.putValue("ShortDescription", "Add Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterFieldsAdd();
        }
    }

    public class FilterFieldsClearAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterFieldsClearAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Clr");
            this.putValue("ShortDescription", "Clears Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterFieldsClear();
        }
    }

    public class FilterFieldsSetAction
    extends UnitsAction {
        private static final long serialVersionUID = 1L;

        public FilterFieldsSetAction(UnitsCmdItf unitsCmdItf) {
            super(unitsCmdItf);
            this.putValue("Name", "Set");
            this.putValue("ShortDescription", "Set Fields Filter Elements");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.getItf().doFilterFieldsSet();
        }
    }

    public abstract class UnitsAction
    extends AbstractAction {
        UnitsCmdItf uif;

        public UnitsAction(UnitsCmdItf unitsCmdItf) {
            this.uif = unitsCmdItf;
        }

        public UnitsCmdItf getItf() {
            return this.uif;
        }
    }
}

