/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.ui.util.Dialog;
import de.admadic.units.core.AbstractConverter;
import de.admadic.units.core.ConverterContext;
import de.admadic.units.core.ConverterIdent;
import de.admadic.units.core.ConverterLin;
import de.admadic.units.core.ConverterMul;
import de.admadic.units.core.Domain;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.SubstUnit;
import de.admadic.units.core.UnitManager;
import de.admadic.units.ui.ActionFunction;
import de.admadic.units.ui.ConverterEditPanel;
import de.admadic.units.ui.UnitsUiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SubstUnitDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    IUnit baseUnit;
    JTextField textBaseUnit;
    JButton btnTakeBU;
    JTextField textId;
    JTextField textSymbol;
    JTextField textName;
    JComboBox comboDomain;
    JComboBox comboFactors;
    JCheckBox checkFactor;
    ConverterEditPanel panelConv;
    JButton btnOK;
    JButton btnCancel;
    SubstUnit editUnit;
    boolean editMode;
    static final String CMD_OK = "ok";
    static final String CMD_CANCEL = "cancel";
    ActionFunction af;
    ActionFunction afTake;
    UnitManager um;

    public SubstUnitDialog(Frame frame, UnitManager unitManager, ActionFunction actionFunction, ActionFunction actionFunction2) throws HeadlessException {
        super(frame);
        this.um = unitManager;
        this.af = actionFunction;
        this.afTake = actionFunction2;
        this.initContents();
    }

    public SubstUnitDialog(java.awt.Dialog dialog, ActionFunction actionFunction) throws HeadlessException {
        super(dialog);
        this.af = actionFunction;
        this.initContents();
    }

    protected void initContents() {
        FormLayout formLayout = new FormLayout("12px, p, 5px, p:grow, 5px, p, 12px", "12px, p, 5px, p, 5px, p, 5px, p, 5px, p, 5px, p, 5px, p, 5px, p, 12px, p, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(formLayout);
        this.setTitle("New BaseUnit");
        container.add((Component)new JLabel("Base Unit:"), cellConstraints.xy(2, 2));
        this.textBaseUnit = new JTextField();
        container.add((Component)this.textBaseUnit, cellConstraints.xy(4, 2));
        this.btnTakeBU = new JButton("Take");
        container.add((Component)this.btnTakeBU, cellConstraints.xy(6, 2));
        this.btnTakeBU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SubstUnitDialog.this.afTake.run(null);
            }
        });
        container.add((Component)new JLabel("Id:"), cellConstraints.xy(2, 4));
        this.textId = new JTextField();
        container.add((Component)this.textId, cellConstraints.xy(4, 4));
        container.add((Component)new JLabel("Symbol:"), cellConstraints.xy(2, 6));
        this.textSymbol = new JTextField();
        container.add((Component)this.textSymbol, cellConstraints.xy(4, 6));
        container.add((Component)new JLabel("Name:"), cellConstraints.xy(2, 8));
        this.textName = new JTextField();
        container.add((Component)this.textName, cellConstraints.xy(4, 8));
        container.add((Component)new JLabel("Domain:"), cellConstraints.xy(2, 10));
        this.comboDomain = UnitsUiUtil.createDomainsComboBox(this.um);
        container.add((Component)this.comboDomain, cellConstraints.xy(4, 10));
        container.add((Component)new JLabel("Factor:"), cellConstraints.xy(2, 12));
        this.comboFactors = UnitsUiUtil.createFactorsComboBox(this.um);
        container.add((Component)this.comboFactors, cellConstraints.xy(4, 12));
        this.checkFactor = new JCheckBox();
        container.add((Component)this.checkFactor, cellConstraints.xy(6, 12));
        container.add((Component)new JLabel("Converter:"), cellConstraints.xy(2, 14));
        this.panelConv = new ConverterEditPanel();
        container.add((Component)this.panelConv, cellConstraints.xywh(2, 16, 3, 1));
        this.checkFactor.setSelected(true);
        this.checkFactor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SubstUnitDialog.this.comboFactors.setEnabled(itemEvent.getStateChange() == 1);
            }
        });
        this.checkFactor.setSelected(false);
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, cellConstraints.xywh(2, 18, 3, 1));
        this.btnOK = new JButton("Add");
        this.btnOK.setActionCommand(CMD_OK);
        this.btnOK.addActionListener(this);
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Close");
        this.btnCancel.setActionCommand(CMD_CANCEL);
        this.btnCancel.addActionListener(this);
        jPanel.add(this.btnCancel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void setBaseUnit(IUnit iUnit) {
        this.baseUnit = iUnit;
        this.updateBaseUnit();
    }

    public IUnit getBaseUnit() {
        return this.baseUnit;
    }

    protected void updateBaseUnit() {
        this.textBaseUnit.setText(this.baseUnit.getSymbol() + ": " + this.baseUnit.getName());
        Domain domain = this.baseUnit.getDomain();
        int n = this.um.getDomains().indexOf(domain);
        this.comboDomain.setSelectedIndex(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OK)) {
            Object[] objectArray = new Object[7];
            objectArray[0] = this.textId.getText();
            objectArray[1] = this.textSymbol.getText();
            objectArray[2] = this.textName.getText();
            int n = this.comboDomain.getSelectedIndex();
            objectArray[3] = this.um.getDomains().get(n).getId();
            objectArray[4] = null;
            if (this.checkFactor.isSelected()) {
                int n2 = this.comboFactors.getSelectedIndex();
                objectArray[4] = this.um.getFactors().get(n2);
            }
            objectArray[5] = null;
            if (this.panelConv.getType() != 0) {
                AbstractConverter abstractConverter = null;
                Double d = null;
                Double d2 = null;
                String string2 = null;
                String string3 = null;
                switch (this.panelConv.getType()) {
                    case 1: {
                        abstractConverter = new ConverterIdent();
                        break;
                    }
                    case 2: {
                        d = Double.valueOf(this.panelConv.getParamM());
                        string2 = this.panelConv.getParamXM();
                        abstractConverter = new ConverterMul(d);
                        if (string2 == null || string2.equals("")) break;
                        ((AbstractConverter)abstractConverter).setContext(new ConverterContext());
                        abstractConverter.getContext().add("xm", string2);
                        break;
                    }
                    case 3: {
                        d = Double.valueOf(this.panelConv.getParamM());
                        d2 = Double.valueOf(this.panelConv.getParamN());
                        string2 = this.panelConv.getParamXM();
                        string3 = this.panelConv.getParamXN();
                        abstractConverter = new ConverterLin(d, d2);
                        ConverterContext converterContext = null;
                        if (string2 != null && !string2.equals("")) {
                            if (converterContext == null) {
                                converterContext = new ConverterContext();
                                abstractConverter.setContext(converterContext);
                            }
                            abstractConverter.getContext().add("xm", string2);
                        }
                        if (string3 != null && !string3.equals("") && converterContext == null) {
                            converterContext = new ConverterContext();
                            abstractConverter.setContext(converterContext);
                        }
                        abstractConverter.getContext().add("xn", string3);
                    }
                }
                objectArray[5] = abstractConverter;
            }
            objectArray[6] = this.baseUnit;
            if (!this.af.run(objectArray)) {
                return;
            }
            this.clearData();
            this.setResultCode(1);
        } else if (string.equals(CMD_CANCEL)) {
            if (this.isEditMode()) {
                this.setEditMode(false);
                this.clearData();
            }
            this.setResultCode(2);
            this.setVisible(false);
        }
    }

    protected void clearData() {
        this.panelConv.setParamM("1.0");
        this.panelConv.setParamXM("");
        this.panelConv.setParamN("0.0");
        this.panelConv.setParamXN("");
    }

    public void editUnit(SubstUnit substUnit) {
        this.setEditMode(true);
        this.editUnit = substUnit;
        this.setBaseUnit(substUnit.getBaseUnit());
        this.textId.setText(substUnit.getId());
        this.textSymbol.setText(substUnit.getSymbol());
        this.textName.setText(substUnit.getName());
        int n = this.um.getDomains().indexOf(substUnit.getDomain());
        this.comboDomain.setSelectedIndex(n);
        if (substUnit.getFactor() == null) {
            this.checkFactor.setSelected(false);
        } else {
            this.checkFactor.setSelected(true);
            int n2 = this.um.getFactors().indexOf(substUnit.getFactor());
            this.comboFactors.setSelectedIndex(n2);
        }
        IConverter iConverter = substUnit.getSubstConverter();
        ConverterContext converterContext = null;
        if (iConverter != null) {
            converterContext = iConverter.getContext();
        }
        if (iConverter == null) {
            this.panelConv.setType(0);
        } else if (iConverter instanceof ConverterIdent) {
            this.panelConv.setType(1);
        } else if (iConverter instanceof ConverterMul) {
            this.panelConv.setType(2);
            ConverterMul converterMul = (ConverterMul)iConverter;
            this.panelConv.setParamM(converterMul.getM().toString());
            String string = null;
            if (converterContext != null) {
                string = converterContext.getValue("xm");
            }
            if (string != null) {
                this.panelConv.setParamXM(string);
            }
        } else if (iConverter instanceof ConverterLin) {
            this.panelConv.setType(3);
            ConverterLin converterLin = (ConverterLin)iConverter;
            this.panelConv.setParamM(converterLin.getM().toString());
            String string = null;
            if (converterContext != null) {
                string = converterContext.getValue("xm");
            }
            if (string != null) {
                this.panelConv.setParamXM(string);
            }
            this.panelConv.setParamN(converterLin.getN().toString());
            String string2 = null;
            if (converterContext != null) {
                string2 = converterContext.getValue("xn");
            }
            if (string2 != null) {
                this.panelConv.setParamXN(string2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Unknown Converter: " + iConverter.getClass().getSimpleName(), "Unknown Converter", 0);
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean bl) {
        this.editMode = bl;
        if (!bl) {
            this.editUnit = null;
        }
        if (bl) {
            this.btnOK.setText("Change");
            this.btnCancel.setText("Close");
        } else {
            this.btnOK.setText("Add");
            this.btnCancel.setText("Close");
        }
    }

    public SubstUnit getEditUnit() {
        return this.editUnit;
    }
}

