/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.units.core.Domain;
import de.admadic.units.core.IField;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.SubField;
import de.admadic.units.core.SystemOfUnits;
import de.admadic.units.core.UnitContext;
import de.admadic.units.core.UnitFilter;
import de.admadic.units.core.UnitManager;
import de.admadic.units.ui.DomainsPanel;
import de.admadic.units.ui.FieldsPanel;
import de.admadic.units.ui.SoUPanel;
import de.admadic.units.ui.UnitsActions;
import de.admadic.units.ui.UnitsCmdItf;
import de.admadic.units.ui.UnitsTablePanel;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ManageFrame
extends JFrame
implements UnitsCmdItf {
    UnitManager unitManager;
    UnitsActions ua;
    UnitFilter unitFilter;
    JPanel panelMain;
    FieldsPanel fieldsFilterPanel;
    SoUPanel sousFilterPanel;
    DomainsPanel domainsFilterPanel;
    JPanel setPanels;
    JPanel filterPanels;
    FieldsPanel fieldsSetPanel;
    SoUPanel sousSetPanel;
    DomainsPanel domainsSetPanel;
    UnitsTablePanel unitsPanel;
    private static final long serialVersionUID = 1L;

    public ManageFrame(UnitManager unitManager) throws HeadlessException {
        super("Unit Management");
        this.unitManager = unitManager;
        this.ua = new UnitsActions(this);
        this.unitFilter = new UnitFilter(this.unitManager);
        this.initContents();
    }

    public void initContents() {
        this.panelMain = (JPanel)this.getContentPane();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                ManageFrame.this.setVisible(false);
                ManageFrame.this.dispose();
            }
        });
        FormLayout formLayout = new FormLayout("12px, p:grow, 5px, p, 12px", "12px, p, 5px, p:grow, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        this.panelMain.setLayout(formLayout);
        this.filterPanels = new JPanel();
        this.panelMain.add((Component)this.filterPanels, cellConstraints.xy(2, 2));
        FormLayout formLayout2 = new FormLayout("0px, p, 5px, p, 5px, p, 0px", "0px, p, 0px");
        CellConstraints cellConstraints2 = new CellConstraints();
        this.filterPanels.setLayout(formLayout2);
        this.fieldsFilterPanel = new FieldsPanel(this.unitManager, this.ua, true, false);
        this.filterPanels.add((Component)this.fieldsFilterPanel, cellConstraints2.xy(2, 2));
        this.sousFilterPanel = new SoUPanel(this.unitManager, this.ua, true, false);
        this.filterPanels.add((Component)this.sousFilterPanel, cellConstraints2.xy(4, 2));
        this.domainsFilterPanel = new DomainsPanel(this.unitManager, this.ua, true, false);
        this.filterPanels.add((Component)this.domainsFilterPanel, cellConstraints2.xy(6, 2));
        this.unitsPanel = new UnitsTablePanel(this.unitManager, this.unitFilter, this);
        this.panelMain.add((Component)this.unitsPanel, cellConstraints.xy(2, 4, CellConstraints.FILL, CellConstraints.FILL));
        this.setPanels = new JPanel();
        this.panelMain.add((Component)this.setPanels, cellConstraints.xy(4, 4));
        formLayout2 = new FormLayout("0px, p, 0px", "0px, p, 5px, p, 5px, p, 0px");
        cellConstraints2 = new CellConstraints();
        this.setPanels.setLayout(formLayout2);
        this.fieldsSetPanel = new FieldsPanel(this.unitManager, this.ua, false, true);
        this.setPanels.add((Component)this.fieldsSetPanel, cellConstraints2.xy(2, 2));
        this.sousSetPanel = new SoUPanel(this.unitManager, this.ua, false, true);
        this.setPanels.add((Component)this.sousSetPanel, cellConstraints2.xy(2, 4));
        this.domainsSetPanel = new DomainsPanel(this.unitManager, this.ua, false, true);
        this.setPanels.add((Component)this.domainsSetPanel, cellConstraints2.xy(2, 6));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void doFilterFieldsSet() {
        IField[] iFieldArray = this.fieldsFilterPanel.getSelectedFields();
        this.unitFilter.clearFields();
        for (IField iField : iFieldArray) {
            if (!(iField instanceof SubField)) continue;
            this.unitFilter.addField(iField);
        }
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterFieldsClear() {
        this.unitFilter.clearFields();
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterFieldsAdd() {
        IField[] iFieldArray;
        for (IField iField : iFieldArray = this.fieldsFilterPanel.getSelectedFields()) {
            if (!(iField instanceof SubField)) continue;
            this.unitFilter.addField(iField);
        }
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterFieldsRemove() {
        IField[] iFieldArray = this.fieldsFilterPanel.getSelectedFields();
        this.unitFilter.clearFields();
        for (IField iField : iFieldArray) {
            if (!(iField instanceof SubField)) continue;
            this.unitFilter.removeField(iField);
        }
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterSousSet() {
        SystemOfUnits[] systemOfUnitsArray = this.sousFilterPanel.getSelectedSous();
        this.unitFilter.clearSystemOfUnits();
        for (SystemOfUnits systemOfUnits : systemOfUnitsArray) {
            this.unitFilter.addSystemOfUnits(systemOfUnits);
        }
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterSousClear() {
        this.unitFilter.clearSystemOfUnits();
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterSousAdd() {
        SystemOfUnits[] systemOfUnitsArray;
        for (SystemOfUnits systemOfUnits : systemOfUnitsArray = this.sousFilterPanel.getSelectedSous()) {
            this.unitFilter.addSystemOfUnits(systemOfUnits);
        }
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterSousRemove() {
        SystemOfUnits[] systemOfUnitsArray;
        for (SystemOfUnits systemOfUnits : systemOfUnitsArray = this.sousFilterPanel.getSelectedSous()) {
            this.unitFilter.removeSystemOfUnits(systemOfUnits);
        }
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterDomainsSet() {
        Domain[] domainArray = this.domainsFilterPanel.getSelectedDomains();
        this.unitFilter.clearDomains();
        for (Domain domain : domainArray) {
            this.unitFilter.addDomain(domain);
        }
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterDomainsClear() {
        this.unitFilter.clearDomains();
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterDomainsAdd() {
        Domain[] domainArray;
        for (Domain domain : domainArray = this.domainsFilterPanel.getSelectedDomains()) {
            this.unitFilter.addDomain(domain);
        }
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doFilterDomainsRemove() {
        Domain[] domainArray;
        for (Domain domain : domainArray = this.domainsFilterPanel.getSelectedDomains()) {
            this.unitFilter.removeDomain(domain);
        }
        this.unitsPanel.updateFilter();
    }

    @Override
    public void doSetFieldsSet() {
        IUnit[] iUnitArray;
        IField[] iFieldArray = this.fieldsSetPanel.getSelectedFields();
        for (IUnit iUnit : iUnitArray = this.unitsPanel.getSelectedUnits()) {
            UnitContext unitContext = iUnit.getContext();
            unitContext.clearFields();
            for (IField iField : iFieldArray) {
                if (!(iField instanceof SubField)) continue;
                unitContext.addSubField((SubField)iField);
            }
            iUnit.touchLastChange();
        }
        this.unitsPanel.fireUnitsTableChanged();
    }

    @Override
    public void doSetFieldsClear() {
        IUnit[] iUnitArray;
        for (IUnit iUnit : iUnitArray = this.unitsPanel.getSelectedUnits()) {
            UnitContext unitContext = iUnit.getContext();
            unitContext.clearFields();
            iUnit.touchLastChange();
        }
        this.unitsPanel.fireUnitsTableChanged();
    }

    @Override
    public void doSetFieldsAdd() {
        IUnit[] iUnitArray;
        IField[] iFieldArray = this.fieldsSetPanel.getSelectedFields();
        for (IUnit iUnit : iUnitArray = this.unitsPanel.getSelectedUnits()) {
            UnitContext unitContext = iUnit.getContext();
            for (IField iField : iFieldArray) {
                if (!(iField instanceof SubField)) continue;
                unitContext.addSubField((SubField)iField);
            }
            iUnit.touchLastChange();
        }
        this.unitsPanel.fireUnitsTableChanged();
    }

    @Override
    public void doSetFieldsRemove() {
        IUnit[] iUnitArray;
        IField[] iFieldArray = this.fieldsSetPanel.getSelectedFields();
        for (IUnit iUnit : iUnitArray = this.unitsPanel.getSelectedUnits()) {
            UnitContext unitContext = iUnit.getContext();
            for (IField iField : iFieldArray) {
                if (!(iField instanceof SubField)) continue;
                unitContext.removeSubField((SubField)iField);
            }
            iUnit.touchLastChange();
        }
        this.unitsPanel.fireUnitsTableChanged();
    }

    @Override
    public void doSetSousSet() {
        IUnit[] iUnitArray;
        SystemOfUnits[] systemOfUnitsArray = this.sousSetPanel.getSelectedSous();
        for (IUnit iUnit : iUnitArray = this.unitsPanel.getSelectedUnits()) {
            UnitContext unitContext = iUnit.getContext();
            unitContext.clearSous();
            for (SystemOfUnits systemOfUnits : systemOfUnitsArray) {
                unitContext.addSystemOfUnits(systemOfUnits);
            }
            iUnit.touchLastChange();
        }
        this.unitsPanel.fireUnitsTableChanged();
    }

    @Override
    public void doSetSousClear() {
        IUnit[] iUnitArray;
        for (IUnit iUnit : iUnitArray = this.unitsPanel.getSelectedUnits()) {
            UnitContext unitContext = iUnit.getContext();
            unitContext.clearSous();
            iUnit.touchLastChange();
        }
        this.unitsPanel.fireUnitsTableChanged();
    }

    @Override
    public void doSetSousAdd() {
        IUnit[] iUnitArray;
        SystemOfUnits[] systemOfUnitsArray = this.sousSetPanel.getSelectedSous();
        for (IUnit iUnit : iUnitArray = this.unitsPanel.getSelectedUnits()) {
            UnitContext unitContext = iUnit.getContext();
            for (SystemOfUnits systemOfUnits : systemOfUnitsArray) {
                unitContext.addSystemOfUnits(systemOfUnits);
            }
            iUnit.touchLastChange();
        }
        this.unitsPanel.fireUnitsTableChanged();
    }

    @Override
    public void doSetSousRemove() {
        IUnit[] iUnitArray;
        SystemOfUnits[] systemOfUnitsArray = this.sousSetPanel.getSelectedSous();
        for (IUnit iUnit : iUnitArray = this.unitsPanel.getSelectedUnits()) {
            UnitContext unitContext = iUnit.getContext();
            for (SystemOfUnits systemOfUnits : systemOfUnitsArray) {
                unitContext.removeSystemOfUnits(systemOfUnits);
            }
            iUnit.touchLastChange();
        }
        this.unitsPanel.fireUnitsTableChanged();
    }

    @Override
    public void doSetDomainsSet() {
    }

    @Override
    public void doSetDomainsClear() {
    }

    @Override
    public void doSetDomainsAdd() {
    }

    @Override
    public void doSetDomainsRemove() {
    }
}

