/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.units.core.Field;
import de.admadic.units.core.IField;
import de.admadic.units.core.SubField;
import de.admadic.units.core.UnitManager;
import de.admadic.units.ui.UnitsActions;
import de.admadic.units.ui.UnitsUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FieldsPanel
extends JPanel {
    UnitManager um;
    UnitsActions ua;
    JTree treeFields;
    JScrollPane scrollFields;
    boolean enaFil;
    boolean enaSet;
    private static final long serialVersionUID = 1L;

    public FieldsPanel(UnitManager unitManager, UnitsActions unitsActions, boolean bl, boolean bl2) {
        this.enaFil = bl;
        this.enaSet = bl2;
        this.um = unitManager;
        this.ua = unitsActions;
        this.initContents();
    }

    public void initContents() {
        JPanel jPanel;
        FormLayout formLayout = new FormLayout("12px, p, 5px, p:grow, 12px", "12px, p:grow, 5px, p, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        this.setLayout(formLayout);
        this.treeFields = new FieldsTree();
        this.scrollFields = new JScrollPane(this.treeFields, 22, 32);
        this.scrollFields.setPreferredSize(new Dimension(200, 150));
        this.createData();
        this.add((Component)this.scrollFields, cellConstraints.xy(4, 2));
        if (this.enaFil) {
            jPanel = new JPanel();
            this.add((Component)jPanel, cellConstraints.xy(4, 4));
            UnitsUiUtil.createHorizontalButtonPanel(jPanel, new AbstractButton[]{new JButton(this.ua.getAction(UnitsActions.FilterFieldsSetAction.class)), new JButton(this.ua.getAction(UnitsActions.FilterFieldsClearAction.class)), new JButton(this.ua.getAction(UnitsActions.FilterFieldsAddAction.class)), new JButton(this.ua.getAction(UnitsActions.FilterFieldsRemoveAction.class))});
        }
        if (this.enaSet) {
            jPanel = new JPanel();
            this.add((Component)jPanel, cellConstraints.xy(2, 2));
            UnitsUiUtil.createVerticalButtonPanel(jPanel, new AbstractButton[]{new JButton(this.ua.getAction(UnitsActions.SetFieldsSetAction.class)), new JButton(this.ua.getAction(UnitsActions.SetFieldsClearAction.class)), new JButton(this.ua.getAction(UnitsActions.SetFieldsAddAction.class)), new JButton(this.ua.getAction(UnitsActions.SetFieldsRemoveAction.class))});
        }
    }

    private void createData() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
        Hashtable<Field, DefaultMutableTreeNode> hashtable = new Hashtable<Field, DefaultMutableTreeNode>();
        for (Field iField : this.um.getFields()) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(iField);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            hashtable.put(iField, defaultMutableTreeNode);
        }
        for (SubField subField : this.um.getSubFields()) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(subField);
            ((DefaultMutableTreeNode)hashtable.get(subField.getField())).add(defaultMutableTreeNode);
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode2);
        this.treeFields.setModel(defaultTreeModel);
        this.treeFields.setRootVisible(false);
    }

    public IField[] getSelectedFields() {
        IField[] iFieldArray = null;
        TreePath[] treePathArray = this.treeFields.getSelectionPaths();
        iFieldArray = new IField[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            TreePath treePath = treePathArray[i];
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            iFieldArray[i] = (IField)defaultMutableTreeNode.getUserObject();
        }
        return iFieldArray;
    }

    public static class FieldsTree
    extends JTree {
        private static final long serialVersionUID = 1L;

        @Override
        public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (object != null) {
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 != null && object2 instanceof Field) {
                    return ((Field)object2).getName();
                }
                if (object2 != null && object2 instanceof SubField) {
                    return ((SubField)object2).getName();
                }
                return super.convertValueToText(object, bl, bl2, bl3, n, bl4);
            }
            return super.convertValueToText(object, bl, bl2, bl3, n, bl4);
        }
    }
}

