/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.ui.util.Dialog;
import de.admadic.units.core.Domain;
import de.admadic.units.core.FactorUnit;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.UnitManager;
import de.admadic.units.ui.ActionFunction;
import de.admadic.units.ui.UnitsUiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FactorUnitDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    IUnit baseUnit;
    JTextField textBaseUnit;
    JButton btnTakeBU;
    JComboBox comboDomain;
    JComboBox comboFactors;
    JButton btnOK;
    JButton btnCancel;
    static final String CMD_OK = "ok";
    static final String CMD_CANCEL = "cancel";
    ActionFunction af;
    ActionFunction afTake;
    UnitManager um;
    boolean editMode;
    FactorUnit editUnit;

    public FactorUnitDialog(Frame frame, UnitManager unitManager, ActionFunction actionFunction, ActionFunction actionFunction2) throws HeadlessException {
        super(frame);
        this.um = unitManager;
        this.af = actionFunction;
        this.afTake = actionFunction2;
        this.initContents();
    }

    public FactorUnitDialog(java.awt.Dialog dialog, ActionFunction actionFunction) throws HeadlessException {
        super(dialog);
        this.af = actionFunction;
        this.initContents();
    }

    protected void initContents() {
        FormLayout formLayout = new FormLayout("12px, p, 5px, p:grow, 5px, p, 12px", "12px, p, 5px, p, 5px, p, 5px, p, 12px, p, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(formLayout);
        this.setTitle("New FactorUnit");
        container.add((Component)new JLabel("Base Unit:"), cellConstraints.xy(2, 2));
        this.textBaseUnit = new JTextField();
        container.add((Component)this.textBaseUnit, cellConstraints.xy(4, 2));
        this.btnTakeBU = new JButton("Take");
        container.add((Component)this.btnTakeBU, cellConstraints.xy(6, 2));
        this.btnTakeBU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FactorUnitDialog.this.afTake.run(null);
            }
        });
        container.add((Component)new JLabel("Domain:"), cellConstraints.xy(2, 4));
        this.comboDomain = UnitsUiUtil.createDomainsComboBox(this.um);
        container.add((Component)this.comboDomain, cellConstraints.xy(4, 4));
        container.add((Component)new JLabel("Factor:"), cellConstraints.xy(2, 6));
        this.comboFactors = UnitsUiUtil.createFactorsComboBox(this.um);
        container.add((Component)this.comboFactors, cellConstraints.xy(4, 6));
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, cellConstraints.xywh(2, 8, 3, 1));
        this.btnOK = new JButton("Add");
        this.btnOK.setActionCommand(CMD_OK);
        this.btnOK.addActionListener(this);
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Close");
        this.btnCancel.setActionCommand(CMD_CANCEL);
        this.btnCancel.addActionListener(this);
        jPanel.add(this.btnCancel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void setBaseUnit(IUnit iUnit) {
        this.baseUnit = iUnit;
        this.updateBaseUnit();
    }

    public IUnit getBaseUnit() {
        return this.baseUnit;
    }

    protected void updateBaseUnit() {
        this.textBaseUnit.setText(this.baseUnit.getSymbol() + ": " + this.baseUnit.getName());
        Domain domain = this.baseUnit.getDomain();
        int n = this.um.getDomains().indexOf(domain);
        this.comboDomain.setSelectedIndex(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OK)) {
            Object[] objectArray = new Object[3];
            int n = this.comboDomain.getSelectedIndex();
            objectArray[0] = this.um.getDomains().get(n);
            int n2 = this.comboFactors.getSelectedIndex();
            objectArray[1] = this.um.getFactors().get(n2);
            objectArray[2] = this.baseUnit;
            if (!this.af.run(objectArray)) {
                return;
            }
            this.setResultCode(1);
        } else if (string.equals(CMD_CANCEL)) {
            this.setResultCode(2);
            this.setVisible(false);
        }
    }

    public void editUnit(FactorUnit factorUnit) {
        this.setEditMode(true);
        this.editUnit = factorUnit;
        this.setBaseUnit(factorUnit.getBaseUnit());
        int n = this.um.getDomains().indexOf(factorUnit.getDomain());
        this.comboDomain.setSelectedIndex(n);
        int n2 = this.um.getFactors().indexOf(factorUnit.getFactor());
        this.comboFactors.setSelectedIndex(n2);
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean bl) {
        this.editMode = bl;
        if (!bl) {
            this.editUnit = null;
        }
        if (bl) {
            this.btnOK.setText("Change");
            this.btnCancel.setText("Close");
        } else {
            this.btnOK.setText("Add");
            this.btnCancel.setText("Close");
        }
    }

    public FactorUnit getEditUnit() {
        return this.editUnit;
    }
}

