/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.ui.util.ListElementAccessor;
import de.admadic.ui.util.ListRefListModel;
import de.admadic.units.core.Domain;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.UnitManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConvertPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    UnitManager um;
    JLabel labelDomains;
    JList listDomains;
    JScrollPane scrollDomains;
    ListRefListModel listModelDomains;
    ListElementAccessor listAccessorDomains;
    Vector<Domain> dataDomains;
    JList listSourceUnit;
    JList listDestinationUnit;
    ListRefListModel listModelUnits;
    ListElementAccessor listAccessorUnits;
    JScrollPane scrollSourceUnit;
    JScrollPane scrollDestinationUnit;
    Vector<IUnit> dataUnits;
    JLabel labelSource;
    JLabel labelDestination;
    JComboBox comboSource;
    JComboBox comboDestination;
    JButton btnConvert;
    JButton btnIConvert;
    JLabel labelUnitSource;
    JLabel labelUnitDestination;
    JLabel labelNameSource;
    JLabel labelNameDestination;
    IUnit unitSource;
    IUnit unitDestination;

    public ConvertPanel(UnitManager unitManager) {
        this.um = unitManager;
        this.initContents();
    }

    public void initContents() {
        FormLayout formLayout = new FormLayout("12px, p:grow(0.5), 5px, p, 12px, p, 5px, p:grow(0.5), 12px", "12px, p, 5px, p:grow(0.5), 5px, p:grow(0.5), 12px, p, 5px, p, 5px, p, 5px, p, 12px");
        this.setLayout(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this.labelDomains = new JLabel("Domains:");
        this.listDomains = new JList();
        this.scrollDomains = new JScrollPane(this.listDomains, 22, 32);
        this.listSourceUnit = new JList();
        this.listDestinationUnit = new JList();
        this.scrollSourceUnit = new JScrollPane(this.listSourceUnit, 22, 30);
        this.scrollDestinationUnit = new JScrollPane(this.listDestinationUnit, 22, 30);
        this.labelSource = new JLabel("Source:");
        this.labelDestination = new JLabel("Destination:");
        this.comboSource = new JComboBox();
        this.comboDestination = new JComboBox();
        this.labelUnitSource = new JLabel("(unit)");
        this.labelUnitDestination = new JLabel("(unit)");
        this.labelNameSource = new JLabel("(name)");
        this.labelNameDestination = new JLabel("(name)");
        this.btnConvert = new JButton("=>");
        this.btnIConvert = new JButton("<=");
        this.add((Component)this.labelDomains, cellConstraints.xywh(2, 2, 7, 1));
        this.add((Component)this.scrollDomains, cellConstraints.xywh(2, 4, 7, 1));
        this.add((Component)this.scrollSourceUnit, cellConstraints.xywh(2, 6, 3, 1));
        this.add((Component)this.scrollDestinationUnit, cellConstraints.xywh(6, 6, 3, 1));
        this.add((Component)this.labelSource, cellConstraints.xy(2, 8));
        this.add((Component)this.comboSource, cellConstraints.xy(2, 10));
        this.add((Component)this.labelUnitSource, cellConstraints.xy(2, 12));
        this.add((Component)this.labelNameSource, cellConstraints.xy(2, 14));
        this.add((Component)this.btnConvert, cellConstraints.xy(4, 10));
        this.add((Component)this.btnIConvert, cellConstraints.xy(6, 10));
        this.add((Component)this.labelDestination, cellConstraints.xy(8, 8));
        this.add((Component)this.comboDestination, cellConstraints.xy(8, 10));
        this.add((Component)this.labelUnitDestination, cellConstraints.xy(8, 12));
        this.add((Component)this.labelNameDestination, cellConstraints.xy(8, 14));
        this.dataDomains = this.um.getDomains();
        this.listModelDomains = new ListRefListModel();
        this.listModelDomains.setData(this.dataDomains);
        this.listAccessorDomains = new ListElementAccessor(){

            @Override
            public Object getElement(Object object) {
                return ((Domain)object).getName();
            }
        };
        this.listDomains.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ConvertPanel.this.updateUnitLists();
            }
        });
        this.listModelDomains.setElementAccessor(this.listAccessorDomains);
        this.listDomains.setModel(this.listModelDomains);
        this.listDomains.setLayoutOrientation(1);
        this.dataUnits = this.um.getUnits();
        this.listModelUnits = new ListRefListModel();
        this.listModelUnits.setData(this.dataUnits);
        this.listAccessorUnits = new ListElementAccessor(){

            @Override
            public Object getElement(Object object) {
                return ((IUnit)object).getSymbol() + " / " + ((IUnit)object).getName();
            }
        };
        this.listModelUnits.setElementAccessor(this.listAccessorUnits);
        this.listSourceUnit.setModel(this.listModelUnits);
        this.listDestinationUnit.setModel(this.listModelUnits);
        this.listSourceUnit.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ConvertPanel.this.updateUnitSource();
                ConvertPanel.this.updateCalculation();
            }
        });
        this.listDestinationUnit.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ConvertPanel.this.updateUnitDestination();
                ConvertPanel.this.updateCalculation();
            }
        });
        this.comboSource.setEditable(true);
        this.comboDestination.setEditable(true);
        this.comboSource.getEditor().setItem("1.0");
        this.btnConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertPanel.this.updateCalculation();
            }
        });
        this.btnIConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertPanel.this.updateICalculation();
            }
        });
    }

    protected void updateUnitLists() {
        int n = this.listDomains.getSelectedIndex();
        if (n < 0) {
            this.dataUnits.clear();
        } else {
            Domain domain = this.dataDomains.get(n);
            this.dataUnits = this.um.getUnitsForDomain(domain, this.dataUnits);
        }
        this.listModelUnits.fireContentsChanged();
    }

    protected void updateUnitSource() {
        int n = this.listSourceUnit.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.unitSource = this.dataUnits.get(n);
        if (this.unitSource != null) {
            this.labelUnitSource.setText(this.unitSource.getSymbol());
            this.labelNameSource.setText(this.unitSource.getName());
        } else {
            this.labelUnitSource.setText("-");
            this.labelNameSource.setText("-");
        }
    }

    protected void updateUnitDestination() {
        int n = this.listDestinationUnit.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.unitDestination = this.dataUnits.get(n);
        if (this.unitDestination != null) {
            this.labelUnitDestination.setText(this.unitDestination.getSymbol());
            this.labelNameDestination.setText(this.unitDestination.getName());
        } else {
            this.labelUnitDestination.setText("-");
            this.labelNameDestination.setText("-");
        }
    }

    protected void updateCalculation() {
        if (this.unitSource == null) {
            return;
        }
        if (this.unitDestination == null) {
            return;
        }
        IConverter iConverter = this.unitSource.getRootConverter();
        IConverter iConverter2 = this.unitDestination.getRootConverter();
        Double d = Double.valueOf((String)this.comboSource.getEditor().getItem());
        d = iConverter.convert(d);
        d = iConverter2.iconvert(d);
        this.comboDestination.getEditor().setItem(d.toString());
    }

    protected void updateICalculation() {
        if (this.unitSource == null) {
            return;
        }
        if (this.unitDestination == null) {
            return;
        }
        IConverter iConverter = this.unitSource.getRootConverter();
        IConverter iConverter2 = this.unitDestination.getRootConverter();
        Double d = Double.valueOf((String)this.comboSource.getEditor().getItem());
        d = iConverter.convert(d);
        d = iConverter2.iconvert(d);
        this.comboDestination.getEditor().setItem(d.toString());
    }
}

