/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.ui.util.Dialog;
import de.admadic.ui.util.ListElementAccessor;
import de.admadic.ui.util.ListRefListModel;
import de.admadic.units.core.CompositeUnit;
import de.admadic.units.core.Domain;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.UnitManager;
import de.admadic.units.ui.ActionFunction;
import de.admadic.units.ui.UnitsUiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CompUnitDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JComboBox comboDomain;
    JTextField textCurDisplay;
    JList listMulUnits;
    JScrollPane scrollMulUnits;
    JList listDivUnits;
    JScrollPane scrollDivUnits;
    ListRefListModel lmMul;
    ListRefListModel lmDiv;
    Vector<IUnit> vecMuls;
    Vector<IUnit> vecDivs;
    JButton btnOK;
    JButton btnCancel;
    CompositeUnit editUnit;
    boolean editMode;
    static final String CMD_OK = "ok";
    static final String CMD_CANCEL = "cancel";
    static final String CMD_TAKE_PREINIT = "cmd.take.preinit";
    static final String CMD_TAKE_MUL = "cmd.take.mul";
    static final String CMD_REMOVE_MUL = "cmd.rem.mul";
    static final String CMD_UP_MUL = "cmd.up.mul";
    static final String CMD_DOWN_MUL = "cmd.down.mul";
    static final String CMD_TAKE_DIV = "cmd.take.div";
    static final String CMD_REMOVE_DIV = "cmd.rem.div";
    static final String CMD_UP_DIV = "cmd.up.div";
    static final String CMD_DOWN_DIV = "cmd.down.div";
    ActionFunction afCreate;
    ActionFunction afTakePreinit;
    ActionFunction afTakeMul;
    ActionFunction afTakeDiv;
    UnitManager um;

    public CompUnitDialog(Frame frame, UnitManager unitManager) throws HeadlessException {
        super(frame);
        this.um = unitManager;
        this.initContents();
    }

    public CompUnitDialog(java.awt.Dialog dialog) throws HeadlessException {
        super(dialog);
        this.initContents();
    }

    public void setActions(ActionFunction actionFunction, ActionFunction actionFunction2, ActionFunction actionFunction3, ActionFunction actionFunction4) {
        this.afCreate = actionFunction;
        this.afTakePreinit = actionFunction2;
        this.afTakeMul = actionFunction3;
        this.afTakeDiv = actionFunction4;
    }

    protected void initContents() {
        FormLayout formLayout = new FormLayout("12px, p, 5px, p:grow, 5px, p, 12px", "12px, p, 5px, p, 5px, p, 5px, p, 12px, p, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        this.vecMuls = new Vector();
        this.vecDivs = new Vector();
        Container container = this.getContentPane();
        container.setLayout(formLayout);
        this.setTitle("New Composite Unit");
        container.add((Component)new JLabel("Domain:"), cellConstraints.xy(2, 2));
        this.comboDomain = UnitsUiUtil.createDomainsComboBox(this.um);
        container.add((Component)this.comboDomain, cellConstraints.xy(4, 2));
        container.add((Component)new JLabel("Display:"), cellConstraints.xy(2, 4));
        this.textCurDisplay = new JTextField();
        container.add((Component)this.textCurDisplay, cellConstraints.xy(4, 4));
        this.listMulUnits = new JList();
        this.scrollMulUnits = new JScrollPane(this.listMulUnits, 22, 30);
        this.listMulUnits.setVisibleRowCount(4);
        this.listDivUnits = new JList();
        this.scrollDivUnits = new JScrollPane(this.listDivUnits, 22, 30);
        this.listDivUnits.setVisibleRowCount(4);
        this.lmMul = new ListRefListModel();
        this.lmMul.setData(this.vecMuls);
        this.lmMul.setElementAccessor(new ListElementAccessor(){

            @Override
            public Object getElement(Object object) {
                IUnit iUnit = (IUnit)object;
                return iUnit.getSymbol() + " - " + iUnit.getName();
            }
        });
        this.listMulUnits.setModel(this.lmMul);
        this.lmDiv = new ListRefListModel();
        this.lmDiv.setData(this.vecDivs);
        this.lmDiv.setElementAccessor(new ListElementAccessor(){

            @Override
            public Object getElement(Object object) {
                IUnit iUnit = (IUnit)object;
                return iUnit.getSymbol() + " - " + iUnit.getName();
            }
        });
        this.listDivUnits.setModel(this.lmDiv);
        container.add((Component)new JLabel("Multiply:"), cellConstraints.xy(2, 6));
        container.add((Component)this.scrollMulUnits, cellConstraints.xy(4, 6));
        container.add((Component)new JLabel("Divide:"), cellConstraints.xy(2, 8));
        container.add((Component)this.scrollDivUnits, cellConstraints.xy(4, 8));
        JComponent jComponent = new JButton("Take Pre-Init");
        ((AbstractButton)jComponent).setActionCommand(CMD_TAKE_PREINIT);
        ((AbstractButton)jComponent).addActionListener(this);
        this.add((Component)jComponent, cellConstraints.xy(6, 4));
        jComponent = new JPanel();
        this.add((Component)jComponent, cellConstraints.xy(6, 6));
        jComponent.setLayout(new FormLayout("0px, p, 5px, p, 0px", "0px, p, 5px, p, 0px"));
        CellConstraints cellConstraints2 = new CellConstraints();
        JButton jButton = new JButton("Take");
        jButton.setActionCommand(CMD_TAKE_MUL);
        jButton.addActionListener(this);
        jComponent.add((Component)jButton, cellConstraints2.xy(2, 2));
        jButton = new JButton("Remove");
        jButton.setActionCommand(CMD_REMOVE_MUL);
        jButton.addActionListener(this);
        jComponent.add((Component)jButton, cellConstraints2.xy(2, 4));
        jButton = new JButton("Up");
        jButton.setActionCommand(CMD_UP_MUL);
        jButton.addActionListener(this);
        jComponent.add((Component)jButton, cellConstraints2.xy(4, 2));
        jButton = new JButton("Down");
        jButton.setActionCommand(CMD_DOWN_MUL);
        jButton.addActionListener(this);
        jComponent.add((Component)jButton, cellConstraints2.xy(4, 4));
        jComponent = new JPanel();
        this.add((Component)jComponent, cellConstraints.xy(6, 8));
        jComponent.setLayout(new FormLayout("0px, p, 5px, p, 0px", "0px, p, 5px, p, 0px"));
        cellConstraints2 = new CellConstraints();
        jButton = new JButton("Take");
        jButton.setActionCommand(CMD_TAKE_DIV);
        jButton.addActionListener(this);
        jComponent.add((Component)jButton, cellConstraints2.xy(2, 2));
        jButton = new JButton("Remove");
        jButton.setActionCommand(CMD_REMOVE_DIV);
        jButton.addActionListener(this);
        jComponent.add((Component)jButton, cellConstraints2.xy(2, 4));
        jButton = new JButton("Up");
        jButton.setActionCommand(CMD_UP_DIV);
        jButton.addActionListener(this);
        jComponent.add((Component)jButton, cellConstraints2.xy(4, 2));
        jButton = new JButton("Down");
        jButton.setActionCommand(CMD_DOWN_DIV);
        jButton.addActionListener(this);
        jComponent.add((Component)jButton, cellConstraints2.xy(4, 4));
        jComponent = new JPanel();
        container.add((Component)jComponent, cellConstraints.xywh(2, 10, 3, 1));
        this.btnOK = new JButton("Add");
        this.btnOK.setActionCommand(CMD_OK);
        this.btnOK.addActionListener(this);
        jComponent.add(this.btnOK);
        this.btnCancel = new JButton("Close");
        this.btnCancel.setActionCommand(CMD_CANCEL);
        this.btnCancel.addActionListener(this);
        jComponent.add(this.btnCancel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void addMulUnit(IUnit iUnit) {
        this.vecMuls.add(iUnit);
        this.lmMul.fireContentsChanged();
    }

    public void addDivUnit(IUnit iUnit) {
        this.vecDivs.add(iUnit);
        this.lmDiv.fireContentsChanged();
    }

    public void setDomain(Domain domain) {
        int n = this.um.getDomains().indexOf(domain);
        this.comboDomain.setSelectedIndex(n);
    }

    public void setPreInit(IUnit iUnit) {
        if (!(iUnit instanceof CompositeUnit)) {
            return;
        }
        CompositeUnit compositeUnit = (CompositeUnit)iUnit;
        Domain domain = compositeUnit.getDomain();
        this.setDomain(domain);
        this.vecMuls.addAll(compositeUnit.getUnits(0));
        this.vecDivs.addAll(compositeUnit.getUnits(1));
        this.lmMul.fireContentsChanged();
        this.lmDiv.fireContentsChanged();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OK)) {
            Object[] objectArray = new Object[3];
            int n2 = this.comboDomain.getSelectedIndex();
            objectArray[0] = this.um.getDomains().get(n2).getId();
            objectArray[1] = this.vecMuls;
            objectArray[2] = this.vecDivs;
            if (!this.afCreate.run(objectArray)) {
                return;
            }
            this.clearData();
            this.setResultCode(1);
        } else if (string.equals(CMD_CANCEL)) {
            if (this.isEditMode()) {
                this.setEditMode(false);
                this.clearData();
            }
            this.setResultCode(2);
            this.setVisible(false);
        } else if (string.equals(CMD_TAKE_PREINIT)) {
            this.afTakePreinit.run(null);
        } else if (string.equals(CMD_TAKE_MUL)) {
            this.afTakeMul.run(null);
        } else if (string.equals(CMD_TAKE_DIV)) {
            this.afTakeDiv.run(null);
        } else if (string.equals(CMD_REMOVE_MUL)) {
            int[] nArray = this.listMulUnits.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.vecMuls.remove(nArray[i]);
            }
            this.lmMul.fireContentsChanged();
        } else if (string.equals(CMD_REMOVE_DIV)) {
            int[] nArray = this.listDivUnits.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.vecDivs.remove(nArray[i]);
            }
            this.lmDiv.fireContentsChanged();
        } else if (string.equals(CMD_UP_MUL)) {
            int n3 = this.listMulUnits.getSelectedIndex();
            if (n3 > 0) {
                Collections.swap(this.vecMuls, n3, n3 - 1);
                this.listMulUnits.setSelectedIndex(n3 - 1);
            }
        } else if (string.equals(CMD_UP_DIV)) {
            int n4 = this.listDivUnits.getSelectedIndex();
            if (n4 > 0) {
                Collections.swap(this.vecDivs, n4, n4 - 1);
                this.listDivUnits.setSelectedIndex(n4 - 1);
            }
        } else if (string.equals(CMD_DOWN_MUL)) {
            int n5 = this.listMulUnits.getSelectedIndex();
            if (n5 < this.vecMuls.size() - 1) {
                Collections.swap(this.vecMuls, n5, n5 + 1);
                this.listMulUnits.setSelectedIndex(n5 + 1);
            }
        } else if (string.equals(CMD_DOWN_DIV) && (n = this.listDivUnits.getSelectedIndex()) < this.vecDivs.size() - 1) {
            Collections.swap(this.vecDivs, n, n + 1);
            this.listDivUnits.setSelectedIndex(n + 1);
        }
    }

    protected void clearData() {
        this.vecMuls.clear();
        this.vecDivs.clear();
        this.lmMul.fireContentsChanged();
        this.lmDiv.fireContentsChanged();
    }

    public void editUnit(CompositeUnit compositeUnit) {
        this.setEditMode(true);
        this.editUnit = compositeUnit;
        this.setPreInit(compositeUnit);
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean bl) {
        this.editMode = bl;
        if (!bl) {
            this.editUnit = null;
        }
        if (bl) {
            this.btnOK.setText("Change");
            this.btnCancel.setText("Close");
        } else {
            this.btnOK.setText("Add");
            this.btnCancel.setText("Close");
        }
    }

    public CompositeUnit getEditUnit() {
        return this.editUnit;
    }
}

