/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.ui.util.Dialog;
import de.admadic.units.core.BaseUnit;
import de.admadic.units.core.UnitManager;
import de.admadic.units.ui.ActionFunction;
import de.admadic.units.ui.UnitsUiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BaseUnitDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JTextField textId;
    JTextField textSymbol;
    JTextField textName;
    JComboBox comboDomain;
    JButton btnOK;
    JButton btnCancel;
    static final String CMD_OK = "ok";
    static final String CMD_CANCEL = "cancel";
    ActionFunction af;
    UnitManager um;
    BaseUnit editUnit;
    boolean editMode;

    public BaseUnitDialog(Frame frame, UnitManager unitManager, ActionFunction actionFunction) throws HeadlessException {
        super(frame);
        this.um = unitManager;
        this.af = actionFunction;
        this.initContents();
    }

    public BaseUnitDialog(java.awt.Dialog dialog, ActionFunction actionFunction) throws HeadlessException {
        super(dialog);
        this.af = actionFunction;
        this.initContents();
    }

    protected void initContents() {
        FormLayout formLayout = new FormLayout("12px, p, 5px, p:grow, 12px", "12px, p, 5px, p, 5px, p, 5px, p, 12px, p, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(formLayout);
        this.setTitle("New BaseUnit");
        container.add((Component)new JLabel("Id:"), cellConstraints.xy(2, 2));
        this.textId = new JTextField();
        container.add((Component)this.textId, cellConstraints.xy(4, 2));
        container.add((Component)new JLabel("Symbol:"), cellConstraints.xy(2, 4));
        this.textSymbol = new JTextField();
        container.add((Component)this.textSymbol, cellConstraints.xy(4, 4));
        container.add((Component)new JLabel("Name:"), cellConstraints.xy(2, 6));
        this.textName = new JTextField();
        container.add((Component)this.textName, cellConstraints.xy(4, 6));
        container.add((Component)new JLabel("Domain:"), cellConstraints.xy(2, 8));
        this.comboDomain = UnitsUiUtil.createDomainsComboBox(this.um);
        container.add((Component)this.comboDomain, cellConstraints.xy(4, 8));
        JPanel jPanel = new JPanel();
        container.add((Component)jPanel, cellConstraints.xywh(2, 10, 3, 1));
        this.btnOK = new JButton("Add");
        this.btnOK.setActionCommand(CMD_OK);
        this.btnOK.addActionListener(this);
        jPanel.add(this.btnOK);
        this.btnCancel = new JButton("Close");
        this.btnCancel.setActionCommand(CMD_CANCEL);
        this.btnCancel.addActionListener(this);
        jPanel.add(this.btnCancel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OK)) {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.textId.getText();
            objectArray[1] = this.textSymbol.getText();
            objectArray[2] = this.textName.getText();
            int n = this.comboDomain.getSelectedIndex();
            objectArray[3] = this.um.getDomains().get(n).getId();
            if (!this.af.run(objectArray)) {
                return;
            }
            this.setResultCode(1);
        } else if (string.equals(CMD_CANCEL)) {
            this.setResultCode(2);
            this.setVisible(false);
        }
    }

    public void editUnit(BaseUnit baseUnit) {
        this.setEditMode(true);
        this.editUnit = baseUnit;
        this.textId.setText(baseUnit.getId());
        this.textSymbol.setText(baseUnit.getSymbol());
        this.textName.setText(baseUnit.getName());
        int n = this.um.getDomains().indexOf(baseUnit.getDomain());
        this.comboDomain.setSelectedIndex(n);
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean bl) {
        this.editMode = bl;
        if (!bl) {
            this.editUnit = null;
        }
        if (bl) {
            this.btnOK.setText("Change");
            this.btnCancel.setText("Close");
        } else {
            this.btnOK.setText("Add");
            this.btnCancel.setText("Close");
        }
    }

    public BaseUnit getEditUnit() {
        return this.editUnit;
    }
}

