/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.AbstractConverter;
import de.admadic.units.core.BaseUnit;
import de.admadic.units.core.CompositeUnit;
import de.admadic.units.core.ConverterContext;
import de.admadic.units.core.ConverterIdent;
import de.admadic.units.core.ConverterLin;
import de.admadic.units.core.ConverterMul;
import de.admadic.units.core.Domain;
import de.admadic.units.core.Factor;
import de.admadic.units.core.FactorUnit;
import de.admadic.units.core.Field;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IQuantity;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.SubField;
import de.admadic.units.core.SubstUnit;
import de.admadic.units.core.SystemOfUnits;
import de.admadic.units.core.UnitContext;
import de.admadic.units.core.UnitFactory;
import de.admadic.units.core.UnitManager;
import de.admadic.units.core.UnitsIoError;
import de.admadic.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParserFactory;
import net.n3.nanoxml.XMLWriter;

public class UnitsIo {
    UnitManager um;
    DateFormat df;
    DateFormat fallbackDf;

    public UnitsIo(UnitManager unitManager) {
        this.um = unitManager;
    }

    public void readFile(File file) {
        block5: {
            try {
                String string = file.toString();
                string = FileUtil.fixFileName1(string);
                IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
                IXMLReader iXMLReader = StdXMLReader.fileReader(string);
                iXMLParser.setReader(iXMLReader);
                IXMLElement iXMLElement = (IXMLElement)iXMLParser.parse();
                String string2 = iXMLElement.getName();
                if (string2.equals("unitdef")) {
                    this.readUnitDef(iXMLElement);
                    break block5;
                }
                if (string2.equals("quantdef")) {
                    this.readQuantDef(iXMLElement);
                    break block5;
                }
                if (string2.equals("measdef")) {
                    this.readMeasDef(iXMLElement);
                    break block5;
                }
                throw new UnitsIoError("invalid root: only unitdef, quantdef, measdef allowed.");
            }
            catch (Exception exception) {
                throw new UnitsIoError("Load Error: " + exception.getMessage());
            }
        }
    }

    public void readFile(URL uRL) {
        block5: {
            try {
                IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
                StdXMLReader stdXMLReader = new StdXMLReader(null, uRL.toString());
                iXMLParser.setReader(stdXMLReader);
                IXMLElement iXMLElement = (IXMLElement)iXMLParser.parse();
                String string = iXMLElement.getName();
                if (string.equals("unitdef")) {
                    this.readUnitDef(iXMLElement);
                    break block5;
                }
                if (string.equals("quantdef")) {
                    this.readQuantDef(iXMLElement);
                    break block5;
                }
                if (string.equals("measdef")) {
                    this.readMeasDef(iXMLElement);
                    break block5;
                }
                throw new UnitsIoError("invalid root: only unitdef, quantdef, measdef allowed.");
            }
            catch (Exception exception) {
                throw new UnitsIoError("Load Error: " + exception.getMessage());
            }
        }
    }

    protected void saveImpl(IXMLElement iXMLElement, File file) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            ((Writer)fileWriter).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            IXMLElement iXMLElement2 = iXMLElement;
            XMLWriter xMLWriter = new XMLWriter(fileWriter);
            xMLWriter.write(iXMLElement2, true);
        }
        catch (IOException iOException) {
            throw new UnitsIoError("Save Error: " + iOException.getMessage());
        }
    }

    public void saveFileUnits(File file) {
        XMLElement xMLElement = new XMLElement("unitdef");
        this.createFields(xMLElement);
        this.createSubFields(xMLElement);
        this.createSystemOfUnits(xMLElement);
        this.createDomains(xMLElement);
        this.createFactors(xMLElement);
        this.createUnits(xMLElement);
        this.createUnitContexts(xMLElement);
        this.saveImpl(xMLElement, file);
    }

    public void saveFileQuantities(File file) {
        XMLElement xMLElement = new XMLElement("quantdef");
        this.createQuantities(xMLElement);
        this.saveImpl(xMLElement, file);
    }

    protected void readUnitDef(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildren();
        for (IXMLElement iXMLElement2 : vector) {
            String string = iXMLElement2.getName();
            if (string.equals("units")) {
                this.readUnits(iXMLElement2);
                continue;
            }
            if (string.equals("unitcontexts")) {
                this.readUnitContexts(iXMLElement2);
                continue;
            }
            if (string.equals("factors")) {
                this.readFactors(iXMLElement2);
                continue;
            }
            if (string.equals("domains")) {
                this.readDomains(iXMLElement2);
                continue;
            }
            if (string.equals("fields")) {
                this.readFields(iXMLElement2);
                continue;
            }
            if (string.equals("subfields")) {
                this.readSubFields(iXMLElement2);
                continue;
            }
            if (!string.equals("systemofunits")) continue;
            this.readSystemOfUnits(iXMLElement2);
        }
    }

    protected void readUnitContexts(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("uc");
        for (IXMLElement iXMLElement2 : vector) {
            Object object;
            int n;
            String[] stringArray;
            Object object2;
            String string = iXMLElement2.getAttribute("dom", null);
            String string2 = iXMLElement2.getAttribute("uid", null);
            IUnit iUnit = this.um.getUnitFromDomain(string2, string);
            if (iUnit == null) {
                throw new UnitsIoError("could not find unit with " + string + "/" + string2);
            }
            UnitContext unitContext = iUnit.getContext();
            unitContext.clear();
            String string3 = iXMLElement2.getAttribute("sou", null);
            if (string3 != null) {
                object2 = string3.split(",");
                stringArray = object2;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String string4 = stringArray[n];
                    object = this.um.getSystemOfUnits(string4);
                    unitContext.addSystemOfUnits((SystemOfUnits)object);
                }
            }
            if ((object2 = iXMLElement2.getAttribute("sf", null)) == null) continue;
            String[] stringArray2 = stringArray = ((String)object2).split(",");
            n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                object = stringArray2[i];
                SubField subField = this.um.getSubField((String)object);
                unitContext.addSubField(subField);
            }
        }
    }

    protected void readDomains(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("domain");
        for (IXMLElement iXMLElement2 : vector) {
            String string = iXMLElement2.getAttribute("id", null);
            String string2 = iXMLElement2.getAttribute("name", null);
            Domain domain = UnitFactory.createDomain(string, string2);
            this.um.addDomain(domain);
        }
    }

    protected void readFields(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("field");
        for (IXMLElement iXMLElement2 : vector) {
            String string = iXMLElement2.getAttribute("id", null);
            String string2 = iXMLElement2.getAttribute("name", null);
            Field field = UnitFactory.createField(string, string2);
            this.um.addField(field);
        }
    }

    protected void readSubFields(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("subfield");
        for (IXMLElement iXMLElement2 : vector) {
            String string = iXMLElement2.getAttribute("fid", null);
            String string2 = iXMLElement2.getAttribute("id", null);
            String string3 = iXMLElement2.getAttribute("name", null);
            SubField subField = UnitFactory.createSubField(this.um, string, string2, string3);
            this.um.addSubField(subField);
        }
    }

    protected void readSystemOfUnits(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("sou");
        for (IXMLElement iXMLElement2 : vector) {
            String string = iXMLElement2.getAttribute("id", null);
            String string2 = iXMLElement2.getAttribute("symbol", null);
            String string3 = iXMLElement2.getAttribute("name", null);
            SystemOfUnits systemOfUnits = UnitFactory.createSystemOfUnits(string, string2, string3);
            this.um.addSystemOfUnits(systemOfUnits);
        }
    }

    protected void readFactors(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("factor");
        for (IXMLElement iXMLElement2 : vector) {
            String string = iXMLElement2.getAttribute("id", null);
            String string2 = iXMLElement2.getAttribute("symbol", null);
            String string3 = iXMLElement2.getAttribute("name", null);
            String string4 = iXMLElement2.getAttribute("value", null);
            Factor factor = this.createFactor(string, string2, string3, string4);
            this.um.addFactor(factor);
        }
    }

    protected Factor createFactor(String string, String string2, String string3, String string4) {
        double d = Double.parseDouble(string4);
        return new Factor(string, string2, string3, d);
    }

    protected void readUnits(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildren();
        for (IXMLElement iXMLElement2 : vector) {
            String string = iXMLElement2.getName();
            if (string.equals("baseunit")) {
                this.readBaseUnit(iXMLElement2);
                continue;
            }
            if (string.equals("compunit")) {
                this.readCompUnit(iXMLElement2);
                continue;
            }
            if (string.equals("substunit")) {
                this.readSubstUnit(iXMLElement2);
                continue;
            }
            if (!string.equals("factorunit")) continue;
            this.readFactorUnit(iXMLElement2);
        }
    }

    protected int convertStringToQtyId(String string) {
        if ((string = string.toLowerCase()).equals("length")) {
            return 1;
        }
        if (string.equals("time")) {
            return 2;
        }
        if (string.equals("mass")) {
            return 3;
        }
        if (string.equals("temperature")) {
            return 4;
        }
        if (string.equals("elcurrent")) {
            return 5;
        }
        if (string.equals("luminosity")) {
            return 6;
        }
        if (string.equals("amtsubstance")) {
            return 7;
        }
        throw new UnitsIoError("Invalid qtyId: " + string);
    }

    protected void readBaseUnit(IXMLElement iXMLElement) {
        String string = iXMLElement.getAttribute("id", null);
        String string2 = iXMLElement.getAttribute("symbol", null);
        String string3 = iXMLElement.getAttribute("name", null);
        String string4 = iXMLElement.getAttribute("dom", null);
        Domain domain = null;
        if (string4 != null) {
            domain = this.um.getDomain(string4);
        }
        BaseUnit baseUnit = new BaseUnit(domain, string, string2, string3);
        String string5 = iXMLElement.getAttribute("ts", null);
        Date date = null;
        if (string5 != null && !string5.equals("")) {
            date = this.decodeTime(string5);
        }
        if (date != null) {
            baseUnit.setLastChange(date);
        }
        this.checkUnit(baseUnit);
        this.um.addUnit(baseUnit);
    }

    protected void readFactorUnit(IXMLElement iXMLElement) {
        String string = iXMLElement.getAttribute("dom", null);
        String string2 = iXMLElement.getAttribute("ubasid", null);
        String string3 = iXMLElement.getAttribute("fid", null);
        Domain domain = null;
        Factor factor = null;
        IUnit iUnit = null;
        if (string == null || string3 == null || string2 == null) {
            throw new UnitsIoError("factor unit must have domain, ubasid and fid!");
        }
        domain = this.um.getDomain(string);
        factor = this.um.getFactor(string3);
        iUnit = this.um.getUnit(string2);
        FactorUnit factorUnit = new FactorUnit(domain, iUnit, factor);
        String string4 = iXMLElement.getAttribute("ts", null);
        Date date = null;
        if (string4 != null && !string4.equals("")) {
            date = this.decodeTime(string4);
        }
        if (date != null) {
            factorUnit.setLastChange(date);
        }
        this.checkUnit(factorUnit);
        this.um.addUnit(factorUnit);
    }

    protected void checkUnit(IUnit iUnit) {
        if (this.um.existsUnit(iUnit.getId())) {
            System.out.println("Warning: a unit with the id " + iUnit.getId() + " already exists (this is " + iUnit.getName() + ")");
        }
    }

    protected void readCompUnit(IXMLElement iXMLElement) {
        Object object;
        Object object3;
        CompositeUnit compositeUnit = new CompositeUnit();
        String string = iXMLElement.getAttribute("dom", null);
        Domain domain = null;
        if (string != null) {
            domain = this.um.getDomain(string);
        }
        compositeUnit.setDomain(domain);
        String string2 = iXMLElement.getAttribute("idvec", null);
        if (string2 != null) {
            block5: for (String string3 : object3 = string2.split("(?=\\.|\\*|\\:|\\/)")) {
                if (string3.equals("")) continue;
                char c = string3.charAt(0);
                switch (c) {
                    case '*': {
                        compositeUnit.setFactor(this.um.getFactor(string3));
                        continue block5;
                    }
                    case '.': {
                        compositeUnit.appendUnit(this.um.getUnit(string3), 0);
                        continue block5;
                    }
                    case ':': {
                        object = "." + string3.substring(1);
                        compositeUnit.appendUnit(this.um.getUnit((String)object), 1);
                        continue block5;
                    }
                    default: {
                        throw new UnitsIoError("op code in idvec not supported: " + c);
                    }
                }
            }
        }
        if ((object3 = iXMLElement.getAttribute("ubasid", null)) != null) {
            compositeUnit.appendUnit(this.um.getUnit((String)object3), 0);
        }
        String string4 = iXMLElement.getAttribute("substid", null);
        String string5 = iXMLElement.getAttribute("substsymbol", null);
        String string6 = iXMLElement.getAttribute("substname", null);
        if (string4 != null || string5 != null || string6 != null) {
            if (string4 == null || string5 == null || string6 == null) {
                throw new UnitsIoError("if then all of subst* attributes must be set");
            }
            compositeUnit.setSubst(string4, string5, string6);
        }
        Vector vector = iXMLElement.getChildren();
        for (IXMLElement iXMLElement2 : vector) {
            Object object2;
            object = iXMLElement2.getName();
            if (((String)object).equals("ufac")) {
                object2 = iXMLElement2.getAttribute("id", null);
                compositeUnit.setFactor(this.um.getFactor((String)object2));
                continue;
            }
            if (((String)object).equals("ubas")) {
                object2 = iXMLElement2.getAttribute("id", null);
                compositeUnit.appendUnit(this.um.getUnit((String)object2), 0);
                continue;
            }
            if (((String)object).equals("umul")) {
                object2 = iXMLElement2.getAttribute("id", null);
                compositeUnit.appendUnit(this.um.getUnit((String)object2), 0);
                continue;
            }
            if (((String)object).equals("udiv")) {
                object2 = iXMLElement2.getAttribute("id", null);
                compositeUnit.appendUnit(this.um.getUnit((String)object2), 1);
                continue;
            }
            if (((String)object).equals("subst")) {
                object2 = iXMLElement2.getAttribute("id", null);
                String string7 = iXMLElement2.getAttribute("symbol", null);
                String string8 = iXMLElement2.getAttribute("name", null);
                compositeUnit.setSubst((String)object2, string7, string8);
                continue;
            }
            if (!((String)object).equals("converter")) continue;
            object2 = this.readConverter(iXMLElement2);
            compositeUnit.setBaseConverter((IConverter)object2);
        }
        String string9 = iXMLElement.getAttribute("ts", null);
        Date date = null;
        if (string9 != null && !string9.equals("")) {
            date = this.decodeTime(string9);
        }
        if (date != null) {
            compositeUnit.setLastChange(date);
        }
        this.checkUnit(compositeUnit);
        this.um.addUnit(compositeUnit);
    }

    protected void readSubstUnit(IXMLElement iXMLElement) {
        Object object;
        Object object22;
        String string;
        IUnit iUnit = null;
        Factor factor = null;
        IConverter iConverter = null;
        String string2 = iXMLElement.getAttribute("id", null);
        String string3 = iXMLElement.getAttribute("symbol", null);
        String string4 = iXMLElement.getAttribute("name", null);
        String string5 = iXMLElement.getAttribute("dom", null);
        Domain domain = null;
        if (string5 != null) {
            domain = this.um.getDomain(string5);
        }
        if ((string = iXMLElement.getAttribute("ubasid", null)) != null) {
            iUnit = this.um.getUnit(string);
            if (string != null && iUnit == null) {
                throw new UnitsIoError("Could not find unit " + string);
            }
        }
        if (!(string2 == null && string3 == null && string4 == null || string2 != null && string3 != null && string4 != null)) {
            throw new UnitsIoError("if then all of subst* attributes must be set");
        }
        Vector vector = iXMLElement.getChildren();
        for (Object object22 : vector) {
            String string6;
            object = object22.getName();
            if (((String)object).equals("ufac")) {
                string6 = object22.getAttribute("id", null);
                factor = this.um.getFactor(string2);
                continue;
            }
            if (((String)object).equals("ubas")) {
                string6 = object22.getAttribute("id", null);
                iUnit = this.um.getUnit(string2);
                if (string6 == null || iUnit != null) continue;
                throw new UnitsIoError("Could not find unit " + string6);
            }
            if (!((String)object).equals("converter")) continue;
            iConverter = this.readConverter((IXMLElement)object22);
        }
        SubstUnit substUnit = new SubstUnit(string2, string3, string4, iUnit);
        if (iConverter != null) {
            substUnit.setSubstConverter(iConverter);
        }
        if (factor != null) {
            substUnit.setFactor(factor);
        }
        substUnit.setDomain(domain);
        object22 = iXMLElement.getAttribute("ts", null);
        object = null;
        if (object22 != null && !((String)object22).equals("")) {
            object = this.decodeTime((String)object22);
        }
        if (object != null) {
            substUnit.setLastChange((Date)object);
        }
        this.checkUnit(substUnit);
        this.um.addUnit(substUnit);
    }

    protected IConverter readConverter(IXMLElement iXMLElement) {
        AbstractConverter abstractConverter = null;
        Double d = null;
        Double d2 = null;
        String string = iXMLElement.getAttribute("type", null);
        ConverterContext converterContext = null;
        String string2 = iXMLElement.getAttribute("m", null);
        String string3 = iXMLElement.getAttribute("n", null);
        String string4 = iXMLElement.getAttribute("xm", null);
        String string5 = iXMLElement.getAttribute("xn", null);
        if (string4 != null || string5 != null) {
            converterContext = new ConverterContext();
        }
        if (string2 != null) {
            d = Double.valueOf(string2);
        }
        if (string3 != null) {
            d2 = Double.valueOf(string3);
        }
        if (string4 != null) {
            d = this.evaluateXValue(string4);
        }
        if (string5 != null) {
            d2 = this.evaluateXValue(string5);
        }
        if (string4 != null) {
            converterContext.add("xm", string4);
        }
        if (string5 != null) {
            converterContext.add("xn", string5);
        }
        Vector vector = iXMLElement.getChildrenNamed("param");
        for (IXMLElement iXMLElement2 : vector) {
            String string6 = iXMLElement2.getAttribute("name", null);
            String string7 = iXMLElement2.getAttribute("value", null);
            String string8 = iXMLElement2.getAttribute("xvalue", null);
            Double d3 = Double.valueOf(string7);
            if (string8 != null) {
                if (converterContext == null) {
                    converterContext = new ConverterContext();
                }
                String string9 = null;
                if (string6.equals("m")) {
                    string9 = "xm";
                }
                if (string6.equals("n")) {
                    string9 = "xn";
                }
                if (string9 == null) {
                    throw new UnitsIoError("invalid parameter name in converter: " + string6);
                }
                converterContext.add(string9, string8);
                d3 = this.evaluateXValue(string8);
            }
            if (string6.equals("m")) {
                d = d3;
            }
            if (!string6.equals("n")) continue;
            d2 = d3;
        }
        if (string.equals("mul")) {
            abstractConverter = new ConverterMul(d);
        } else if (string.equals("lin")) {
            abstractConverter = new ConverterLin(d, d2);
        } else if (string.equals("idt")) {
            abstractConverter = new ConverterIdent();
        } else {
            throw new UnitsIoError("converter type not supported: " + string);
        }
        if (converterContext != null) {
            abstractConverter.setContext(converterContext);
        }
        return abstractConverter;
    }

    protected Double evaluateXValue(String string) {
        String[] stringArray;
        double d = 1.0;
        for (String string2 : stringArray = string.split("(?=\\*|\\/)")) {
            if (string2.equals("")) continue;
            int n = string2.charAt(0);
            String string3 = string2.substring(1);
            switch (n) {
                case 47: {
                    break;
                }
                case 42: {
                    break;
                }
                default: {
                    n = 42;
                    string3 = string2;
                }
            }
            double d2 = Double.parseDouble(string3);
            if (n == 42) {
                d *= d2;
                continue;
            }
            d /= d2;
        }
        return d;
    }

    protected void readQuantDef(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildren();
        for (IXMLElement iXMLElement2 : vector) {
            String string = iXMLElement2.getName();
            if (!string.equals("quantities")) continue;
            this.readQuantities(iXMLElement2);
        }
    }

    protected void readQuantities(IXMLElement iXMLElement) {
        Vector vector = iXMLElement.getChildrenNamed("quantity");
        for (IXMLElement iXMLElement2 : vector) {
            String string = iXMLElement2.getAttribute("id", null);
            String string2 = iXMLElement2.getAttribute("symbol", null);
            String string3 = iXMLElement2.getAttribute("name", null);
            String string4 = iXMLElement2.getAttribute("unit", null);
            IQuantity iQuantity = UnitFactory.createQuantity(this.um, string, string2, string3, string4);
            this.um.addQuantity(iQuantity);
        }
    }

    protected void readMeasDef(IXMLElement iXMLElement) {
    }

    protected void createFields(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("fields");
        iXMLElement.addChild(iXMLElement2);
        for (Field field : this.um.getFields()) {
            IXMLElement iXMLElement3 = iXMLElement2.createElement("field");
            iXMLElement2.addChild(iXMLElement3);
            iXMLElement3.setAttribute("id", field.getId());
            iXMLElement3.setAttribute("name", field.getName());
        }
    }

    protected void createSubFields(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("subfields");
        iXMLElement.addChild(iXMLElement2);
        for (SubField subField : this.um.getSubFields()) {
            IXMLElement iXMLElement3 = iXMLElement2.createElement("subfield");
            iXMLElement2.addChild(iXMLElement3);
            iXMLElement3.setAttribute("fid", subField.getField().getId());
            iXMLElement3.setAttribute("id", subField.getId());
            iXMLElement3.setAttribute("name", subField.getName());
        }
    }

    protected void createSystemOfUnits(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("systemofunits");
        iXMLElement.addChild(iXMLElement2);
        for (SystemOfUnits systemOfUnits : this.um.getSystemOfUnits()) {
            IXMLElement iXMLElement3 = iXMLElement2.createElement("sou");
            iXMLElement2.addChild(iXMLElement3);
            iXMLElement3.setAttribute("id", systemOfUnits.getId());
            iXMLElement3.setAttribute("symbol", systemOfUnits.getSymbol());
            iXMLElement3.setAttribute("name", systemOfUnits.getName());
        }
    }

    protected void createDomains(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("domains");
        iXMLElement.addChild(iXMLElement2);
        for (Domain domain : this.um.getDomains()) {
            IXMLElement iXMLElement3 = iXMLElement2.createElement("domain");
            iXMLElement2.addChild(iXMLElement3);
            iXMLElement3.setAttribute("id", domain.getId());
            iXMLElement3.setAttribute("name", domain.getName());
        }
    }

    protected void createFactors(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("factors");
        iXMLElement.addChild(iXMLElement2);
        for (Factor factor : this.um.getFactors()) {
            IXMLElement iXMLElement3 = iXMLElement2.createElement("factor");
            iXMLElement2.addChild(iXMLElement3);
            iXMLElement3.setAttribute("id", factor.getId());
            iXMLElement3.setAttribute("symbol", factor.getSymbol());
            iXMLElement3.setAttribute("name", factor.getName());
            iXMLElement3.setAttribute("value", Double.toString(factor.getFactor()));
        }
    }

    protected void createUnits(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("units");
        iXMLElement.addChild(iXMLElement2);
        for (IUnit iUnit : this.um.getUnits()) {
            if (iUnit instanceof BaseUnit) {
                this.createUnitsBase(iXMLElement2, (BaseUnit)iUnit);
                continue;
            }
            if (iUnit instanceof FactorUnit) {
                this.createUnitsFactor(iXMLElement2, (FactorUnit)iUnit);
                continue;
            }
            if (iUnit instanceof SubstUnit) {
                this.createUnitsSubst(iXMLElement2, (SubstUnit)iUnit);
                continue;
            }
            if (!(iUnit instanceof CompositeUnit)) continue;
            this.createUnitsComp(iXMLElement2, (CompositeUnit)iUnit);
        }
    }

    protected void createUnitsBase(IXMLElement iXMLElement, BaseUnit baseUnit) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("baseunit");
        iXMLElement.addChild(iXMLElement2);
        iXMLElement2.setAttribute("dom", baseUnit.getDomain().getId());
        iXMLElement2.setAttribute("id", baseUnit.getId());
        iXMLElement2.setAttribute("symbol", baseUnit.getSymbol());
        iXMLElement2.setAttribute("name", baseUnit.getName());
        iXMLElement2.setAttribute("ts", this.encodeTime(baseUnit.getLastChange()));
    }

    protected String encodeTime(Date date) {
        if (this.df == null) {
            this.df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            this.df.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return date != null ? this.df.format(date) : "";
    }

    protected Date decodeTime(String string) {
        if (this.df == null) {
            this.df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            this.fallbackDf = DateFormat.getDateTimeInstance(0, 0, Locale.US);
            this.df.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        try {
            return this.df.parse(string);
        }
        catch (ParseException parseException) {
            try {
                return this.fallbackDf.parse(string);
            }
            catch (ParseException parseException2) {
                string = string.replaceFirst("(, [\\d]{4})", "$1 at");
                try {
                    return this.fallbackDf.parse(string);
                }
                catch (ParseException parseException3) {
                    throw new UnitsIoError("Could not parse timestamp: " + string);
                }
            }
        }
    }

    protected void createUnitsFactor(IXMLElement iXMLElement, FactorUnit factorUnit) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("factorunit");
        iXMLElement.addChild(iXMLElement2);
        iXMLElement2.setAttribute("dom", factorUnit.getDomain().getId());
        iXMLElement2.setAttribute("fid", factorUnit.getFactor().getId());
        iXMLElement2.setAttribute("ubasid", factorUnit.getBaseUnit().getId());
        iXMLElement2.setAttribute("ts", this.encodeTime(factorUnit.getLastChange()));
    }

    protected void createUnitsSubst(IXMLElement iXMLElement, SubstUnit substUnit) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("substunit");
        iXMLElement.addChild(iXMLElement2);
        iXMLElement2.setAttribute("dom", substUnit.getDomain().getId());
        iXMLElement2.setAttribute("ubasid", substUnit.getBaseUnit().getId());
        iXMLElement2.setAttribute("id", substUnit.getId());
        iXMLElement2.setAttribute("symbol", substUnit.getSymbol());
        iXMLElement2.setAttribute("name", substUnit.getName());
        iXMLElement2.setAttribute("ts", this.encodeTime(substUnit.getLastChange()));
        if (substUnit.getSubstConverter() != null) {
            this.createUnitsConverter(iXMLElement2, substUnit.getSubstConverter());
        }
    }

    protected void createUnitsConverter(IXMLElement iXMLElement, IConverter iConverter) {
        Object object;
        IXMLElement iXMLElement2 = iXMLElement.createElement("converter");
        iXMLElement.addChild(iXMLElement2);
        String string = null;
        String string2 = null;
        Object object2 = null;
        String string3 = null;
        Object object3 = null;
        if (iConverter instanceof ConverterIdent) {
            string = "idt";
        } else if (iConverter instanceof ConverterMul) {
            string = "mul";
            string2 = ((ConverterMul)iConverter).getM().toString();
        } else if (iConverter instanceof ConverterLin) {
            string = "lin";
            string2 = ((ConverterLin)iConverter).getM().toString();
            string3 = ((ConverterLin)iConverter).getN().toString();
        } else {
            throw new UnitsIoError("invalid converter type: " + iConverter.getClass().getSimpleName());
        }
        iXMLElement2.setAttribute("type", string);
        ConverterContext converterContext = iConverter.getContext();
        if (converterContext != null) {
            object = converterContext.getValue("xm");
            if (object != null) {
                object2 = object;
            }
            if ((object = converterContext.getValue("xn")) != null) {
                object3 = object;
            }
        }
        if (string2 != null) {
            object = iXMLElement2.createElement("param");
            iXMLElement2.addChild((IXMLElement)object);
            object.setAttribute("name", "m");
            object.setAttribute("value", string2);
            if (object2 != null) {
                object.setAttribute("xvalue", (String)object2);
            }
        }
        if (string3 != null) {
            object = iXMLElement2.createElement("param");
            iXMLElement2.addChild((IXMLElement)object);
            object.setAttribute("name", "n");
            object.setAttribute("value", string3);
            if (object3 != null) {
                object.setAttribute("xvalue", (String)object3);
            }
        }
    }

    protected void createUnitsComp(IXMLElement iXMLElement, CompositeUnit compositeUnit) {
        IXMLElement iXMLElement2;
        Vector<IUnit> vector;
        Object object;
        IXMLElement iXMLElement3 = iXMLElement.createElement("compunit");
        iXMLElement.addChild(iXMLElement3);
        iXMLElement3.setAttribute("dom", compositeUnit.getDomain().getId());
        iXMLElement3.setAttribute("ts", this.encodeTime(compositeUnit.getLastChange()));
        String string = compositeUnit.getSubstId();
        String string2 = compositeUnit.getSubstSymbol();
        String string3 = compositeUnit.getSubstName();
        if (string != null || string2 != null || string3 != null) {
            if (string == null || string2 == null || string3 == null) {
                throw new UnitsIoError("subst information structure error");
            }
            object = iXMLElement3.createElement("subst");
            iXMLElement3.addChild((IXMLElement)object);
            object.setAttribute("id", string);
            object.setAttribute("symbol", string2);
            object.setAttribute("name", string3);
        }
        if ((object = compositeUnit.getFactor()) != null) {
            vector = iXMLElement3.createElement("ufac");
            iXMLElement3.addChild((IXMLElement)((Object)vector));
            vector.setAttribute("id", ((Factor)object).getId());
        }
        if (compositeUnit.getBaseConverter() != null) {
            this.createUnitsConverter(iXMLElement3, compositeUnit.getBaseConverter());
        }
        vector = compositeUnit.getUnits(0);
        for (IUnit iUnit : vector) {
            iXMLElement2 = iXMLElement3.createElement("umul");
            iXMLElement3.addChild(iXMLElement2);
            iXMLElement2.setAttribute("id", iUnit.getId());
        }
        vector = compositeUnit.getUnits(1);
        for (IUnit iUnit : vector) {
            iXMLElement2 = iXMLElement3.createElement("udiv");
            iXMLElement3.addChild(iXMLElement2);
            iXMLElement2.setAttribute("id", iUnit.getId());
        }
    }

    protected void createUnitContexts(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("unitcontexts");
        iXMLElement.addChild(iXMLElement2);
        for (IUnit iUnit : this.um.getUnits()) {
            UnitContext unitContext = iUnit.getContext();
            if (unitContext == null) continue;
            IXMLElement iXMLElement3 = iXMLElement2.createElement("uc");
            iXMLElement2.addChild(iXMLElement3);
            iXMLElement3.setAttribute("dom", iUnit.getDomain().getId());
            iXMLElement3.setAttribute("uid", iUnit.getId());
            Object object = null;
            for (SystemOfUnits systemOfUnits : unitContext.getSystemOfUnits()) {
                if (object == null) {
                    object = systemOfUnits.getId();
                    continue;
                }
                object = (String)object + "," + systemOfUnits.getId();
            }
            if (object != null) {
                iXMLElement3.setAttribute("sou", (String)object);
            }
            object = null;
            for (SubField subField : unitContext.getSubFields()) {
                if (object == null) {
                    object = subField.getId();
                    continue;
                }
                object = (String)object + "," + subField.getId();
            }
            if (object == null) continue;
            iXMLElement3.setAttribute("sf", (String)object);
        }
    }

    protected void createQuantities(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = iXMLElement.createElement("quantities");
        iXMLElement.addChild(iXMLElement2);
        for (IQuantity iQuantity : this.um.getQuantities()) {
            IXMLElement iXMLElement3 = iXMLElement2.createElement("quantity");
            iXMLElement2.addChild(iXMLElement3);
            iXMLElement3.setAttribute("id", iQuantity.getId());
            iXMLElement3.setAttribute("symbol", iQuantity.getSymbol());
            iXMLElement3.setAttribute("name", iQuantity.getName());
            iXMLElement3.setAttribute("unit", iQuantity.getUnit().getId());
        }
    }
}

