/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.ConverterMul;
import de.admadic.units.core.Factor;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IMeasure;
import de.admadic.units.core.IQuantity;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.Measure;
import de.admadic.units.core.MeasureFormatter;
import de.admadic.units.core.UnitFactory;
import de.admadic.units.core.UnitManager;
import de.admadic.units.core.UnitsIo;
import java.io.File;
import java.util.Locale;

public class UnitTester {
    UnitManager unitManager = new UnitManager();

    public static void main(String[] stringArray) {
        UnitTester unitTester = new UnitTester();
        unitTester.run();
    }

    private void createFactors() {
        this.unitManager.addFactor(UnitFactory.createFactor("*T", "T", "Tera", 1.0E12));
        this.unitManager.addFactor(UnitFactory.createFactor("*G", "G", "Giga", 1.0E9));
        this.unitManager.addFactor(UnitFactory.createFactor("*M", "M", "Mega", 1000000.0));
        this.unitManager.addFactor(UnitFactory.createFactor("*k", "k", "kilo", 1000.0));
        this.unitManager.addFactor(UnitFactory.createFactor("*c", "c", "centi", 0.01));
        this.unitManager.addFactor(UnitFactory.createFactor("*m", "m", "milli", 0.001));
        this.unitManager.addFactor(UnitFactory.createFactor("*\u00b5", "\u00b5", "micro", 1.0E-6));
        this.unitManager.addFactor(UnitFactory.createFactor("*n", "n", "nano", 1.0E-9));
        this.unitManager.addFactor(UnitFactory.createFactor("*p", "p", "pico", 1.0E-12));
        this.unitManager.addFactor(UnitFactory.createFactor("*f", "f", "femto", 1.0E-15));
    }

    private void createPrimaryUnits() {
        this.unitManager.addUnit(UnitFactory.createUnit(".m", "m", "meter"));
        this.unitManager.addUnit(UnitFactory.createUnit(".s", "s", "second"));
        this.unitManager.addUnit(UnitFactory.createUnit(".g", "g", "gram"));
        this.unitManager.addUnit(UnitFactory.createUnit(".K", "K", "Kelvin"));
        this.unitManager.addUnit(UnitFactory.createUnit(".A", "A", "Ampere"));
        this.unitManager.addUnit(UnitFactory.createUnit(".cd", "cd", "Candela"));
        this.unitManager.addUnit(UnitFactory.createUnit(".mol", "mol", "Mole"));
    }

    private void createOtherUnits() {
        this.unitManager.addUnit(UnitFactory.createUnitFM(this.unitManager, "*k", ".g"));
        this.unitManager.addUnit(UnitFactory.createUnitMD(this.unitManager, ".m", ".s"));
        this.unitManager.addUnit(UnitFactory.createUnitFM(this.unitManager, "*k", ".m"));
        this.unitManager.addUnit(UnitFactory.createUnitFMMDD(this.unitManager, null, "*k.g", ".m", ".s", ".s"));
        this.unitManager.addUnit(UnitFactory.createUnitFSMMDD(this.unitManager, null, ".N", "N", "Newton", "*k.g", ".m", ".s", ".s"));
        this.unitManager.addUnit(UnitFactory.createUnitFSBMD(this.unitManager, null, ".h", "h", "Hour", new ConverterMul(3600.0), ".s", null));
        this.unitManager.addUnit(UnitFactory.createUnitMD(this.unitManager, "*k.m", ".h"));
    }

    private void run() {
        UnitsIo unitsIo = new UnitsIo(this.unitManager);
        unitsIo.readFile(new File("./src/de/admadic/calculator/units/unitstdset-save.xml"));
        unitsIo.readFile(new File("./src/de/admadic/calculator/units/quantdef.xml"));
        unitsIo.saveFileQuantities(new File("./src/de/admadic/calculator/units/quantdef-tmp.xml"));
        this.unitManager.addMeasure(UnitFactory.createMeasure(this.unitManager, "mF0", "@force", 10.5, ".N"));
        this.unitManager.addMeasure(UnitFactory.createMeasure(this.unitManager, "mv0", "@velocity", 20.5, ".m:s"));
        this.unitManager.addMeasure(UnitFactory.createMeasure(this.unitManager, "mv1", "@velocity", 2.0, "*k.m:h"));
        this.unitManager.addMeasure(UnitFactory.createMeasure(this.unitManager, "ms0", "@length", 50.1, ".m"));
        this.unitManager.addMeasure(UnitFactory.createMeasure(this.unitManager, "mF1", "@force", 100.1, "*k.g.m:s:s"));
        System.out.println("factor dump:");
        for (Factor object2 : this.unitManager.getFactors()) {
            System.out.println("factor = " + object2.toString());
        }
        System.out.println("");
        System.out.println("unit dump:");
        for (IUnit iUnit : this.unitManager.getUnits()) {
            System.out.println("unit = " + iUnit.getDiagnosticInfo());
        }
        System.out.println("");
        System.out.println("quantity dump:");
        for (IQuantity iQuantity : this.unitManager.getQuantities()) {
            System.out.println("quantity = " + iQuantity.getDiagnosticInfo());
        }
        System.out.println("");
        System.out.println("measure dump:");
        for (IMeasure iMeasure : this.unitManager.getMeasures()) {
            System.out.println("measure = " + iMeasure.getDiagnosticInfo());
        }
        System.out.println("");
        IMeasure iMeasure = this.unitManager.getMeasure("mF0");
        IMeasure iMeasure2 = this.unitManager.getMeasure("mF1");
        IMeasure iMeasure3 = this.unitManager.getMeasure("mv0");
        IMeasure iMeasure4 = this.unitManager.getMeasure("mv1");
        System.out.println("mF0: " + iMeasure.getDiagnosticInfo() + "  --> rootValue=" + iMeasure.getRootValue());
        System.out.println("mF1: " + iMeasure2.getDiagnosticInfo() + "  --> rootValue=" + iMeasure2.getRootValue());
        System.out.println("mv0: " + iMeasure3.getDiagnosticInfo() + "  --> rootValue=" + iMeasure3.getRootValue());
        System.out.println("mv1: " + iMeasure4.getDiagnosticInfo() + "  --> rootValue=" + iMeasure4.getRootValue());
        this.testXValue();
        this.testConversion();
        System.out.println(iMeasure3.getDiagnosticInfo());
        iMeasure3.changeUnit(this.unitManager.getUnit("*k.m:h"));
        System.out.println(iMeasure3.getDiagnosticInfo());
        ((Measure)iMeasure3).setMeasureFormatter(MeasureFormatter.createFormatter("%.8g", Locale.GERMANY));
        System.out.println(iMeasure3.getValueView());
    }

    protected void testXValue() {
        String[] stringArray;
        String string = "1.5*2.0/45.3";
        for (String string2 : stringArray = string.split("(?=\\*|\\/)")) {
            System.out.println(">" + string2 + "<");
        }
    }

    protected void testConversion() {
        this.unitManager.addQuantity(UnitFactory.createQuantity(this.unitManager, ".p", "p", "Pressure", ".Pa"));
        this.unitManager.addMeasure(UnitFactory.createMeasure(this.unitManager, "mp0", ".p", 10.0, "*M.Pa"));
        IMeasure iMeasure = this.unitManager.getMeasure("mp0");
        Double d = iMeasure.getValue();
        Double d2 = iMeasure.getRootValue();
        IUnit iUnit = this.unitManager.getUnit("*G.Pa");
        IConverter iConverter = iUnit.getRootConverter();
        Double d3 = iConverter.iconvert(d2);
        System.out.println("measure : " + iMeasure.getDiagnosticInfo());
        System.out.println("converted into " + iUnit.getDiagnosticInfo() + " gives:");
        System.out.println("v = " + d + " rv = " + d2 + " dv = " + d3);
    }
}

