/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.Domain;
import de.admadic.units.core.Factor;
import de.admadic.units.core.FactorUnit;
import de.admadic.units.core.Field;
import de.admadic.units.core.IField;
import de.admadic.units.core.IMeasure;
import de.admadic.units.core.IQuantity;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.SubField;
import de.admadic.units.core.SystemOfUnits;
import de.admadic.units.core.UnitFactory;
import java.util.Hashtable;
import java.util.Vector;

public class UnitManager {
    Vector<IUnit> units = new Vector();
    Hashtable<String, IUnit> idToUnit = new Hashtable();
    Vector<Factor> factors = new Vector();
    Hashtable<String, Factor> idToFactor = new Hashtable();
    Vector<IQuantity> quantities = new Vector();
    Hashtable<String, IQuantity> idToQuantity = new Hashtable();
    Vector<IMeasure> measures = new Vector();
    Hashtable<String, IMeasure> idToMeasure = new Hashtable();
    Vector<Domain> domains = new Vector();
    Hashtable<String, Domain> idToDomain = new Hashtable();
    Hashtable<String, Hashtable<String, IUnit>> domainToUnits = new Hashtable();
    Vector<Field> fields = new Vector();
    Hashtable<String, Field> idToField = new Hashtable();
    Vector<SubField> subfields = new Vector();
    Hashtable<String, SubField> idToSubField = new Hashtable();
    Vector<SystemOfUnits> sous = new Vector();
    Hashtable<String, SystemOfUnits> idToSou = new Hashtable();

    public void addUnit(IUnit iUnit) {
        this.units.add(iUnit);
        this.idToUnit.put(iUnit.getId(), iUnit);
        this.addToDomain(iUnit);
    }

    public void removeUnit(IUnit iUnit) {
        this.idToUnit.remove(iUnit.getId());
        this.units.remove(iUnit);
        this.removeFromDomain(iUnit);
    }

    public boolean existsUnit(String string) {
        return this.idToUnit.containsKey(string);
    }

    public IUnit getUnit(String string) {
        if (!this.existsUnit(string)) {
            this.tryToCreateUnit(string);
        }
        return this.idToUnit.get(string);
    }

    protected void tryToCreateUnit(String string) {
        if (string.length() < 1) {
            return;
        }
        if (string.charAt(0) != '*') {
            return;
        }
        String[] stringArray = string.split("(?=\\.|\\*|\\:|\\/)");
        String[] stringArray2 = new String[]{"", ""};
        int n = 0;
        int n2 = 0;
        for (String string2 : stringArray) {
            if (string2.equals("")) {
                ++n;
                continue;
            }
            if (n2 >= 2) {
                return;
            }
            stringArray2[n2++] = string2;
        }
        stringArray = stringArray2;
        Factor factor = this.getFactor(stringArray[0]);
        IUnit iUnit = this.getUnit(stringArray[1]);
        if (factor == null || iUnit == null) {
            return;
        }
        FactorUnit factorUnit = UnitFactory.createFactorUnit(this, iUnit.getDomain().getId(), iUnit.getId(), factor.getId());
        this.addUnit(factorUnit);
    }

    public Vector<IUnit> getUnits() {
        return this.units;
    }

    public void addToDomain(IUnit iUnit) {
        Hashtable<String, IUnit> hashtable;
        String string = "";
        if (iUnit.getDomain() != null) {
            string = iUnit.getDomain().getId();
        }
        if ((hashtable = this.domainToUnits.get(string)) == null) {
            hashtable = new Hashtable();
            this.domainToUnits.put(string, hashtable);
        }
        hashtable.put(iUnit.getId(), iUnit);
    }

    public void removeFromDomain(IUnit iUnit) {
        String string = "";
        if (iUnit.getDomain() != null) {
            string = iUnit.getDomain().getId();
        }
        Hashtable<String, IUnit> hashtable = this.domainToUnits.get(string);
        hashtable.remove(iUnit.getId());
    }

    public IUnit getUnitFromDomain(String string, String string2) {
        Hashtable<String, IUnit> hashtable = this.domainToUnits.get(string2);
        return hashtable.get(string);
    }

    public Vector<IUnit> getUnitsForDomain(Domain domain, Vector<IUnit> vector) {
        if (vector == null) {
            vector = new Vector();
        }
        Hashtable<String, IUnit> hashtable = this.domainToUnits.get(domain.getId());
        vector.clear();
        vector.addAll(hashtable.values());
        return vector;
    }

    public void addFactor(Factor factor) {
        this.factors.add(factor);
        this.idToFactor.put(factor.getId(), factor);
    }

    public void removeFactor(Factor factor) {
        this.factors.remove(factor);
        this.idToFactor.remove(factor.getId());
    }

    public void removeFactor(String string) {
        Factor factor = null;
        factor = this.idToFactor.get(string);
        if (factor == null) {
            return;
        }
        this.factors.remove(factor);
        this.idToFactor.remove(string);
    }

    public Factor getFactor(String string) {
        return this.idToFactor.get(string);
    }

    public Vector<Factor> getFactors() {
        return this.factors;
    }

    public void addQuantity(IQuantity iQuantity) {
        this.quantities.add(iQuantity);
        this.idToQuantity.put(iQuantity.getId(), iQuantity);
    }

    public void removeQuantity(IQuantity iQuantity) {
        this.idToQuantity.remove(iQuantity.getId());
        this.quantities.remove(iQuantity);
    }

    public IQuantity getQuantity(String string) {
        return this.idToQuantity.get(string);
    }

    public Vector<IQuantity> getQuantities() {
        return this.quantities;
    }

    public void addMeasure(IMeasure iMeasure) {
        this.measures.add(iMeasure);
        this.idToMeasure.put(iMeasure.getId(), iMeasure);
    }

    public void removeMeasure(IMeasure iMeasure) {
        this.idToMeasure.remove(iMeasure.getId());
        this.measures.remove(iMeasure);
    }

    public IMeasure getMeasure(String string) {
        return this.idToMeasure.get(string);
    }

    public Vector<IMeasure> getMeasures() {
        return this.measures;
    }

    public void addDomain(Domain domain) {
        this.domains.add(domain);
        this.idToDomain.put(domain.getId(), domain);
    }

    public void removeDomain(Domain domain) {
        this.idToDomain.remove(domain.getId());
        this.domains.remove(domain);
    }

    public Domain getDomain(String string) {
        return this.idToDomain.get(string);
    }

    public Vector<Domain> getDomains() {
        return this.domains;
    }

    public void addField(Field field) {
        this.fields.add(field);
        this.idToField.put(field.getId(), field);
    }

    public void removeField(Field field) {
        this.fields.remove(field);
        this.idToField.remove(field.getId());
    }

    public IField getField(String string) {
        return this.idToField.get(string);
    }

    public Vector<Field> getFields() {
        return this.fields;
    }

    public void addSubField(SubField subField) {
        this.subfields.add(subField);
        this.idToSubField.put(subField.getId(), subField);
    }

    public void removeSubField(SubField subField) {
        this.subfields.remove(subField);
        this.idToSubField.remove(subField.getId());
    }

    public SubField getSubField(String string) {
        return this.idToSubField.get(string);
    }

    public Vector<SubField> getSubFields() {
        return this.subfields;
    }

    public void addSystemOfUnits(SystemOfUnits systemOfUnits) {
        this.sous.add(systemOfUnits);
        this.idToSou.put(systemOfUnits.getId(), systemOfUnits);
    }

    public void removeSystemOfUnits(SystemOfUnits systemOfUnits) {
        this.sous.remove(systemOfUnits);
        this.idToSou.remove(systemOfUnits.getId());
    }

    public SystemOfUnits getSystemOfUnits(String string) {
        return this.idToSou.get(string);
    }

    public Vector<SystemOfUnits> getSystemOfUnits() {
        return this.sous;
    }

    public void updateDatabase(IUnit iUnit) {
    }
}

