/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.Domain;
import de.admadic.units.core.IField;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.SubField;
import de.admadic.units.core.SystemOfUnits;
import de.admadic.units.core.UnitContext;
import de.admadic.units.core.UnitManager;
import java.util.Hashtable;
import java.util.Vector;

public class UnitFilter {
    Vector<IField> filterFields = new Vector();
    Vector<SystemOfUnits> filterSous = new Vector();
    Vector<Domain> filterDomains = new Vector();
    UnitManager um;
    Vector<Object> hashkeys;
    Hashtable<Object, Hashtable<Object, Boolean>> bighash;

    public UnitFilter(UnitManager unitManager) {
        this.um = unitManager;
    }

    public void addField(IField iField) {
        if (this.filterFields.contains(iField)) {
            return;
        }
        this.filterFields.add(iField);
    }

    public void addSystemOfUnits(SystemOfUnits systemOfUnits) {
        if (this.filterSous.contains(systemOfUnits)) {
            return;
        }
        this.filterSous.add(systemOfUnits);
    }

    public void addDomain(Domain domain) {
        this.filterDomains.add(domain);
    }

    public void clear() {
        this.filterFields.clear();
        this.filterSous.clear();
        this.filterDomains.clear();
    }

    public void updateHashes() {
        this.hashkeys = new Vector();
        this.bighash = new Hashtable();
        this.hashkeys.addAll(this.um.getSubFields());
        this.hashkeys.addAll(this.um.getSystemOfUnits());
        this.hashkeys.addAll(this.um.getDomains());
        for (Object object : this.hashkeys) {
            this.bighash.put(object, new Hashtable());
        }
        for (IUnit iUnit : this.um.getUnits()) {
            UnitContext unitContext = iUnit.getContext();
            for (SubField subField : unitContext.getSubFields()) {
                this.updateEntry(subField, iUnit);
            }
            for (SystemOfUnits systemOfUnits : unitContext.getSystemOfUnits()) {
                this.updateEntry(systemOfUnits, iUnit);
            }
        }
    }

    protected void updateEntry(Object object, IUnit iUnit) {
        Hashtable<Object, Boolean> hashtable = this.bighash.get(object);
        if (!hashtable.containsKey(iUnit)) {
            hashtable.put(iUnit, Boolean.TRUE);
        }
    }

    public void populateUnits(Vector<IUnit> vector) {
        for (IUnit iUnit : this.um.getUnits()) {
            if (!this.unitMatchesFilter(iUnit)) continue;
            vector.add(iUnit);
        }
    }

    public boolean unitMatchesFilter(IUnit iUnit) {
        boolean bl;
        boolean bl2 = true;
        UnitContext unitContext = iUnit.getContext();
        if (!this.filterDomains.contains(iUnit.getDomain())) {
            return false;
        }
        if (this.filterSous.size() > 0) {
            bl = false;
            for (SystemOfUnits object : unitContext.getSystemOfUnits()) {
                if (!this.filterSous.contains(object)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        if (this.filterFields.size() > 0) {
            bl = false;
            for (SubField subField : unitContext.getSubFields()) {
                if (!this.filterFields.contains(subField)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        return bl2;
    }

    public void clearFields() {
        this.filterFields.clear();
    }

    public void clearSystemOfUnits() {
        this.filterSous.clear();
    }

    public void removeField(IField iField) {
        this.filterFields.remove(iField);
    }

    public void removeSystemOfUnits(SystemOfUnits systemOfUnits) {
        this.filterSous.remove(systemOfUnits);
    }

    public void removeDomain(Domain domain) {
        this.filterDomains.remove(domain);
    }

    public void clearDomains() {
        this.filterDomains.clear();
    }
}

