/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.BaseUnit;
import de.admadic.units.core.CompositeUnit;
import de.admadic.units.core.Domain;
import de.admadic.units.core.Factor;
import de.admadic.units.core.FactorUnit;
import de.admadic.units.core.Field;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IField;
import de.admadic.units.core.IMeasure;
import de.admadic.units.core.IQuantity;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.Measure;
import de.admadic.units.core.Quantity;
import de.admadic.units.core.SubField;
import de.admadic.units.core.SubstUnit;
import de.admadic.units.core.SystemOfUnits;
import de.admadic.units.core.UnitManager;

public class UnitFactory {
    protected UnitFactory() {
    }

    public static Factor createFactor(String string, String string2, String string3, double d) {
        return new Factor(string, string2, string3, d);
    }

    public static IUnit createUnit(String string, String string2, String string3) {
        return new BaseUnit(string, string2, string3);
    }

    public static IUnit createUnitFM(UnitManager unitManager, String string, String string2) {
        return new CompositeUnit().fac(unitManager.getFactor(string)).mul(unitManager.getUnit(string2));
    }

    public static IUnit createUnitMD(UnitManager unitManager, String string, String string2) {
        return new CompositeUnit().mul(unitManager.getUnit(string)).div(unitManager.getUnit(string2));
    }

    public static IUnit createUnitFMM(UnitManager unitManager, String string, String string2, String string3) {
        return new CompositeUnit().fac(unitManager.getFactor(string)).mul(unitManager.getUnit(string2)).mul(unitManager.getUnit(string3));
    }

    public static IUnit createUnitFMMDD(UnitManager unitManager, String string, String string2, String string3, String string4, String string5) {
        CompositeUnit compositeUnit = new CompositeUnit();
        if (string != null) {
            compositeUnit.fac(unitManager.getFactor(string));
        }
        if (string2 != null) {
            compositeUnit.mul(unitManager.getUnit(string2));
        }
        if (string3 != null) {
            compositeUnit.mul(unitManager.getUnit(string3));
        }
        if (string4 != null) {
            compositeUnit.div(unitManager.getUnit(string4));
        }
        if (string5 != null) {
            compositeUnit.div(unitManager.getUnit(string5));
        }
        return compositeUnit;
    }

    public static IUnit createUnitFSMMDD(UnitManager unitManager, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        CompositeUnit compositeUnit = new CompositeUnit();
        if (string != null) {
            compositeUnit.fac(unitManager.getFactor(string));
        }
        if (string3 != null || string4 != null) {
            compositeUnit.subst(string2, string3, string4);
        }
        if (string5 != null) {
            compositeUnit.mul(unitManager.getUnit(string5));
        }
        if (string6 != null) {
            compositeUnit.mul(unitManager.getUnit(string6));
        }
        if (string7 != null) {
            compositeUnit.div(unitManager.getUnit(string7));
        }
        if (string8 != null) {
            compositeUnit.div(unitManager.getUnit(string8));
        }
        return compositeUnit;
    }

    public static IUnit createUnitFSBMD(UnitManager unitManager, String string, String string2, String string3, String string4, IConverter iConverter, String string5, String string6) {
        CompositeUnit compositeUnit = new CompositeUnit();
        if (string != null) {
            compositeUnit.fac(unitManager.getFactor(string));
        }
        if (string3 != null || string4 != null) {
            compositeUnit.subst(string2, string3, string4);
        }
        if (iConverter != null) {
            compositeUnit.setBaseConverter(iConverter);
        }
        if (string5 != null) {
            compositeUnit.mul(unitManager.getUnit(string5));
        }
        if (string6 != null) {
            compositeUnit.div(unitManager.getUnit(string6));
        }
        return compositeUnit;
    }

    public static IQuantity createQuantity(UnitManager unitManager, String string, String string2, String string3, String string4) {
        return new Quantity(string, string2, string3, unitManager.getUnit(string4));
    }

    public static IMeasure createMeasure(UnitManager unitManager, String string, double d, String string2) {
        return new Measure(unitManager.getQuantity(string), d, unitManager.getUnit(string2));
    }

    public static IMeasure createMeasure(UnitManager unitManager, String string, String string2, double d, String string3) {
        return new Measure(string, unitManager.getQuantity(string2), d, unitManager.getUnit(string3));
    }

    public static IMeasure createMeasure(UnitManager unitManager, String string, String string2, double d, String string3, String string4, String string5) {
        return new Measure(string, unitManager.getQuantity(string2), d, unitManager.getUnit(string3), string4, string5);
    }

    public static Domain createDomain(String string, String string2) {
        return new Domain(string, string2);
    }

    public static Field createField(String string, String string2) {
        return new Field(string, string2);
    }

    public static SubField createSubField(UnitManager unitManager, String string, String string2, String string3) {
        IField iField = unitManager.getField(string);
        return new SubField(iField, string2, string3);
    }

    public static SystemOfUnits createSystemOfUnits(String string, String string2, String string3) {
        return new SystemOfUnits(string, string2, string3);
    }

    public static BaseUnit createBaseUnit(UnitManager unitManager, String string, String string2, String string3, String string4) {
        Domain domain = unitManager.getDomain(string4);
        BaseUnit baseUnit = new BaseUnit(domain, string, string2, string3);
        return baseUnit;
    }

    public static FactorUnit createFactorUnit(UnitManager unitManager, String string, String string2, String string3) {
        Domain domain = unitManager.getDomain(string);
        IUnit iUnit = unitManager.getUnit(string2);
        Factor factor = unitManager.getFactor(string3);
        FactorUnit factorUnit = new FactorUnit(domain, iUnit, factor);
        return factorUnit;
    }

    public static SubstUnit createSubstUnit(UnitManager unitManager, String string, String string2, String string3, String string4, String string5) {
        Domain domain = unitManager.getDomain(string5);
        IUnit iUnit = unitManager.getUnit(string4);
        SubstUnit substUnit = new SubstUnit(string, string2, string3, iUnit);
        substUnit.setDomain(domain);
        return substUnit;
    }

    public static CompositeUnit createCompUnit(UnitManager unitManager, String string) {
        CompositeUnit compositeUnit = new CompositeUnit();
        Domain domain = unitManager.getDomain(string);
        compositeUnit.setDomain(domain);
        return compositeUnit;
    }
}

