/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.SubField;
import de.admadic.units.core.SystemOfUnits;
import java.util.Vector;

public class UnitContext {
    Vector<SubField> vSubFields = new Vector();
    Vector<SystemOfUnits> vSous = new Vector();
    String cacheSousString = "";
    String cacheFieldsString = "";

    public String getSousString() {
        return this.cacheSousString;
    }

    public String getFieldsString() {
        return this.cacheFieldsString;
    }

    protected void updateSousCache() {
        Object object = "";
        for (SystemOfUnits systemOfUnits : this.getSystemOfUnits()) {
            if (((String)object).length() > 0) {
                object = (String)object + ",";
            }
            object = (String)object + systemOfUnits.getSymbol();
        }
        this.cacheSousString = object;
    }

    protected void updateFieldsCache() {
        Object object = "";
        for (SubField subField : this.getSubFields()) {
            if (((String)object).length() > 0) {
                object = (String)object + ",";
            }
            object = (String)object + subField.getId();
        }
        this.cacheFieldsString = object;
    }

    public void clear() {
        this.vSubFields.clear();
        this.vSous.clear();
        this.updateSousCache();
        this.updateFieldsCache();
    }

    public void clearFields() {
        this.vSubFields.clear();
        this.updateFieldsCache();
    }

    public void clearSous() {
        this.vSous.clear();
        this.updateSousCache();
    }

    public void addSubField(SubField subField) {
        if (this.vSubFields.contains(subField)) {
            return;
        }
        this.vSubFields.add(subField);
        this.updateFieldsCache();
    }

    public void removeSubField(SubField subField) {
        this.vSubFields.remove(subField);
        this.updateFieldsCache();
    }

    public void addSystemOfUnits(SystemOfUnits systemOfUnits) {
        if (this.vSous.contains(systemOfUnits)) {
            return;
        }
        this.vSous.add(systemOfUnits);
        this.updateSousCache();
    }

    public void removeSystemOfUnits(SystemOfUnits systemOfUnits) {
        this.vSous.remove(systemOfUnits);
        this.updateSousCache();
    }

    public Vector<SubField> getSubFields() {
        return this.vSubFields;
    }

    public Vector<SystemOfUnits> getSystemOfUnits() {
        return this.vSous;
    }
}

