/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.AbstractUnit;
import de.admadic.units.core.ConverterSeq;
import de.admadic.units.core.Domain;
import de.admadic.units.core.Factor;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.UnitsError;
import de.admadic.units.core.UnitsUtil;

public class SubstUnit
extends AbstractUnit {
    Factor factor;
    String id;
    String symbol;
    String name;
    IUnit baseUnit;
    ConverterSeq rootConverter = new ConverterSeq();
    IConverter factorConverter = null;
    IConverter substConverter;
    IConverter baseConverter;
    static final int CV_FACTOR = 0;
    static final int CV_SUBST = 1;
    static final int CV_BASE = 2;
    String cacheSymbol = "";
    String cacheName = "";
    String cacheId = "";
    String cacheNormalizedId = "";
    String cacheCanonicalId = "";
    String cacheNormalizedCanonicalId = "";
    String cacheRootedId = "";

    public SubstUnit(String string, String string2, String string3, IUnit iUnit) {
        this.rootConverter.add(this.factorConverter);
        this.rootConverter.add(this.substConverter);
        this.rootConverter.add(this.baseConverter);
        this.setBaseUnit(iUnit);
        this.setSubst(string, string2, string3);
    }

    public void setSubst(String string, String string2, String string3) {
        this.id = string;
        this.symbol = string2;
        this.name = string3;
        this.updateCache();
    }

    public void setBaseUnit(IUnit iUnit) {
        this.baseUnit = iUnit;
        this.baseConverter = iUnit.getRootConverter();
        this.rootConverter.set(2, this.baseConverter);
        this.updateCache();
    }

    public SubstUnit fac(Factor factor) {
        this.setFactor(factor);
        return this;
    }

    public SubstUnit dom(Domain domain) {
        this.setDomain(domain);
        return this;
    }

    @Override
    public Factor getFactor() {
        return this.factor;
    }

    public void setFactor(Factor factor) {
        this.factor = factor;
        this.factorConverter = factor.getRootConverter();
        this.rootConverter.set(0, this.factorConverter);
        this.updateCache();
    }

    public void setBaseConverter(IConverter iConverter) {
        this.baseConverter = iConverter;
        this.rootConverter.set(2, this.baseConverter);
    }

    private String sortIdMulDiv(String string) {
        Object object = "";
        String[] stringArray = string.split("(?=\\.|\\*|\\:|\\/)");
        Object object2 = "";
        Object object3 = "";
        block6: for (String string2 : stringArray) {
            if (string2.equals("")) continue;
            String string3 = string2.substring(1);
            char c = string2.charAt(0);
            switch (c) {
                case '*': {
                    object2 = (String)object2 + "*" + string3;
                    continue block6;
                }
                case '.': {
                    object2 = (String)object2 + "." + string3;
                    continue block6;
                }
                case '/': {
                    object3 = (String)object3 + "/" + string3;
                    continue block6;
                }
                case ':': {
                    object3 = (String)object3 + ":" + string3;
                    continue block6;
                }
                default: {
                    throw new Error("invalid element id: [" + c + "] with " + string2);
                }
            }
        }
        object = (String)object2 + (String)object3;
        return object;
    }

    private void updateCache() {
        this.cacheId = this.id;
        this.cacheSymbol = this.symbol;
        this.cacheName = this.name;
        this.cacheNormalizedId = UnitsUtil.sortNormalizedCache((this.factor != null ? this.factor.getId() : "") + this.cacheId);
        this.cacheCanonicalId = this.sortIdMulDiv((this.factor != null ? this.factor.getId() : "") + (this.baseUnit != null ? this.baseUnit.getCanonicalId() : ""));
        this.cacheNormalizedCanonicalId = UnitsUtil.sortNormalizedCache(this.cacheCanonicalId);
        this.cacheRootedId = UnitsUtil.stripFactorIds(this.cacheNormalizedCanonicalId);
    }

    @Override
    public String getSymbol() {
        String string = "";
        if (this.factor != null) {
            string = this.factor.getSymbol();
        }
        return string + this.cacheSymbol;
    }

    @Override
    public String getName() {
        String string = "";
        if (this.factor != null) {
            string = this.factor.getName();
        }
        return string + this.cacheName;
    }

    @Override
    public String getId() {
        String string = "";
        if (this.factor != null) {
            string = this.factor.getId();
        }
        return string + this.cacheId;
    }

    @Override
    public String getCanonicalId() {
        if (this.factor != null) {
            return this.factor.getId() + this.cacheCanonicalId;
        }
        return this.cacheCanonicalId;
    }

    @Override
    public String getNormalizedId() {
        return this.cacheNormalizedId;
    }

    @Override
    public String getNormalizedCanonicalId() {
        return this.cacheNormalizedCanonicalId;
    }

    @Override
    public String getRootedId() {
        return this.cacheRootedId;
    }

    public int getQtyId() {
        return 0;
    }

    public String toString() {
        return "s:" + this.getSymbol() + "(id:" + this.getId() + ")(cid:" + this.getCanonicalId() + ")";
    }

    @Override
    public IConverter getRootConverter() {
        return this.rootConverter;
    }

    @Override
    public Double getRootFactor() {
        return this.rootConverter.convert((Double)1.0);
    }

    @Override
    public void checkAcyclic(IUnit iUnit) {
        if (this == iUnit) {
            throw new UnitsError("Units are cyclic: " + iUnit.getDiagnosticInfo());
        }
        this.baseUnit.checkAcyclic(iUnit);
    }

    public IUnit getBaseUnit() {
        return this.baseUnit;
    }

    public IConverter getBaseConverter() {
        return this.baseConverter;
    }

    public IConverter getSubstConverter() {
        return this.substConverter;
    }

    public void setSubstConverter(IConverter iConverter) {
        this.substConverter = iConverter;
        this.rootConverter.set(1, iConverter);
    }
}

