/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.IConverter;
import de.admadic.units.core.IMeasure;
import de.admadic.units.core.IQuantity;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.MeasureFormatter;

public class Measure
implements IMeasure {
    String id;
    IQuantity quantity;
    Double value;
    IUnit unit;
    String name;
    String symbol;
    MeasureFormatter mf;

    public Measure(String string, IQuantity iQuantity, Double d, IUnit iUnit, String string2, String string3) {
        this.id = string;
        this.quantity = iQuantity;
        this.value = d;
        this.unit = iUnit;
        this.symbol = string2;
        this.name = string3;
    }

    public Measure(String string, IQuantity iQuantity, Double d, IUnit iUnit) {
        this(string, iQuantity, d, iUnit, null, null);
    }

    public Measure(String string, IQuantity iQuantity, double d, IUnit iUnit) {
        this(string, iQuantity, d, iUnit, null, null);
    }

    public Measure(IQuantity iQuantity, Double d, IUnit iUnit) {
        this("", iQuantity, d, iUnit);
    }

    public Measure(IQuantity iQuantity, double d, IUnit iUnit) {
        this(iQuantity, (Double)d, iUnit);
    }

    @Override
    public void setMeasureFormatter(MeasureFormatter measureFormatter) {
        this.mf = measureFormatter;
    }

    @Override
    public IQuantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(IQuantity iQuantity) {
        this.quantity = iQuantity;
    }

    @Override
    public IUnit getUnit() {
        return this.unit;
    }

    public void setUnit(IUnit iUnit) {
        this.unit = iUnit;
    }

    @Override
    public void changeUnit(IUnit iUnit) {
        if (iUnit == this.getUnit()) {
            return;
        }
        Double d = this.getRootValue();
        this.setUnit(iUnit);
        IConverter iConverter = this.getUnit().getRootConverter();
        Double d2 = iConverter.iconvert(d);
        this.setValue(d2);
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public Double getRootValue() {
        if (this.value == null) {
            return null;
        }
        double d = this.value;
        IConverter iConverter = this.unit.getRootConverter();
        d = iConverter.convert(d);
        return d;
    }

    @Override
    public void setValue(Double d) {
        this.value = d;
    }

    @Override
    public String getDisplay() {
        return this.quantity.getSymbol() + "=" + this.value + " " + this.unit.getSymbol();
    }

    @Override
    public String getDiagnosticInfo() {
        return this.quantity.getSymbol() + "=" + this.value + " " + this.unit.getSymbol() + " id:" + this.getId() + " n=" + this.unit.getNormalizedCanonicalId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MeasureFormatter getMeasureFormatter() {
        return this.mf;
    }

    @Override
    public String getValueView() {
        if (this.mf != null) {
            return this.mf.format(this.getValue());
        }
        return this.getValue().toString();
    }

    @Override
    public void setRootValue(Double d) {
        if (d == null) {
            return;
        }
        IConverter iConverter = this.unit.getRootConverter();
        d = iConverter.iconvert(d);
        this.setValue(d);
    }

    @Override
    public String getNameDisplay() {
        if (this.getName() != null) {
            return this.name;
        }
        if (this.getQuantity() != null) {
            return this.getQuantity().getName();
        }
        return null;
    }

    @Override
    public String getSymbolDisplay() {
        if (this.getSymbol() != null) {
            return this.symbol;
        }
        if (this.getQuantity() != null) {
            return this.getQuantity().getSymbol();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }
}

