/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.AbstractUnit;
import de.admadic.units.core.ConverterSeq;
import de.admadic.units.core.Domain;
import de.admadic.units.core.Factor;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.UnitsError;
import de.admadic.units.core.UnitsUtil;

public class FactorUnit
extends AbstractUnit {
    String cacheId;
    String cacheSymbol;
    String cacheName;
    ConverterSeq rootConverter = new ConverterSeq();
    IConverter factorConverter;
    IConverter baseConverter;
    String cacheNormalizedId;
    String cacheCanonicalId;
    String cacheNormalizedCanonicalId;
    String cacheRootedId;
    Factor factor;
    IUnit baseUnit;

    public FactorUnit(Domain domain, IUnit iUnit, Factor factor) {
        this.rootConverter.add(this.factorConverter);
        this.rootConverter.add(this.baseConverter);
        this.setDomain(domain);
        this.setBaseUnit(iUnit);
        this.setFactor(factor);
    }

    protected void updateCache() {
        this.cacheId = "";
        this.cacheId = this.cacheId + (this.factor != null ? this.factor.getId() : "");
        this.cacheId = this.cacheId + (this.baseUnit != null ? this.baseUnit.getId() : "");
        this.cacheId = UnitsUtil.sortIdMulDiv(this.cacheId);
        this.cacheCanonicalId = "";
        this.cacheCanonicalId = this.cacheCanonicalId + (this.factor != null ? this.factor.getId() : "");
        this.cacheCanonicalId = this.cacheCanonicalId + (this.baseUnit != null ? this.baseUnit.getCanonicalId() : "");
        this.cacheCanonicalId = UnitsUtil.sortIdMulDiv(this.cacheCanonicalId);
        this.cacheSymbol = "";
        if (this.factor != null) {
            this.cacheSymbol = this.cacheSymbol + this.factor.getSymbol();
        }
        if (this.baseUnit != null) {
            this.cacheSymbol = this.cacheSymbol + this.baseUnit.getSymbol();
        }
        this.cacheName = "";
        if (this.factor != null) {
            this.cacheName = this.cacheName + this.factor.getName();
        }
        if (this.baseUnit != null) {
            this.cacheName = this.cacheName + this.baseUnit.getName();
        }
        this.cacheNormalizedId = UnitsUtil.sortNormalizedCache(this.cacheId);
        this.cacheNormalizedCanonicalId = UnitsUtil.sortNormalizedCache(this.cacheCanonicalId);
        this.cacheRootedId = UnitsUtil.stripFactorIds(this.cacheNormalizedCanonicalId);
    }

    public void setBaseUnit(IUnit iUnit) {
        this.baseUnit = iUnit;
        this.baseConverter = iUnit.getRootConverter();
        this.rootConverter.set(1, this.baseConverter);
        this.updateCache();
    }

    @Override
    public String getSymbol() {
        return this.cacheSymbol;
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public String getId() {
        return this.cacheId;
    }

    @Override
    public String getNormalizedId() {
        return this.cacheNormalizedId;
    }

    @Override
    public String getCanonicalId() {
        return this.cacheCanonicalId;
    }

    @Override
    public String getNormalizedCanonicalId() {
        return this.cacheNormalizedCanonicalId;
    }

    @Override
    public String getRootedId() {
        return this.cacheRootedId;
    }

    @Override
    public Factor getFactor() {
        return this.factor;
    }

    public void setFactor(Factor factor) {
        this.factor = factor;
        this.factorConverter = factor.getRootConverter();
        this.rootConverter.set(0, this.factorConverter);
        this.updateCache();
    }

    public String toString() {
        return "s:" + this.cacheSymbol + "(id:" + this.cacheId + ")";
    }

    @Override
    public IConverter getRootConverter() {
        return this.rootConverter;
    }

    @Override
    public Double getRootFactor() {
        return this.rootConverter.convert((Double)1.0);
    }

    @Override
    public void checkAcyclic(IUnit iUnit) {
        if (this == iUnit) {
            throw new UnitsError("Units are cyclic: " + iUnit.getDiagnosticInfo());
        }
    }

    public IUnit getBaseUnit() {
        return this.baseUnit;
    }
}

