/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.AbstractUnit;
import de.admadic.units.core.ConverterMulDivSeq;
import de.admadic.units.core.ConverterSeq;
import de.admadic.units.core.Domain;
import de.admadic.units.core.Factor;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.UnitsError;
import de.admadic.units.core.UnitsUtil;
import java.util.Vector;

public class CompositeUnit
extends AbstractUnit {
    Factor factor;
    String substId;
    String substSymbol;
    String substName;
    ConverterSeq rootConverter;
    IConverter factorConverter = null;
    IConverter baseConverter = null;
    ConverterMulDivSeq seqConverter;
    static final int CV_FACTOR = 0;
    static final int CV_BASE = 1;
    static final int CV_SEQ = 2;
    public static final int MUL = 0;
    public static final int DIV = 1;
    static final Integer I_MUL = 0;
    static final Integer I_DIV = 1;
    Integer[] itgMap = new Integer[]{I_MUL, I_DIV};
    Vector<IUnit> unitsMul = new Vector();
    Vector<IUnit> unitsDiv = new Vector();
    String cacheSymbol = "";
    String cacheName = "";
    String cacheId = "";
    String cacheNormalizedId = "";
    String cacheCanonicalId = "";
    String cacheNormalizedCanonicalId = "";
    String cacheRootedId = "";

    public CompositeUnit() {
        this.seqConverter = new ConverterMulDivSeq();
        this.rootConverter = new ConverterSeq();
        this.rootConverter.add(this.factorConverter);
        this.rootConverter.add(this.baseConverter);
        this.rootConverter.add(this.seqConverter);
    }

    public void setSubst(String string, String string2, String string3) {
        System.err.println("Warning: CompositeUnit with id " + this.cacheId + " shall be substituted.");
        this.substId = string;
        this.substSymbol = string2;
        this.substName = string3;
    }

    public CompositeUnit subst(String string, String string2, String string3) {
        this.setSubst(string, string2, string3);
        return this;
    }

    public CompositeUnit subst(String string, String string2, String string3, Factor factor) {
        this.setSubst(string, string2, string3);
        this.setFactor(factor);
        return this;
    }

    public CompositeUnit fac(Factor factor) {
        this.setFactor(factor);
        return this;
    }

    public CompositeUnit dom(Domain domain) {
        this.setDomain(domain);
        return this;
    }

    @Override
    public Factor getFactor() {
        return this.factor;
    }

    public void setFactor(Factor factor) {
        System.err.println("Warning: CompositeUnit with id " + this.cacheId + " shall be factored.");
        this.factor = factor;
        this.factorConverter = factor.getRootConverter();
        this.rootConverter.set(0, this.factorConverter);
    }

    public void clearSubUnits() {
        this.unitsMul.clear();
        this.unitsDiv.clear();
        this.cacheSymbol = "";
        this.cacheName = "";
        this.cacheId = "";
        this.cacheNormalizedId = "";
        this.cacheCanonicalId = "";
        this.cacheNormalizedCanonicalId = "";
        this.cacheRootedId = "";
        this.seqConverter.clearSeq();
    }

    public void setBaseConverter(IConverter iConverter) {
        this.baseConverter = iConverter;
        this.rootConverter.set(1, this.baseConverter);
    }

    public IConverter getBaseConverter() {
        return this.baseConverter;
    }

    public void appendUnit(IUnit iUnit, int n) {
        if (n == 0) {
            this.unitsMul.add(iUnit);
        } else {
            this.unitsDiv.add(iUnit);
        }
        this.updateCache(iUnit, n);
        this.updateRootConverter(iUnit, n);
    }

    private void updateRootConverter(IUnit iUnit, int n) {
        if (n == 0) {
            this.seqConverter.addMul(iUnit.getRootConverter());
        } else {
            this.seqConverter.addDiv(iUnit.getRootConverter());
        }
    }

    public Vector<IUnit> getUnits(int n) {
        if (n == 0) {
            return this.unitsMul;
        }
        return this.unitsDiv;
    }

    private void updateCache(IUnit iUnit, int n) {
        if (n == 0) {
            this.cacheId = UnitsUtil.sortIdMulDiv(this.cacheId + iUnit.getId());
            this.cacheCanonicalId = UnitsUtil.sortIdMulDiv(this.cacheCanonicalId + iUnit.getCanonicalId());
            if (this.cacheSymbol.length() != 0) {
                this.cacheSymbol = this.cacheSymbol + "_";
            }
            this.cacheSymbol = this.cacheSymbol + iUnit.getSymbol();
            this.cacheName = this.cacheName + iUnit.getName();
        } else {
            this.cacheId = UnitsUtil.sortIdMulDiv(this.cacheId + UnitsUtil.invertIdDivToMul(iUnit.getId()));
            this.cacheCanonicalId = UnitsUtil.sortIdMulDiv(this.cacheCanonicalId + UnitsUtil.invertIdDivToMul(iUnit.getCanonicalId()));
            if (this.cacheSymbol.length() != 0) {
                this.cacheSymbol = this.cacheSymbol + "~";
            }
            this.cacheSymbol = this.cacheSymbol + UnitsUtil.invertSymbolDivToMul(iUnit.getSymbol());
            this.cacheName = this.cacheName + iUnit.getName();
        }
        this.cacheNormalizedId = UnitsUtil.sortNormalizedCache(this.getId());
        this.cacheNormalizedCanonicalId = UnitsUtil.sortNormalizedCache(this.getCanonicalId());
        this.cacheRootedId = UnitsUtil.stripFactorIds(this.cacheNormalizedCanonicalId);
    }

    public CompositeUnit mul(IUnit iUnit) {
        this.appendUnit(iUnit, 0);
        return this;
    }

    public CompositeUnit div(IUnit iUnit) {
        this.appendUnit(iUnit, 1);
        return this;
    }

    @Override
    public String getSymbol() {
        String string = "";
        if (this.factor != null) {
            string = this.factor.getSymbol();
        }
        if (this.substSymbol != null) {
            return string + this.substSymbol;
        }
        return string + this.cacheSymbol;
    }

    @Override
    public String getName() {
        String string = "";
        if (this.factor != null) {
            string = this.factor.getName();
        }
        if (this.substName != null) {
            return string + this.substName;
        }
        return string + this.cacheName;
    }

    @Override
    public String getId() {
        if (this.substSymbol != null) {
            if (this.factor != null) {
                return this.factor.getId() + this.substId;
            }
            return this.substId;
        }
        if (this.factor != null) {
            return this.factor.getId() + this.cacheId;
        }
        return this.cacheId;
    }

    @Override
    public String getCanonicalId() {
        if (this.factor != null) {
            return this.factor.getId() + this.cacheCanonicalId;
        }
        return this.cacheCanonicalId;
    }

    @Override
    public String getNormalizedId() {
        return this.cacheNormalizedId;
    }

    @Override
    public String getNormalizedCanonicalId() {
        return this.cacheNormalizedCanonicalId;
    }

    @Override
    public String getRootedId() {
        return this.cacheRootedId;
    }

    public String toString() {
        return "s:" + this.getSymbol() + "(id:" + this.getId() + ")(cid:" + this.getCanonicalId() + ")";
    }

    @Override
    public IConverter getRootConverter() {
        return this.rootConverter;
    }

    @Override
    public Double getRootFactor() {
        return this.rootConverter.convert((Double)1.0);
    }

    @Override
    public void checkAcyclic(IUnit iUnit) {
        if (this == iUnit) {
            throw new UnitsError("Units are cyclic: " + iUnit.getDiagnosticInfo());
        }
        for (IUnit iUnit2 : this.unitsMul) {
            iUnit2.checkAcyclic(iUnit);
        }
        for (IUnit iUnit2 : this.unitsDiv) {
            iUnit2.checkAcyclic(iUnit);
        }
    }

    public String getSubstId() {
        return this.substId;
    }

    public String getSubstName() {
        return this.substName;
    }

    public String getSubstSymbol() {
        return this.substSymbol;
    }
}

