/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.AbstractUnit;
import de.admadic.units.core.ConverterIdent;
import de.admadic.units.core.Domain;
import de.admadic.units.core.Factor;
import de.admadic.units.core.IConverter;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.UnitsError;

public class BaseUnit
extends AbstractUnit {
    String id;
    String symbol;
    String name;
    IConverter rootConverter;

    public BaseUnit(String string, String string2, String string3) {
        this(null, string, string2, string3);
    }

    public BaseUnit(Domain domain, String string, String string2, String string3) {
        this.id = string;
        this.symbol = string2;
        this.name = string3;
        this.setDomain(domain);
        this.rootConverter = new ConverterIdent();
    }

    public BaseUnit dom(Domain domain) {
        this.setDomain(domain);
        return this;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNormalizedId() {
        return this.getId();
    }

    @Override
    public String getCanonicalId() {
        return this.getId();
    }

    @Override
    public String getNormalizedCanonicalId() {
        return this.getCanonicalId();
    }

    @Override
    public String getRootedId() {
        return this.getNormalizedCanonicalId();
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public Factor getFactor() {
        return null;
    }

    public void setFactor(Factor factor) {
        if (factor != null) {
            throw new UnitsError("Trying to set a factor for a BaseUnit");
        }
    }

    public String toString() {
        return "s:" + this.symbol + "(id:" + this.id + ")";
    }

    @Override
    public IConverter getRootConverter() {
        return this.rootConverter;
    }

    @Override
    public Double getRootFactor() {
        return this.rootConverter.convert((Double)1.0);
    }

    @Override
    public void checkAcyclic(IUnit iUnit) {
        if (this == iUnit) {
            throw new UnitsError("Units are cyclic: " + iUnit.getDiagnosticInfo());
        }
    }
}

