/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.units.core;

import de.admadic.units.core.Domain;
import de.admadic.units.core.IUnit;
import de.admadic.units.core.UnitContext;
import de.admadic.units.core.UnitsError;
import de.admadic.units.core.UnitsUtil;
import java.util.Calendar;
import java.util.Date;

public abstract class AbstractUnit
implements IUnit {
    Domain domain;
    UnitContext context = new UnitContext();
    Date lastChange;
    String lastSymbolViewRaw;
    String lastSymbolView;

    @Override
    public String getDiagnosticInfo() {
        return "d:" + this.getSymbol() + " (dom:" + (this.getDomain() != null ? this.getDomain().getId() : "-") + ") (id:" + this.getId() + ") (nid:" + this.getNormalizedId() + ") (cid:" + this.getCanonicalId() + ") (ncid:" + this.getNormalizedCanonicalId() + ") (rid:" + this.getRootedId() + ") long:" + this.getName();
    }

    @Override
    public String getId(int n) {
        switch (n) {
            case 0: {
                return this.getId();
            }
            case 1: {
                return this.getNormalizedId();
            }
            case 2: {
                return this.getCanonicalId();
            }
            case 3: {
                return this.getNormalizedCanonicalId();
            }
            case 4: {
                return this.getRootedId();
            }
        }
        throw new UnitsError("invalid unitid for getId: " + n);
    }

    @Override
    public boolean isSameDimension(IUnit iUnit) {
        if (iUnit == null) {
            return false;
        }
        String string = this.getNormalizedCanonicalId();
        String string2 = iUnit.getNormalizedCanonicalId();
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    @Override
    public boolean isSameMagnitude(IUnit iUnit) {
        if (iUnit == null) {
            return false;
        }
        String string = this.getNormalizedId();
        String string2 = iUnit.getNormalizedId();
        if (string == null || string2 == null) {
            return false;
        }
        if (!string.equals(string2)) {
            return false;
        }
        Double d = this.getRootFactor();
        Double d2 = iUnit.getRootFactor();
        if (d == null || d2 == null) {
            return false;
        }
        return d.doubleValue() == d2.doubleValue();
    }

    @Override
    public boolean isSameUnit(IUnit iUnit) {
        if (iUnit == null) {
            return false;
        }
        String string = this.getId();
        String string2 = iUnit.getId();
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public UnitContext getContext() {
        return this.context;
    }

    @Override
    public Date getLastChange() {
        return this.lastChange;
    }

    @Override
    public void setLastChange(Date date) {
        this.lastChange = date;
    }

    @Override
    public void touchLastChange() {
        this.lastChange = Calendar.getInstance().getTime();
    }

    @Override
    public String getSymbolView() {
        String string = this.getSymbol();
        if (this.lastSymbolViewRaw != null && string.equals(this.lastSymbolViewRaw)) {
            return this.lastSymbolView;
        }
        this.lastSymbolViewRaw = this.getSymbol();
        this.lastSymbolView = UnitsUtil.createSymbolView(this.getId(), this.lastSymbolViewRaw);
        return this.lastSymbolView;
    }
}

