/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.util;

import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class FilteredListModel
extends AbstractListModel {
    private static final long serialVersionUID = 1L;
    public static final int FLT_INSIDE = 0;
    public static final int FLT_BEGIN = 1;
    public static final int FLT_END = 2;
    private String filter;
    private Vector list = new Vector();
    private Vector filteredList = new Vector();
    int filterType = 0;

    public void addList(List list) {
        this.list.addAll(list);
        this.updateFilterImpl();
    }

    public void updateFilter(String string) {
        this.filter = string;
        this.updateFilterImpl();
    }

    public void updateFilter() {
        this.updateFilterImpl();
    }

    protected void updateFilterImpl() {
        if ((this.filter == null || this.filter.equals("")) && this.filteredList.size() == this.list.size()) {
            return;
        }
        if (this.filter == null || this.filter.equals("")) {
            this.filteredList.clear();
            for (Object e : this.list) {
                this.filteredList.add(e);
            }
            this.fireContentsChanged(this, 0, this.filteredList.size() - 1);
            return;
        }
        this.filteredList.clear();
        for (Object e : this.list) {
            if (!this.matches(e)) continue;
            this.filteredList.add(e);
        }
        this.fireContentsChanged(this, 0, this.filteredList.size() - 1);
    }

    protected boolean matches(Object object) {
        String string = (String)object;
        string = string.toLowerCase();
        String string2 = this.filter.toLowerCase();
        switch (this.filterType) {
            case 0: {
                if (string.indexOf(string2) < 0) break;
                return true;
            }
            case 1: {
                if (!string.startsWith(string2)) break;
                return true;
            }
            case 2: {
                if (!string.endsWith(string2)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSize() {
        return this.filteredList.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.filteredList.elementAt(n);
    }

    public void clear() {
        this.list.clear();
        this.filteredList.clear();
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterType(int n) {
        this.filterType = n;
    }
}

