/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.util;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.ui.util.Dialog;
import de.admadic.ui.util.FilteredListModel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;

public class ClassSelectorDialog
extends Dialog
implements ActionListener {
    JLabel labelClassName;
    JTextField textClassName;
    JLabel labelClassFilter;
    JTextField textClassFilter;
    JLabel labelClassList;
    JList listClasses;
    FilteredListModel listModel;
    JScrollPane scrollClasses;
    JPanel panelButtons;
    JButton buttonOk;
    JButton buttonCancel;
    boolean requireInList = true;
    String filter;
    String selectedClassName;
    static final String CMD_OK = "cmd.ok";
    static final String CMD_CANCEL = "cmd.cancel";
    ArrayList<String> listClassNamesEngine;
    private static final long serialVersionUID = 1L;

    public ClassSelectorDialog(Frame frame) throws HeadlessException {
        super(frame);
        this.initGUI();
    }

    public ClassSelectorDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
    }

    public ClassSelectorDialog(Frame frame, String string) throws HeadlessException {
        super(frame, string);
    }

    public ClassSelectorDialog(Frame frame, String string, boolean bl) throws HeadlessException {
        super(frame, string, bl);
    }

    public ClassSelectorDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
    }

    public ClassSelectorDialog(java.awt.Dialog dialog) throws HeadlessException {
        super(dialog);
        this.initGUI();
    }

    public ClassSelectorDialog(java.awt.Dialog dialog, String string) throws HeadlessException {
        super(dialog, string);
    }

    public ClassSelectorDialog(java.awt.Dialog dialog, String string, boolean bl) throws HeadlessException {
        super(dialog, string, bl);
    }

    public ClassSelectorDialog(java.awt.Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) throws HeadlessException {
        super(dialog, string, bl, graphicsConfiguration);
    }

    protected void initGUI() {
        FormLayout formLayout = new FormLayout("12px, p, 12px", "12px, p, 5px, p, 12px, p, 5px, p, 12px, p, 5px, p, 12px, p, 12px");
        this.setLayout(formLayout);
        this.setTitle("Select Classes");
        this.labelClassName = new JLabel("Class name:");
        this.add((Component)this.labelClassName, new CellConstraints("2, 2, 1, 1, default, default"));
        this.textClassName = new JTextField("");
        this.add((Component)this.textClassName, new CellConstraints("2, 4, 1, 1, default, default"));
        this.labelClassFilter = new JLabel("Class filter:");
        this.add((Component)this.labelClassFilter, new CellConstraints("2, 6, 1, 1, default, default"));
        this.textClassFilter = new JTextField("");
        this.add((Component)this.textClassFilter, new CellConstraints("2, 8, 1, 1, default, default"));
        this.labelClassList = new JLabel("Class list:");
        this.add((Component)this.labelClassList, new CellConstraints("2, 10, 1, 1, default, default"));
        this.listModel = new FilteredListModel();
        this.listClasses = new JList();
        this.listClasses.setModel(this.listModel);
        this.listClasses.getSelectionModel().setSelectionMode(0);
        this.listClasses.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    ClassSelectorDialog.this.textClassName.setText((String)ClassSelectorDialog.this.listClasses.getSelectedValue());
                } else {
                    ClassSelectorDialog.this.textClassName.setText((String)ClassSelectorDialog.this.listClasses.getSelectedValue());
                }
            }
        });
        this.scrollClasses = new JScrollPane(this.listClasses);
        this.add((Component)this.scrollClasses, new CellConstraints("2, 12, 1, 1, default, default"));
        this.scrollClasses.setVerticalScrollBarPolicy(22);
        this.scrollClasses.setHorizontalScrollBarPolicy(32);
        this.panelButtons = new JPanel();
        this.buttonOk = new JButton("OK");
        this.panelButtons.add(this.buttonOk);
        this.buttonCancel = new JButton("Cancel");
        this.panelButtons.add(this.buttonCancel);
        this.buttonOk.setActionCommand(CMD_OK);
        this.buttonCancel.setActionCommand(CMD_CANCEL);
        this.buttonOk.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.add((Component)this.panelButtons, new CellConstraints("2, 14, 1, 1, default, default"));
        this.registerEnterAction(this.buttonOk);
        this.registerEscapeAction();
        Document document = this.textClassFilter.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateList(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateList(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void updateList(DocumentEvent documentEvent) {
                if (documentEvent == null) {
                    // empty if block
                }
                String string = ClassSelectorDialog.this.textClassFilter.getText();
                ClassSelectorDialog.this.listModel.updateFilter(string);
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_OK)) {
            String string2 = this.textClassName.getText();
            if (!this.checkIsInList(string2)) {
                JOptionPane.showMessageDialog(this, "Class Name not in List!", "Class not in list", 0);
                return;
            }
            this.selectedClassName = string2;
            this.setWindowCloseCode(1);
            this.setVisible(false);
        } else if (string.equals(CMD_CANCEL)) {
            this.setWindowCloseCode(2);
            this.setVisible(false);
        }
    }

    protected boolean checkIsInList(String string) {
        boolean bl = false;
        if (this.listClassNamesEngine.contains(string)) {
            return true;
        }
        return bl;
    }

    public boolean isRequireInList() {
        return this.requireInList;
    }

    public void setRequireInList(boolean bl) {
        this.requireInList = bl;
    }

    public void addClasses(String[] stringArray) {
        if (this.listClassNamesEngine == null) {
            this.listClassNamesEngine = new ArrayList();
        }
        for (String string : stringArray) {
            this.listClassNamesEngine.add(string);
        }
    }

    public void updateControls() {
        this.listModel.clear();
        this.listModel.addList(this.listClassNamesEngine);
        this.updateControlsFilter();
        this.pack();
    }

    protected void updateControlsFilter() {
        this.listModel.updateFilter(this.filter);
        if (this.listModel.getSize() == 1) {
            this.listClasses.setSelectedIndex(0);
        }
        if (!this.isVisible()) {
            this.pack();
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String string) {
        this.filter = string;
        this.textClassFilter.setText(string);
        this.updateControlsFilter();
    }

    public String getSelectedClassName() {
        return this.selectedClassName;
    }

    public void setSelectedClassName(String string) {
        this.selectedClassName = string;
    }
}

