/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.gmx;

import de.admadic.ui.gmx.SnowFlake;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class SnowWorld {
    final double RESTLIMIT = 0.5;
    final double EDGELIMIT = 0.5;
    final double CREALIMIT = 0.1;
    Rectangle frame;
    Vector<Rectangle> bounds;
    Hashtable<Integer, Vector<Rectangle>> boundsHash;
    Vector<SnowFlake> restingSnowFlakes;
    Hashtable<Integer, Hashtable<Integer, SnowFlake>> restHash;
    Vector<SnowFlake> snow;
    Vector<SnowFlake> deadSnow;
    BufferedImage restImage;
    BufferedImage compImage;
    Graphics2D restGfx;
    Graphics2D compGfx;
    Vector<SnowFlake> avalanche;
    Semaphore sem = new Semaphore(1);
    int restFlags;

    public SnowWorld() {
        this(0);
    }

    public SnowWorld(int n) {
        this.sem.acquireUninterruptibly();
        this.bounds = new Vector();
        this.frame = new Rectangle(0, 0, 0, 0);
        this.restingSnowFlakes = new Vector();
        this.restHash = new Hashtable();
        this.snow = new Vector();
        this.deadSnow = new Vector();
        this.avalanche = new Vector();
        this.restFlags = n;
        this.sem.release();
    }

    public void setFrame(int n, int n2, int n3, int n4) {
        this.frame = new Rectangle(n, n2, n3, n4);
        if (this.snow.size() > 0 || this.restingSnowFlakes.size() > 0) {
            this.shake();
        }
    }

    public Rectangle getFrame() {
        return this.frame;
    }

    protected void updateBoundsHash() {
        this.boundsHash = new Hashtable();
        int n = 0;
        for (Rectangle rectangle : this.bounds) {
            Vector<Object> vector;
            Integer n2;
            if ((this.restFlags & 1) != 0) {
                n2 = rectangle.y;
                if (this.boundsHash.containsKey(n2)) {
                    vector = this.boundsHash.get(n2);
                } else {
                    vector = new Vector();
                    this.boundsHash.put(n2, vector);
                }
                vector.add(rectangle);
                System.out.println("bound at " + rectangle.y);
                ++n;
            }
            if ((this.restFlags & 2) == 0) continue;
            n2 = rectangle.y + rectangle.height - 1;
            if (this.boundsHash.containsKey(n2)) {
                vector = this.boundsHash.get(n2);
            } else {
                vector = new Vector();
                this.boundsHash.put(n2, vector);
            }
            vector.add(rectangle);
            ++n;
        }
    }

    public void initFromContainer(Container container) {
        JRootPane jRootPane = SwingUtilities.getRootPane(container);
        Component component = jRootPane.getGlassPane();
        Point point = SwingUtilities.convertPoint(container, 0, 0, component);
        this.setFrame(point.x, point.y, container.getWidth(), container.getHeight());
        Component[] componentArray = container.getComponents();
        this.bounds.clear();
        for (Component component2 : componentArray) {
            if (!(component2 instanceof JButton) && !(component2 instanceof JToggleButton) && !(component2 instanceof JTextField)) continue;
            Rectangle rectangle = component2.getBounds();
            rectangle.translate(point.x, point.y);
            this.bounds.add(rectangle);
        }
        Rectangle rectangle = container.getBounds();
        rectangle.translate(point.x, point.y);
        this.bounds.add(rectangle);
        this.updateBoundsHash();
        this.newRestImage();
    }

    public void initFromComponent(Component component, Component component2) {
        Point point = new Point(0, 0);
        if (component2 != null) {
            point = SwingUtilities.convertPoint(component2, 0, 0, component);
        }
        this.setFrame(component.getX() - point.x, component.getY() - point.y, component.getWidth(), component.getHeight());
        this.bounds.clear();
        Rectangle rectangle = component2 != null ? component2.getBounds() : component.getBounds();
        rectangle.translate(-rectangle.x, -rectangle.y);
        this.bounds.add(rectangle);
        this.updateBoundsHash();
        this.newRestImage();
    }

    public void restSnowFlake(SnowFlake snowFlake) {
        Hashtable<Object, Object> hashtable;
        snowFlake.status = 0;
        Integer n = snowFlake.y;
        if (!this.restHash.containsKey(n)) {
            hashtable = new Hashtable();
            this.restHash.put(n, hashtable);
        } else {
            hashtable = this.restHash.get(n);
        }
        Integer n2 = snowFlake.x;
        if (hashtable.containsKey(n2)) {
            snowFlake.status = 2;
            this.deadSnow.add(snowFlake);
            snowFlake.y = -1;
            return;
        }
        hashtable.put(snowFlake.x, snowFlake);
        this.restingSnowFlakes.add(snowFlake);
        if (this.restGfx != null) {
            this.restGfx.setColor(Color.WHITE);
            snowFlake.paint(this.restGfx);
        }
        int n3 = snowFlake.y + 1;
        n = n3;
        n2 = snowFlake.x;
        if (this.restHash.containsKey(n) && (hashtable = this.restHash.get(n)).containsKey(n2)) {
            SnowFlake snowFlake2;
            SnowFlake snowFlake3 = (SnowFlake)hashtable.get(n2);
            snowFlake.sitsOnArg(snowFlake3);
            SnowFlake snowFlake4 = snowFlake2 = snowFlake.getRoot();
            if (this.restImage != null) {
                while (snowFlake2 != null) {
                    snowFlake2.paintSqueeze(this.restGfx);
                    snowFlake2 = snowFlake2.aboveme;
                }
            }
            if (snowFlake4.squeeze > 8) {
                this.avalanche.add(snowFlake4);
            }
        }
    }

    public boolean isOnEdge(SnowFlake snowFlake) {
        boolean bl = false;
        if (!snowFlake.isFalling()) {
            return bl;
        }
        Integer n = snowFlake.y;
        if (this.boundsHash.containsKey(n)) {
            Vector<Rectangle> vector = this.boundsHash.get(n);
            for (Rectangle rectangle : vector) {
                if (rectangle.y != snowFlake.y && rectangle.y + rectangle.height - 1 != snowFlake.y || snowFlake.x < rectangle.x || snowFlake.x >= rectangle.x + rectangle.width) continue;
                return true;
            }
        }
        return bl;
    }

    public boolean isAnyRestingAt(int n, int n2) {
        Integer n3 = n2;
        Integer n4 = n;
        if (!this.restHash.containsKey(n3)) {
            return false;
        }
        Hashtable<Integer, SnowFlake> hashtable = this.restHash.get(n3);
        return hashtable.containsKey(n4);
    }

    public boolean isOnRestingSnowFlake(SnowFlake snowFlake) {
        if (!snowFlake.isFalling()) {
            return false;
        }
        Integer n = snowFlake.y + 1;
        Integer n2 = snowFlake.x;
        if (!this.restHash.containsKey(n)) {
            return false;
        }
        Hashtable<Integer, SnowFlake> hashtable = this.restHash.get(n);
        boolean bl = hashtable.containsKey(n2);
        boolean bl2 = hashtable.containsKey(snowFlake.x - 1);
        boolean bl3 = hashtable.containsKey(snowFlake.x + 1);
        if (!bl) {
            return false;
        }
        return bl2 || bl3;
    }

    public void newRestImage() {
        if (this.frame.width < 1) {
            this.restImage = null;
            this.restGfx = null;
            return;
        }
        this.restImage = new BufferedImage(this.frame.width, this.frame.height, 6);
        this.restGfx = this.restImage.createGraphics();
        this.restGfx.setColor(Color.WHITE);
    }

    public void newCompImage() {
        if (this.frame.width < 1) {
            this.compImage = null;
            this.compGfx = null;
            return;
        }
        this.compImage = new BufferedImage(this.frame.width, this.frame.height, 6);
        this.compGfx = this.compImage.createGraphics();
        this.compGfx.setColor(Color.WHITE);
    }

    public void shake() {
        for (SnowFlake object : this.restingSnowFlakes) {
            object.forgetBelowMe();
            object.status = 1;
        }
        this.restingSnowFlakes.clear();
        for (Hashtable hashtable : this.restHash.values()) {
            hashtable.clear();
        }
        this.newRestImage();
    }

    /*
     * WARNING - void declaration
     */
    public void updateSnow() {
        void var2_9;
        for (SnowFlake object : this.snow) {
            if (object.isDead() || object.isRest()) continue;
            object.timeStep(this);
            boolean bl = this.isOnRestingSnowFlake(object);
            if (bl) {
                if (Math.random() < 0.5) {
                    object.reststatus = 2;
                    this.restSnowFlake(object);
                }
            } else {
                boolean bl2 = this.isOnEdge(object);
                if (bl2 && Math.random() < 0.5) {
                    object.reststatus = 1;
                    this.restSnowFlake(object);
                }
            }
            if (!object.isDead()) continue;
            this.deadSnow.add(object);
        }
        boolean bl = false;
        for (SnowFlake snowFlake : this.avalanche) {
            if (!(Math.random() <= 1.0)) continue;
            bl = true;
            this.createAvalanche(snowFlake);
            this.removeFromRestLists(snowFlake);
        }
        this.avalanche.clear();
        this.sem.acquireUninterruptibly();
        for (SnowFlake snowFlake : this.deadSnow) {
            this.snow.remove(snowFlake);
            this.removeFromRestLists(snowFlake);
        }
        this.sem.release();
        this.deadSnow.clear();
        if (bl) {
            this.newRestImage();
            if (this.restImage != null) {
                for (SnowFlake snowFlake : this.restingSnowFlakes) {
                    snowFlake.paintResting(this.restGfx);
                }
            }
        }
        this.sem.acquireUninterruptibly();
        boolean bl3 = false;
        while (var2_9 < 1 + this.frame.width * 3 / 200) {
            if (Math.random() < 0.1) {
                this.snow.add(SnowFlake.create(this));
            }
            ++var2_9;
        }
        this.sem.release();
    }

    public void removeFromRestLists(SnowFlake snowFlake) {
        Integer n;
        Integer n2;
        if (snowFlake.isRest()) {
            this.restingSnowFlakes.remove(snowFlake);
        }
        if (!this.restHash.containsKey(n2 = Integer.valueOf(snowFlake.y))) {
            return;
        }
        Hashtable<Integer, SnowFlake> hashtable = this.restHash.get(n2);
        if (!hashtable.containsKey(n = Integer.valueOf(snowFlake.x))) {
            return;
        }
        hashtable.remove(n);
    }

    public void createAvalanche(SnowFlake snowFlake) {
        boolean bl;
        int n = snowFlake.y;
        int n2 = snowFlake.x;
        int n3 = snowFlake.x;
        snowFlake.status = 3;
        snowFlake.dirhold = 0;
        snowFlake.forgetBelowMe();
        do {
            Integer n4;
            --n2;
            ++n3;
            bl = false;
            if (!this.restHash.containsKey(n4 = Integer.valueOf(--n))) break;
            Hashtable<Integer, SnowFlake> hashtable = this.restHash.get(n4);
            for (int i = n2; i <= n3; ++i) {
                n4 = i;
                if (!hashtable.containsKey(n4)) continue;
                bl = true;
                SnowFlake snowFlake2 = hashtable.get(n4);
                snowFlake2.status = 2;
                snowFlake2.forgetBelowMe();
                this.deadSnow.add(snowFlake2);
            }
        } while (bl);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        if (this.restImage != null) {
            graphics.drawImage(this.restImage, 0, 0, null);
        }
        try {
            this.sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        for (SnowFlake snowFlake : this.snow) {
            if (this.restImage == null && snowFlake.isRest()) {
                snowFlake.paint(graphics);
            }
            if (!snowFlake.isFalling() && !snowFlake.isAvalanche()) continue;
            snowFlake.paint(graphics);
        }
        this.sem.release();
    }
}

