/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.gmx;

import de.admadic.ui.gmx.SnowWorld;
import java.awt.Color;
import java.awt.Graphics;

public class SnowFlake {
    int x = 0;
    int y = 0;
    int sidedir = 0;
    int dirhold = 0;
    public static final int ST_REST = 0;
    public static final int ST_FALLING = 1;
    public static final int ST_DEAD = 2;
    public static final int ST_AVALANCHE = 3;
    int status = 0;
    int resting = 0;
    int squeeze = 0;
    public static final int ST_REST_NONE = 0;
    public static final int ST_REST_EDGE = 1;
    public static final int ST_REST_SNOW = 2;
    int reststatus = 0;
    int straight = 0;
    SnowFlake aboveme;
    SnowFlake belowme;

    public void sitsOnArg(SnowFlake snowFlake) {
        snowFlake.aboveme = this;
        this.belowme = snowFlake;
        this.updateSqueeze(0);
    }

    public void updateSqueeze(int n) {
        this.squeeze = n;
        if (this.belowme != null) {
            this.belowme.updateSqueeze(this.squeeze + 1);
        }
    }

    public void forgetBelowMe() {
        SnowFlake snowFlake = this.belowme;
        if (snowFlake != null) {
            snowFlake.aboveme = null;
            this.belowme = null;
        }
    }

    public SnowFlake getRoot() {
        SnowFlake snowFlake = this;
        while (snowFlake.belowme != null) {
            snowFlake = snowFlake.belowme;
            if (snowFlake != this) continue;
            throw new Error("SnowFlake: chaining is circular!");
        }
        return snowFlake;
    }

    public int countWeight() {
        SnowFlake snowFlake = this;
        int n = 0;
        while (snowFlake.aboveme != null) {
            ++n;
            snowFlake = snowFlake.aboveme;
        }
        return n;
    }

    @Deprecated
    public void addSqueeze() {
        ++this.squeeze;
    }

    public boolean isDead() {
        return this.status == 2;
    }

    public boolean isAvalanche() {
        return this.status == 3;
    }

    public boolean isRest() {
        return this.status == 0;
    }

    public boolean isFalling() {
        return this.status == 1;
    }

    public void newDir() {
        this.sidedir = (int)Math.round(Math.random() * 2.0) - 1;
        this.dirhold = (int)(Math.random() * 5.0);
        this.straight = 1 - this.straight;
    }

    public void timeStep(SnowWorld snowWorld) {
        if (this.status == 2) {
            return;
        }
        if (this.status == 0) {
            ++this.resting;
            return;
        }
        if (this.status == 3) {
            this.y += this.dirhold;
            ++this.dirhold;
        }
        if (this.status == 1) {
            if (this.dirhold % 2 == 0) {
                this.x += this.sidedir;
            }
            --this.dirhold;
            if (this.dirhold < 0) {
                this.newDir();
            }
            if (this.x < snowWorld.getFrame().x) {
                this.x = 0;
            }
            if (this.x >= snowWorld.getFrame().x + snowWorld.getFrame().width) {
                this.x = snowWorld.getFrame().x + snowWorld.getFrame().width - 1;
            }
            if (Math.random() < 0.1) {
                --this.y;
            }
            ++this.y;
        }
        if (this.y > snowWorld.getFrame().y + snowWorld.getFrame().height) {
            this.status = 2;
        }
    }

    public static SnowFlake create(SnowWorld snowWorld) {
        SnowFlake snowFlake = new SnowFlake();
        snowFlake.x = (int)(Math.random() * (double)(snowWorld.getFrame().x + snowWorld.getFrame().width));
        snowFlake.y = snowWorld.getFrame().y + 1;
        snowFlake.newDir();
        snowFlake.status = 1;
        return snowFlake;
    }

    public void paintResting(Graphics graphics) {
        if (!this.isRest()) {
            return;
        }
        this.paint(graphics);
        this.paintRestingImpl(graphics);
    }

    public void paintRestingImpl(Graphics graphics) {
        if (!this.isRest()) {
            return;
        }
        if (this.squeeze > 0) {
            this.paintSqueeze(graphics);
        }
    }

    public void paint(Graphics graphics) {
        if (this.status == 3) {
            Color color = graphics.getColor();
            graphics.setColor(Color.WHITE);
            graphics.fillOval(this.x - 3, this.y - 2, 7, 7);
            graphics.setColor(color);
        } else {
            if (this.straight == 0) {
                graphics.drawLine(this.x - 1, this.y, this.x + 1, this.y);
                graphics.drawLine(this.x, this.y - 1, this.x, this.y + 1);
            } else {
                graphics.drawLine(this.x - 1, this.y - 1, this.x + 1, this.y + 1);
                graphics.drawLine(this.x + 1, this.y - 1, this.x - 1, this.y + 1);
            }
            if (this.status == 0) {
                this.paintRestingImpl(graphics);
            }
        }
    }

    public void paintSqueeze(Graphics graphics) {
        Color color = graphics.getColor();
        Color color2 = Color.WHITE;
        int[] nArray = new int[]{250, 245, 245, 245, 240, 230, 220, 210, 200, 180};
        int n = this.squeeze >= nArray.length ? nArray[nArray.length - 1] : nArray[this.squeeze];
        color2 = this.reststatus == 1 ? new Color(n, n, n) : new Color(n, n, 255);
        graphics.setColor(color2);
        graphics.drawLine(this.x, this.y, this.x, this.y);
        graphics.setColor(color);
    }
}

