/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.ui.gmx;

import de.admadic.ui.gmx.SnowViewport;
import de.admadic.ui.gmx.SnowWorld;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class SnowEngine
implements Runnable {
    int sleeptime;
    int threshold;
    int counter;
    long lastshake;
    Thread ticker;
    SnowWorld sw;
    Container container;
    Component target;
    Component sizeTarget;

    public static SnowEngine createInFirstScrollpane(Container container, int n) {
        Component component;
        SnowEngine snowEngine = null;
        JScrollPane jScrollPane = null;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            component = componentArray[i];
            if (!(component instanceof JScrollPane)) continue;
            jScrollPane = (JScrollPane)component;
            break;
        }
        if (jScrollPane == null) {
            return null;
        }
        SnowViewport snowViewport = new SnowViewport();
        component = jScrollPane.getViewport();
        Component component2 = ((JViewport)component).getView();
        jScrollPane.setViewport(snowViewport);
        jScrollPane.setViewportView(component2);
        snowEngine = new SnowEngine(null, component2, snowViewport, n);
        snowViewport.setSnowEngine(snowEngine);
        snowViewport.setScrollMode(0);
        return snowEngine;
    }

    public static void removeFromFirstScrollpane(Container container) {
        Component component;
        SnowEngine snowEngine = null;
        JScrollPane jScrollPane = null;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            component = componentArray[i];
            if (!(component instanceof JScrollPane)) continue;
            jScrollPane = (JScrollPane)component;
            break;
        }
        if (jScrollPane == null) {
            return;
        }
        JViewport jViewport = jScrollPane.getViewport();
        if (!(jViewport instanceof SnowViewport)) {
            return;
        }
        component = (SnowViewport)jViewport;
        Component component2 = jViewport.getView();
        jScrollPane.setViewport(null);
        jScrollPane.setViewportView(component2);
        snowEngine = ((SnowViewport)component).se;
        if (snowEngine != null) {
            snowEngine = null;
        }
        component = null;
    }

    public SnowEngine(Container container, Component component, int n) {
        this(container, component, null, n);
    }

    public SnowEngine(Container container, Component component, Component component2, int n) {
        this.container = container;
        this.sw = new SnowWorld(n);
        this.setTarget(component, component2);
        this.counter = 0;
        this.threshold = 10;
        this.sleeptime = 50;
        this.lastshake = -1L;
    }

    public void setTarget(Component component) {
        this.setTarget(component, null);
    }

    public void setTarget(Component component, Component component2) {
        this.container = null;
        this.sizeTarget = component2;
        if (this.ticker != null) {
            if (this.target != null) {
                this.setActive(false);
            }
            this.target = component;
            if (this.target != null) {
                this.setActive(true);
            }
        } else {
            this.target = component;
        }
    }

    public void shake() {
        long l;
        if (this.sw != null && (l = System.currentTimeMillis()) - this.lastshake > 200L) {
            this.sw.shake();
            this.lastshake = l;
        }
    }

    public void setActive(boolean bl) {
        if (bl) {
            if (this.ticker == null) {
                this.counter = 0;
                if (this.container != null) {
                    this.sw.initFromContainer(this.container);
                } else {
                    this.sw.initFromComponent(this.target, this.sizeTarget);
                }
                this.ticker = new Thread(this);
                this.ticker.start();
            }
        } else if (this.ticker != null) {
            this.ticker = null;
        }
    }

    public void paint(Graphics graphics) {
        if (this.sw != null) {
            this.sw.paint(graphics);
        }
    }

    public synchronized void updateSnow() {
        this.sw.updateSnow();
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.ticker != null && thread == this.ticker) {
            ++this.counter;
            if (this.counter >= this.threshold) {
                if (this.container != null && this.container.isVisible()) {
                    this.updateSnow();
                    this.container.repaint();
                }
                if (this.target != null && this.target.isVisible()) {
                    this.updateSnow();
                    if (this.sizeTarget != null) {
                        this.sizeTarget.repaint();
                    } else {
                        this.target.repaint();
                    }
                }
            }
            try {
                Thread.sleep(this.sleeptime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

