/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.laf;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.util.OS;
import de.admadic.laf.LaF;
import de.admadic.laf.LaFSkin;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class LaFSkinLF
extends LaF {
    private Logger logger = this.getLogger();
    private String lastSkinName;

    public LaFSkinLF(String string, String string2, boolean bl) {
        super(string, string2, bl);
        if (this.logger != null) {
            this.logger.fine("LaFSkinLF: accessing SkinUtils...");
        }
        if (this.logger != null) {
            this.logger.fine("LaFSkinLF: class name = " + SkinUtils.class.getName());
        }
    }

    public LaFSkinLF(String string, String string2, boolean bl, int n) {
        super(string, string2, bl, n);
        if (this.logger != null) {
            this.logger.fine("LaFSkinLF: accessing SkinUtils...");
        }
        if (this.logger != null) {
            this.logger.fine("LaFSkinLF: class name = " + SkinUtils.class.getName());
        }
    }

    @Override
    public boolean postSelect() {
        block5: {
            try {
                if (OS.isOneDotFourOrMore()) {
                    boolean bl = UIManager.getLookAndFeel().getSupportsWindowDecorations();
                    if (bl) {
                        Method method = JFrame.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                        method.invoke(null, Boolean.TRUE);
                        method = JDialog.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                        method.invoke(null, Boolean.TRUE);
                    } else {
                        Method method = JFrame.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                        method.invoke(null, Boolean.FALSE);
                        method = JDialog.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                        method.invoke(null, Boolean.FALSE);
                    }
                }
            }
            catch (Exception exception) {
                if (this.logger == null) break block5;
                this.logger.severe("Error selecting LaF: " + exception.getMessage());
            }
        }
        return true;
    }

    @Override
    public boolean preSelect() {
        return true;
    }

    @Override
    public boolean select() {
        if (this.getLastSkinName() != null && this.getLastSkinName().startsWith("theme:")) {
            return true;
        }
        return super.select();
    }

    @Override
    public boolean selectSkin(LaFSkin laFSkin) {
        try {
            String string = laFSkin.getDataName();
            if (string.endsWith(".xml")) {
                SkinLookAndFeel.setSkin(SkinLookAndFeel.loadThemePackDefinition(SkinUtils.toURL(new File(this.getThemepackPath() + string))));
            } else if (string.startsWith("class:")) {
                String string2 = string.substring("class:".length());
                SkinLookAndFeel.setSkin((Skin)Class.forName(string2).newInstance());
            } else if (string.startsWith("theme:")) {
                String string3 = string.substring("theme:".length());
                MetalTheme metalTheme = (MetalTheme)Class.forName(string3).newInstance();
                MetalLookAndFeel metalLookAndFeel = new MetalLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(metalTheme);
                UIManager.setLookAndFeel(metalLookAndFeel);
            } else {
                String string4 = this.getThemepackPath() + string;
                File file = new File(string4);
                if (file.exists()) {
                    SkinLookAndFeel.setSkin(SkinLookAndFeel.loadThemePack(this.getThemepackPath() + string));
                } else {
                    String string5 = "/laf/SkinLF/themes/" + string;
                    URL uRL = this.getClass().getResource(string5);
                    SkinLookAndFeel.setSkin(SkinLookAndFeel.loadThemePack(uRL));
                }
            }
            this.setLastSkinName(string);
        }
        catch (Exception exception) {
            if (this.logger != null) {
                this.logger.severe("Error selecting Skin: " + exception.getMessage());
            }
            return false;
        }
        return true;
    }

    public String getLastSkinName() {
        return this.lastSkinName;
    }

    public void setLastSkinName(String string) {
        this.lastSkinName = string;
    }
}

