/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.laf;

import de.admadic.laf.LaF;
import de.admadic.laf.LaFChangeEvent;
import de.admadic.laf.LaFChangeListener;
import de.admadic.laf.LaFSkin;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class LaFManager {
    static final boolean LOG = true;
    static final Logger logger = Logger.getLogger("de.admadic");
    ArrayList<Component> components;
    ArrayList<LaF> laFs;
    Hashtable<LaF, ArrayList<LaFSkin>> skins;
    LaF selectedLaF = null;
    LaFSkin selectedLaFSkin = null;
    LaF fallBackLaF;
    EventListenerList listenerList = new EventListenerList();
    LaFChangeEvent lafChangeEvent = null;
    ClassLoader classLoader = null;

    public LaFManager() {
        this.components = new ArrayList();
        this.laFs = new ArrayList();
        this.skins = new Hashtable();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        UIManager.put("ClassLoader", this.classLoader);
    }

    public void initStandardLaFs() {
        this.addLaF("Java", UIManager.getCrossPlatformLookAndFeelClassName(), true);
        this.addLaF("System", UIManager.getSystemLookAndFeelClassName(), false);
        this.addLaF("Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", false);
        this.addLaF("GTK", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", false);
        this.addLaF("Motif", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", false);
    }

    public void addComponent(Component component) {
        this.components.add(component);
    }

    public void addComponentToHead(Component component) {
        this.components.add(0, component);
    }

    public void removeComponent(Component component) {
        this.components.remove(component);
    }

    protected void addLaFImpl(LaF laF) {
        if (this.classLoader != null) {
            laF.setClassLoader(this.classLoader);
        }
        this.laFs.add(laF);
        this.skins.put(laF, new ArrayList());
        if (laF.getClassName() != null && laF.getClassName().equals(UIManager.getCrossPlatformLookAndFeelClassName())) {
            this.fallBackLaF = laF;
        }
    }

    protected void removeLaFImpl(LaF laF) {
        this.laFs.remove(laF);
        this.skins.remove(laF);
        if (this.fallBackLaF == laF) {
            this.fallBackLaF = null;
        }
    }

    public void addSkin(LaF laF, LaFSkin laFSkin) {
        this.skins.get(laF).add(laFSkin);
    }

    public void removeSkin(LaF laF, LaFSkin laFSkin) {
        this.skins.get(laF).remove(laFSkin);
    }

    public void addSkin(LaF laF, String string, String string2) {
        this.addSkin(laF, new LaFSkin(string, string2));
    }

    public void addLaF(String string, String string2, boolean bl) {
        this.addLaF(string, string2, bl, null, 0);
    }

    public void addLaF(String string, String string2, boolean bl, String string3, int n) {
        LaF laF;
        block13: {
            laF = null;
            if (string3 == null) {
                if (logger != null) {
                    logger.fine("addLaF: creating simple LaF without handler class for: " + string + ":" + string2);
                }
                laF = new LaF(string, string2, bl, n);
            } else {
                if (logger != null) {
                    logger.fine("addLaF: creating simple LaF with handler class for: " + string + ":" + string2 + ":" + string3);
                }
                try {
                    Class<?> clazz;
                    Class[] classArray = new Class[]{String.class, String.class, Boolean.TYPE, Integer.TYPE};
                    Object[] objectArray = new Object[]{new String(string), new String(string2), new Boolean(bl), new Integer(n)};
                    if (this.classLoader != null) {
                        if (logger != null) {
                            logger.fine("addLaF: using custom class loader for: " + string3);
                        }
                        clazz = this.classLoader.loadClass(string3);
                    } else {
                        if (logger != null) {
                            logger.fine("addLaF: using system class loader for: " + string3);
                        }
                        clazz = Class.forName(string3);
                    }
                    Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                    Object obj = constructor.newInstance(objectArray);
                    if (logger != null) {
                        logger.fine("addLaF: LaF instance created.");
                    }
                    laF = (LaF)obj;
                }
                catch (Exception exception) {
                    if (logger == null) break block13;
                    logger.severe("Error adding LaF: " + exception.getMessage());
                }
            }
        }
        if (laF == null) {
            if (logger != null) {
                logger.warning("addLaF: failed to create LaF instance for " + string);
            }
            return;
        }
        this.addLaFImpl(laF);
    }

    public void removeLaF(String string, String string2) {
        LaF laF = this.getLaF(string, string2);
        if (laF != null) {
            this.removeLaFImpl(laF);
        }
    }

    public void clearAllLaFs() {
        this.laFs.clear();
        this.skins.clear();
    }

    public void updateUI() {
        Component component;
        int n;
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(this.components.size());
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>(this.components.size());
        boolean bl = UIManager.getLookAndFeel().getSupportsWindowDecorations();
        for (n = 0; n < this.components.size(); ++n) {
            Window window;
            component = this.components.get(n);
            boolean bl2 = component.isDisplayable();
            boolean bl3 = component.isVisible();
            arrayList.add(n, new Boolean(bl2));
            arrayList2.add(n, new Boolean(bl3));
            if (component instanceof Frame) {
                window = (Frame)component;
                if (bl2) {
                    window.dispose();
                }
                ((Frame)window).setUndecorated(bl);
            }
            if (component instanceof Dialog) {
                window = (Dialog)component;
                if (bl2) {
                    window.dispose();
                }
                ((Dialog)window).setUndecorated(bl);
            }
            SwingUtilities.updateComponentTreeUI(component);
            if (!(component instanceof Window)) continue;
            ((Window)component).pack();
        }
        for (n = this.components.size() - 1; n >= 0; --n) {
            component = this.components.get(n);
            if (!((Boolean)arrayList2.get(n)).booleanValue()) continue;
            component.setVisible(true);
        }
    }

    public LaF getLaF(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        for (LaF laF : this.laFs) {
            boolean bl = true;
            if (string != null && !string.equals(laF.getName())) {
                bl = false;
            }
            if (string2 != null && !string2.equals(laF.getClassName())) {
                bl = false;
            }
            if (!bl) continue;
            return laF;
        }
        return null;
    }

    protected LaFSkin getLaFSkin(LaF laF, String string) {
        if (laF == null || string == null) {
            return null;
        }
        ArrayList<LaFSkin> arrayList = this.skins.get(laF);
        for (LaFSkin laFSkin : arrayList) {
            if (!string.equals(laFSkin.name)) continue;
            return laFSkin;
        }
        return null;
    }

    public LaF getSelectedLaF() {
        return this.selectedLaF;
    }

    public LaFSkin getSelectedLaFSkin() {
        return this.selectedLaFSkin;
    }

    public boolean selectLaF(String string) {
        return this.selectLaF(string, null);
    }

    public boolean selectLaF(String string, String string2) {
        LaF laF;
        if (logger != null) {
            logger.fine("selectLaF: " + string + ", " + string2);
        }
        if ((laF = this.getLaF(string, null)) == null) {
            if (logger != null) {
                logger.warning("could not find LaF " + string);
            }
            return false;
        }
        LaFSkin laFSkin = null;
        if (string2 != null) {
            laFSkin = this.getLaFSkin(laF, string2);
        }
        LaF laF2 = this.selectedLaF;
        LaFSkin laFSkin2 = this.selectedLaFSkin;
        this.fireLaFChangeBegin(string, string2);
        boolean bl = true;
        try {
            if (bl) {
                if (logger != null) {
                    logger.fine("preSelect");
                }
                bl = laF.preSelect();
            }
            if (bl && laFSkin != null) {
                if (logger != null) {
                    logger.fine("selectSkin");
                }
                bl = laF.selectSkin(laFSkin);
            }
            if (bl) {
                if (logger != null) {
                    logger.fine("select");
                }
                bl = laF.select();
            }
            if (bl) {
                if (logger != null) {
                    logger.fine("postSelect");
                }
                bl = laF.postSelect();
            }
        }
        catch (NullPointerException nullPointerException) {
            if (logger != null) {
                logger.warning(nullPointerException.getMessage());
            }
            bl = false;
        }
        catch (Exception exception) {
            if (logger != null) {
                logger.warning(exception.getMessage());
            }
            bl = false;
        }
        catch (Error error) {
            if (logger != null) {
                logger.warning(error.getMessage());
            }
            bl = false;
        }
        if (!bl) {
            if (logger != null) {
                logger.warning("selectLaF: failed. restoring old settings");
            }
            if (laF2 != null) {
                laF2.preSelect();
                if (laFSkin2 != null) {
                    laF2.selectSkin(laFSkin2);
                }
                laF2.select();
                laF2.postSelect();
            } else {
                laF = this.fallBackLaF;
                if (laF != null) {
                    laF.preSelect();
                    laF.select();
                    laF.postSelect();
                }
            }
            this.fireLaFChangeFailed(string, string2);
        } else {
            this.selectedLaF = laF;
            this.selectedLaFSkin = laFSkin;
            this.fireLaFChanged(string, string2);
        }
        this.updateUI();
        this.fireLaFChangedUI(string, string2);
        return bl;
    }

    public String[] getLaFNames() {
        return this.getLaFNames(0);
    }

    public String[] getLaFNames(int n) {
        int n2 = 0;
        String[] stringArray = null;
        if (n == 0) {
            n2 = this.laFs.size();
            stringArray = new String[n2];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.laFs.get(i).getName();
            }
        } else {
            int n3;
            for (n3 = 0; n3 < this.laFs.size(); ++n3) {
                if (this.laFs.get(n3).getType() != n) continue;
                ++n2;
            }
            stringArray = new String[n2];
            n3 = 0;
            for (int i = 0; i < this.laFs.size(); ++i) {
                if (this.laFs.get(i).getType() != n) continue;
                stringArray[n3] = this.laFs.get(i).getName();
                ++n3;
            }
        }
        return stringArray;
    }

    public String[] getSkinNames(LaF laF) {
        ArrayList<LaFSkin> arrayList = this.skins.get(laF);
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = arrayList.get((int)i).name;
        }
        return stringArray;
    }

    public void createLaFSkinMenu(JMenu jMenu) {
        this.createLaFSkinMenu(jMenu, true);
    }

    public void createLaFSkinMenu(JMenu jMenu, boolean bl) {
        LaF laF;
        int n;
        if (this.laFs.size() < 1) {
            JMenuItem jMenuItem = new JMenuItem();
            jMenu.add(jMenuItem);
            jMenuItem.setText("<No Skins>");
            jMenuItem.setEnabled(false);
            return;
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                String string;
                String string2;
                String string3 = actionEvent.getActionCommand();
                int n = string3.indexOf(":");
                if (n >= 0) {
                    string2 = string3.substring(0, n);
                    string = string3.substring(n + 1);
                } else {
                    string2 = string3;
                    string = null;
                }
                try {
                    bl = LaFManager.this.selectLaF(string2, string);
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (!bl) {
                    JOptionPane.showMessageDialog(null, "An Error occured during activation of\nLook-And-Feel = '" + string2 + "' , Skin = '" + string + "'.\nYou may want to contact customer support.", "Error selecting Skin", 0);
                }
            }
        };
        if (logger != null) {
            logger.fine("create menu PRIMARY...");
        }
        String[] stringArray = this.getLaFNames(1);
        for (n = 0; n < stringArray.length; ++n) {
            laF = this.getLaF(stringArray[n], null);
            this.createLaFSkinMenu_doLaFItem(jMenu, laF, bl, actionListener);
        }
        if (logger != null) {
            logger.fine("create menu SYSTEM...");
        }
        if ((stringArray = this.getLaFNames(2)).length > 0) {
            jMenu.add(new JSeparator());
        }
        for (n = 0; n < stringArray.length; ++n) {
            laF = this.getLaF(stringArray[n], null);
            this.createLaFSkinMenu_doLaFItem(jMenu, laF, bl, actionListener);
        }
        if (logger != null) {
            logger.fine("create menu EXTRA...");
        }
        if ((stringArray = this.getLaFNames(3)).length > 0) {
            jMenu.add(new JSeparator());
        }
        for (n = 0; n < stringArray.length; ++n) {
            laF = this.getLaF(stringArray[n], null);
            this.createLaFSkinMenu_doLaFItem(jMenu, laF, bl, actionListener);
        }
    }

    protected void createLaFSkinMenu_doLaFItem(JMenu jMenu, LaF laF, boolean bl, ActionListener actionListener) {
        if (logger != null) {
            logger.fine("create menu item laf:  name=" + laF.getName() + " cname=" + laF.getClassName());
        }
        JMenu jMenu2 = null;
        String[] stringArray = this.getSkinNames(laF);
        if (stringArray != null && stringArray.length > 0) {
            if (bl) {
                jMenu2 = new JMenu();
                jMenu.add(jMenu2);
                jMenu2.setText(laF.getName());
            } else {
                JMenuItem jMenuItem = new JMenuItem();
                jMenu.add(jMenuItem);
                jMenuItem.setText(laF.getName() + ":");
                jMenuItem.setEnabled(false);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                LaFSkin laFSkin = this.getLaFSkin(laF, stringArray[i]);
                if (logger != null) {
                    logger.fine("create menu item skin:  name=" + laFSkin.getName() + " dname=" + laFSkin.getDataName());
                }
                JMenuItem jMenuItem = new JMenuItem();
                if (bl) {
                    jMenu2.add(jMenuItem);
                } else {
                    jMenu.add(jMenuItem);
                }
                jMenuItem.setText(laFSkin.getName());
                jMenuItem.setActionCommand(laF.getName() + ":" + laFSkin.getName());
                jMenuItem.addActionListener(actionListener);
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem();
            jMenu.add(jMenuItem);
            jMenuItem.setText(laF.getName());
            jMenuItem.setActionCommand(laF.getName());
            jMenuItem.addActionListener(actionListener);
        }
    }

    public void addLaFChangeListener(LaFChangeListener laFChangeListener) {
        this.listenerList.add(LaFChangeListener.class, laFChangeListener);
    }

    public void removeLaFChangeListener(LaFChangeListener laFChangeListener) {
        this.listenerList.remove(LaFChangeListener.class, laFChangeListener);
    }

    protected void fireLaFChanged(String string, String string2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LaFChangeListener.class) continue;
            if (this.lafChangeEvent == null) {
                this.lafChangeEvent = new LaFChangeEvent(this);
            }
            this.lafChangeEvent.setLafName(string);
            this.lafChangeEvent.setSkinName(string2);
            ((LaFChangeListener)objectArray[i + 1]).lafChanged(this.lafChangeEvent);
        }
    }

    protected void fireLaFChangeBegin(String string, String string2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LaFChangeListener.class) continue;
            if (this.lafChangeEvent == null) {
                this.lafChangeEvent = new LaFChangeEvent(this);
            }
            this.lafChangeEvent.setLafName(string);
            this.lafChangeEvent.setSkinName(string2);
            ((LaFChangeListener)objectArray[i + 1]).lafChangeBegin(this.lafChangeEvent);
        }
    }

    protected void fireLaFChangeFailed(String string, String string2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LaFChangeListener.class) continue;
            if (this.lafChangeEvent == null) {
                this.lafChangeEvent = new LaFChangeEvent(this);
            }
            this.lafChangeEvent.setLafName(string);
            this.lafChangeEvent.setSkinName(string2);
            ((LaFChangeListener)objectArray[i + 1]).lafChangeFailed(this.lafChangeEvent);
        }
    }

    protected void fireLaFChangedUI(String string, String string2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LaFChangeListener.class) continue;
            if (this.lafChangeEvent == null) {
                this.lafChangeEvent = new LaFChangeEvent(this);
            }
            this.lafChangeEvent.setLafName(string);
            this.lafChangeEvent.setSkinName(string2);
            ((LaFChangeListener)objectArray[i + 1]).lafChangedUI(this.lafChangeEvent);
        }
    }
}

