/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.laf;

import de.admadic.laf.LaFSkin;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LaF {
    static final boolean LOG = true;
    private static final Logger logger = Logger.getLogger("de.admadic");
    private String name;
    private String className;
    private boolean doesDecoration;
    private ClassLoader classLoader;
    private String themepackPath;
    private int type;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_PRIMARY = 1;
    public static final int TYPE_SYSTEM = 2;
    public static final int TYPE_EXTRA = 3;

    protected Logger getLogger() {
        return logger;
    }

    public LaF(String string, String string2, boolean bl) {
        this(string, string2, bl, 0);
    }

    public LaF(String string, String string2, boolean bl, int n) {
        this.name = string;
        this.className = string2;
        this.doesDecoration = bl;
        this.type = n;
        this.themepackPath = "";
        if (logger != null) {
            logger.fine("created with name=" + string + ", className=" + string2);
        }
    }

    public boolean preSelect() {
        if (logger != null) {
            logger.fine("preselect (name=" + this.name + ", className=" + this.className + ")");
        }
        return true;
    }

    public boolean select() {
        if (logger != null) {
            logger.fine("preselect (name=" + this.name + ", className=" + this.className + ")");
        }
        boolean bl = true;
        try {
            if (this.classLoader != null) {
                if (logger != null) {
                    logger.fine("using custom classloader");
                }
                UIManager.put("ClassLoader", this.classLoader);
                Class<?> clazz = this.classLoader.loadClass(this.className);
                Object obj = clazz.newInstance();
                UIManager.setLookAndFeel((LookAndFeel)obj);
            } else {
                if (logger != null) {
                    logger.fine("using system classloader");
                }
                UIManager.setLookAndFeel(this.className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (logger != null) {
                logger.severe("Error selecting LaF: " + classNotFoundException.getMessage());
            }
            return false;
        }
        catch (InstantiationException instantiationException) {
            if (logger != null) {
                logger.severe("Error selecting LaF: " + instantiationException.getMessage());
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            if (logger != null) {
                logger.severe("Error selecting LaF: " + illegalAccessException.getMessage());
            }
            return false;
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            if (logger != null) {
                logger.severe("Error selecting LaF: " + unsupportedLookAndFeelException.getMessage());
            }
            return false;
        }
        return bl;
    }

    public boolean postSelect() {
        block4: {
            try {
                boolean bl = UIManager.getLookAndFeel().getSupportsWindowDecorations();
                if (bl) {
                    Method method = JFrame.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                    method.invoke(null, Boolean.TRUE);
                    method = JDialog.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                    method.invoke(null, Boolean.TRUE);
                } else {
                    Method method = JFrame.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                    method.invoke(null, Boolean.FALSE);
                    method = JDialog.class.getMethod("setDefaultLookAndFeelDecorated", Boolean.TYPE);
                    method.invoke(null, Boolean.FALSE);
                }
            }
            catch (Exception exception) {
                if (logger == null) break block4;
                logger.severe("Error setting up LaF decorations: " + exception.getMessage());
            }
        }
        return true;
    }

    public boolean selectSkin(LaFSkin laFSkin) {
        if (laFSkin == null) {
            // empty if block
        }
        return true;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isDoesDecoration() {
        return this.doesDecoration;
    }

    public String getName() {
        return this.name;
    }

    public String getThemepackPath() {
        return this.themepackPath;
    }

    public void setThemepackPath(String string) {
        this.themepackPath = string;
        if (this.themepackPath == null) {
            this.themepackPath = "";
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }
}

