/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.cfg;

import de.admadic.cfg.CfgException;
import de.admadic.cfg.CfgItem;
import de.admadic.cfg.CfgPersistenceGrouped;
import de.admadic.cfg.CfgPersistenceItemized;
import de.admadic.cfg.CfgProvider;
import de.admadic.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Logger;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParserFactory;
import net.n3.nanoxml.XMLWriter;

public class CfgPersistenceXML
implements CfgPersistenceItemized,
CfgPersistenceGrouped {
    static final boolean LOG = true;
    Logger logger = Logger.getLogger("de.admadic");
    CfgProvider cfgProvider;
    String fileName;
    IXMLElement xmlTreeCache;

    public CfgPersistenceXML() {
        this(null, null);
    }

    public CfgPersistenceXML(CfgProvider cfgProvider) {
        this(cfgProvider, null);
    }

    public CfgPersistenceXML(CfgProvider cfgProvider, String string) {
        this.cfgProvider = cfgProvider;
        this.fileName = string;
    }

    @Override
    public void registerCfgProvider(CfgProvider cfgProvider) {
        this.cfgProvider = cfgProvider;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    protected void putToCfgProvider(String string) throws CfgException {
        IXMLElement iXMLElement = this.getNodeMap(this.xmlTreeCache, string);
        Vector vector = iXMLElement.getChildrenNamed("entry");
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            String string2 = iXMLElement2.getAttribute("key", null);
            String string3 = iXMLElement2.getAttribute("value", null);
            String string4 = iXMLElement2.getAttribute("meta", null);
            if (string2 == null || string3 == null || string4 == null) {
                throw new Error("CfgPersistenceXML: Invalid config format. entry: key, value or meta is null");
            }
            CfgItem cfgItem = new CfgItem();
            cfgItem.decodeKey(string2);
            cfgItem.decodeMeta(string4);
            cfgItem.decodeValue(string3);
            this.cfgProvider.putCfgItem(cfgItem.getCiKey(), cfgItem);
        }
    }

    protected void getFromCfgProvider(String string) {
        IXMLElement iXMLElement = this.getNodeMap(this.xmlTreeCache, string);
        if (iXMLElement == null) {
            throw new Error("CfgPersistenceXML: map (for node name = " + string + ") not there.");
        }
        Enumeration<String> enumeration = this.cfgProvider.getCfgItemKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            try {
                if (string2 == null) continue;
                CfgItem cfgItem = this.cfgProvider.getCfgItem(string2);
                String string3 = cfgItem.encodeKey();
                String string4 = cfgItem.encodeValue();
                String string5 = cfgItem.encodeMeta();
                IXMLElement iXMLElement2 = this.getEntry(iXMLElement, string3);
                if (iXMLElement2 == null) {
                    iXMLElement2 = iXMLElement.createElement("entry");
                    iXMLElement.addChild(iXMLElement2);
                }
                iXMLElement2.setAttribute("key", string3);
                iXMLElement2.setAttribute("value", string4);
                iXMLElement2.setAttribute("meta", string5);
            }
            catch (CfgException cfgException) {
                System.err.println("Cfg: error creating encoding. " + cfgException);
            }
        }
    }

    protected void mergeIntoTreeCache(IXMLElement iXMLElement, String string) {
        IXMLElement iXMLElement2 = this.getNodeMap(this.xmlTreeCache, string);
        IXMLElement iXMLElement3 = this.getNodeMap(iXMLElement, string);
        Vector vector = iXMLElement3.getChildrenNamed("entry");
        for (Object e : vector) {
            IXMLElement iXMLElement4 = (IXMLElement)e;
            String string2 = iXMLElement4.getAttribute("key", null);
            if (string2 == null) continue;
            IXMLElement iXMLElement5 = this.getEntry(iXMLElement2, string2);
            if (iXMLElement5 == null) {
                iXMLElement5 = iXMLElement2.createElement("entry");
                iXMLElement2.addChild(iXMLElement5);
            }
            String string3 = iXMLElement4.getAttribute("value", null);
            String string4 = iXMLElement4.getAttribute("meta", null);
            if (string3 == null || string4 == null) {
                throw new Error("CfgPersistenceXML: missing value or meta info in loaded data");
            }
            iXMLElement5.setAttribute("key", string2);
            iXMLElement5.setAttribute("value", string3);
            iXMLElement5.setAttribute("meta", string4);
        }
    }

    @Override
    public void load(String string) {
        block14: {
            try {
                String string2 = FileUtil.fixFileName1(this.fileName);
                if (this.xmlTreeCache == null) {
                    this.createTree(string);
                }
                IXMLParser iXMLParser = XMLParserFactory.createDefaultXMLParser();
                IXMLReader iXMLReader = StdXMLReader.fileReader(string2);
                iXMLParser.setReader(iXMLReader);
                IXMLElement iXMLElement = (IXMLElement)iXMLParser.parse();
                this.mergeIntoTreeCache(iXMLElement, string);
                this.putToCfgProvider(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.logger != null) {
                    this.logger.severe("Error loading config: " + classNotFoundException.getMessage());
                }
            }
            catch (InstantiationException instantiationException) {
                if (this.logger != null) {
                    this.logger.severe("Error loading config: " + instantiationException.getMessage());
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (this.logger != null) {
                    this.logger.severe("Error loading config: " + illegalAccessException.getMessage());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.createTree(string);
            }
            catch (IOException iOException) {
                if (this.logger != null) {
                    this.logger.severe("IO error loading config: " + iOException.getMessage());
                }
            }
            catch (XMLException xMLException) {
                if (this.logger != null) {
                    this.logger.severe("XML error loading config: " + xMLException.getMessage());
                }
            }
            catch (CfgException cfgException) {
                if (this.logger == null) break block14;
                this.logger.severe("Cfg error loading config: " + cfgException.getMessage());
            }
        }
    }

    @Override
    public void store(String string) {
        this.initTree(string);
        this.getFromCfgProvider(string);
        this.doStore();
    }

    @Override
    public void removeKeys(String string, Enumeration<String> enumeration) {
        this.initTree(string);
        IXMLElement iXMLElement = this.getNodeMap(this.xmlTreeCache, string);
        if (iXMLElement == null) {
            throw new Error("CfgPersistenceXML: map (for node name = " + string + ") not there.");
        }
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            IXMLElement iXMLElement2 = this.getEntry(iXMLElement, string2);
            if (iXMLElement2 == null) continue;
            iXMLElement.removeChild(iXMLElement2);
        }
        this.doStore();
    }

    protected void doStore() {
        block5: {
            try {
                String string;
                try {
                    string = System.getProperty("line.separator");
                }
                catch (Exception exception) {
                    string = null;
                }
                if (string == null) {
                    string = "\n";
                }
                FileWriter fileWriter = new FileWriter(new File(this.fileName));
                ((Writer)fileWriter).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string);
                IXMLElement iXMLElement = this.xmlTreeCache;
                XMLWriter xMLWriter = new XMLWriter(fileWriter);
                xMLWriter.write(iXMLElement, true);
            }
            catch (IOException iOException) {
                if (this.logger == null) break block5;
                this.logger.severe("IO error storing config: " + iOException.getMessage());
            }
        }
    }

    @Override
    public boolean clear(String string) {
        this.initTree(string);
        IXMLElement iXMLElement = this.getNodeMap(this.xmlTreeCache, string);
        if (iXMLElement == null) {
            throw new Error("CfgPersistenceXML: map (for node name = " + string + ") not there.");
        }
        Enumeration enumeration = iXMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            IXMLElement iXMLElement2 = (IXMLElement)enumeration.nextElement();
            iXMLElement.removeChild(iXMLElement2);
        }
        this.doStore();
        return true;
    }

    @Override
    public void prepareLoad(String string) {
    }

    @Override
    public void prepareStore(String string) {
    }

    @Override
    public String[] getKeys() {
        return null;
    }

    @Override
    public CfgItem loadCfgItem(String string) {
        return null;
    }

    @Override
    public void storeCfgItem(CfgItem cfgItem) {
    }

    @Override
    public void finalizeLoad() {
    }

    @Override
    public void finalizeStore() {
    }

    protected IXMLElement getNodeMap(IXMLElement iXMLElement, String string) {
        String string2;
        IXMLElement iXMLElement2;
        Vector vector = iXMLElement.getChildrenNamed("root");
        IXMLElement iXMLElement3 = null;
        for (Object e : vector) {
            iXMLElement2 = (IXMLElement)e;
            string2 = iXMLElement2.getAttribute("type", null);
            if (string2 == null || !string2.equals("user")) continue;
            iXMLElement3 = iXMLElement2;
            break;
        }
        if (iXMLElement3 == null) {
            throw new Error("CfgPersistenceXML: Invalid config format. root with type=user missing.");
        }
        vector = iXMLElement3.getChildrenNamed("node");
        IXMLElement iXMLElement4 = null;
        for (Object e : vector) {
            iXMLElement2 = (IXMLElement)e;
            string2 = iXMLElement2.getAttribute("name", null);
            if (string2 == null || !string2.equals(string)) continue;
            iXMLElement4 = iXMLElement2;
            break;
        }
        if (iXMLElement4 == null) {
            throw new Error("CfgPersistenceXML: Invalid config format. root.node (name=" + string + ") missing.");
        }
        IXMLElement iXMLElement5 = iXMLElement4.getFirstChildNamed("map");
        return iXMLElement5;
    }

    protected IXMLElement getEntry(IXMLElement iXMLElement, String string) {
        Vector vector = iXMLElement.getChildrenNamed("entry");
        for (Object e : vector) {
            IXMLElement iXMLElement2 = (IXMLElement)e;
            String string2 = iXMLElement2.getAttribute("key", null);
            if (!string2.equals(string)) continue;
            return iXMLElement2;
        }
        return null;
    }

    protected void initTree(String string) {
        if (this.xmlTreeCache == null) {
            this.load(string);
        }
        if (this.xmlTreeCache == null) {
            this.createTree(string);
        }
    }

    protected void createTree(String string) {
        XMLElement xMLElement = new XMLElement("preferences");
        IXMLElement iXMLElement = xMLElement.createElement("root");
        xMLElement.addChild(iXMLElement);
        iXMLElement.setAttribute("type", "user");
        IXMLElement iXMLElement2 = iXMLElement.createElement("map");
        iXMLElement.addChild(iXMLElement2);
        IXMLElement iXMLElement3 = iXMLElement.createElement("node");
        iXMLElement.addChild(iXMLElement3);
        iXMLElement3.setAttribute("name", string);
        IXMLElement iXMLElement4 = iXMLElement3.createElement("map");
        iXMLElement3.addChild(iXMLElement4);
        this.xmlTreeCache = xMLElement;
    }
}

