/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.cfg;

import de.admadic.cfg.CfgException;
import de.admadic.cfg.CfgItem;
import de.admadic.cfg.CfgObjectSpecification;
import de.admadic.cfg.CfgPersistenceGrouped;
import de.admadic.cfg.CfgProvider;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;

public class Cfg
implements CfgProvider {
    private static boolean DBGforce = false;
    protected Hashtable<String, CfgItem> entries;
    protected ArrayList<CfgObjectSpecification> objectSpecifications;
    protected Hashtable<String, CfgObjectSpecification> name2ObjSpc;
    protected Hashtable<Object, CfgObjectSpecification> obj2ObjSpc;
    protected ArrayList<String> removeQueue;
    Cfg defaultCfg;
    boolean _isDefault = false;
    protected CfgPersistenceGrouped persGroupedBackend;

    public Cfg() {
        this.persGroupedBackend = null;
        this.defaultCfg = new Cfg(true);
        this.initCollections();
    }

    private Cfg(boolean bl) {
        this._isDefault = bl;
        this.initCollections();
    }

    protected void initCollections() {
        this.entries = new Hashtable();
        this.objectSpecifications = new ArrayList();
        this.name2ObjSpc = new Hashtable();
        this.obj2ObjSpc = new Hashtable();
        this.removeQueue = new ArrayList();
    }

    public void registerPersistanceBackend(CfgPersistenceGrouped cfgPersistenceGrouped) {
        this.persGroupedBackend = cfgPersistenceGrouped;
    }

    public void setDefaults() {
        this.clearAllSettings(false);
        this.copyAllSettingsFromDefault(false);
    }

    public void registerObject(String string, String string2, String[] stringArray, Object object) {
        CfgObjectSpecification cfgObjectSpecification = new CfgObjectSpecification(string, string2, stringArray, object);
        this.objectSpecifications.add(cfgObjectSpecification);
        this.name2ObjSpc.put(string + "." + string2, cfgObjectSpecification);
        this.obj2ObjSpc.put(object, cfgObjectSpecification);
    }

    public void unregisterObject(Object object) {
        CfgObjectSpecification cfgObjectSpecification = this.obj2ObjSpc.get(object);
        this.name2ObjSpc.remove(cfgObjectSpecification.path + "." + cfgObjectSpecification.name);
        this.obj2ObjSpc.remove(object);
        this.objectSpecifications.remove(cfgObjectSpecification);
    }

    public void putValue(String string, Object object) {
        CfgItem cfgItem = this.getCfgItem(string);
        if (cfgItem != null) {
            try {
                cfgItem.putObjectValue(object, false);
            }
            catch (CfgException cfgException) {
                System.err.println("Cfg: warning: could not store CfgItem: " + cfgException);
            }
        } else {
            cfgItem = CfgItem.create(string, object);
            this.putCfgItem(string, cfgItem);
        }
    }

    public Object getValue(String string, Object object) {
        CfgItem cfgItem = this.getCfgItem(string);
        if (cfgItem == null) {
            return object;
        }
        Object object2 = cfgItem.getObjectValue(object);
        return object2;
    }

    public void removeValue(String string) {
        this.removeCfgItem(string);
    }

    public String getStringValue(String string, String string2) {
        CfgItem cfgItem = this.getCfgItem(string);
        if (cfgItem == null) {
            return string2;
        }
        return cfgItem.getStringValue(string2);
    }

    public boolean getBooleanValue(String string, boolean bl) {
        CfgItem cfgItem = this.getCfgItem(string);
        if (cfgItem == null) {
            return bl;
        }
        return cfgItem.getBooleanValue(bl);
    }

    public int getIntValue(String string, int n) {
        CfgItem cfgItem = this.getCfgItem(string);
        if (cfgItem == null) {
            return n;
        }
        return cfgItem.getIntValue(n);
    }

    public Rectangle getRectangleValue(String string, Rectangle rectangle) {
        CfgItem cfgItem = this.getCfgItem(string);
        if (cfgItem == null) {
            return rectangle;
        }
        return cfgItem.getRectangleValue(rectangle);
    }

    public Point getPointValue(String string, Point point) {
        CfgItem cfgItem = this.getCfgItem(string);
        if (cfgItem == null) {
            return point;
        }
        return cfgItem.getPointValue(point);
    }

    public void putStringValue(String string, String string2) {
        this.putValue(string, string2);
    }

    public void putBooleanValue(String string, boolean bl) {
        this.putValue(string, new Boolean(bl));
    }

    public void putIntValue(String string, int n) {
        this.putValue(string, new Integer(n));
    }

    public void putRectangleValue(String string, Rectangle rectangle) {
        this.putValue(string, rectangle);
    }

    public void putPointValue(String string, Point point) {
        this.putValue(string, point);
    }

    public Object[] getValueArray(String string) {
        Object object;
        int n = 0;
        int n2 = 0;
        Object[] objectArray = new Object[n2];
        while ((object = this.getValue(string + n, null)) != null) {
            if (n >= n2) {
                int n3 = n2 * 2 + 1;
                Object[] objectArray2 = new Object[n3];
                System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                objectArray = objectArray2;
                n2 = n3;
            }
            objectArray[n] = object;
            ++n;
        }
        Object[] objectArray3 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        return objectArray3;
    }

    public void removeValueArray(String string) {
        int n = 0;
        while (this.hasValueImpl(string + n)) {
            this.removeCfgItem(string + n);
            ++n;
        }
    }

    public void putValueArray(String string, Object[] objectArray) {
        this.removeValueArray(string);
        for (int i = 0; i < objectArray.length; ++i) {
            this.putValue(string + i, objectArray[i]);
        }
    }

    public void loadObjectFromPreferences(Object object) {
        CfgObjectSpecification cfgObjectSpecification = this.obj2ObjSpc.get(object);
        if (cfgObjectSpecification == null) {
            return;
        }
        if (cfgObjectSpecification.isClass) {
            return;
        }
        cfgObjectSpecification.loadSettings(this);
    }

    public void storeObjectToPreferences(Object object) {
        CfgObjectSpecification cfgObjectSpecification = this.obj2ObjSpc.get(object);
        if (cfgObjectSpecification == null) {
            return;
        }
        if (cfgObjectSpecification.isClass) {
            return;
        }
        cfgObjectSpecification.storeSettings(this);
    }

    public void loadObjectsFromPreferences() {
        if (DBGforce) {
            System.err.println("Cfg: loadObjectsFromPreferences:");
        }
        for (CfgObjectSpecification cfgObjectSpecification : this.objectSpecifications) {
            if (cfgObjectSpecification == null || cfgObjectSpecification.isClass) continue;
            cfgObjectSpecification.loadSettings(this);
        }
    }

    public void storeObjectsToPreferences() {
        if (DBGforce) {
            System.err.println("Cfg: storeObjectsToPreferences:");
        }
        for (CfgObjectSpecification cfgObjectSpecification : this.objectSpecifications) {
            if (cfgObjectSpecification == null || cfgObjectSpecification.isClass) continue;
            cfgObjectSpecification.storeSettings(this);
        }
    }

    public void loadPreferences(String string) {
        if (this.removeQueue.size() > 0) {
            this.persGroupedBackend.removeKeys(string, Collections.enumeration(this.removeQueue));
            this.clearRemoveQueue();
        }
        this.persGroupedBackend.load(string);
    }

    public void storePreferences(String string) {
        if (this.removeQueue.size() > 0) {
            this.persGroupedBackend.removeKeys(string, Collections.enumeration(this.removeQueue));
            this.clearRemoveQueue();
        }
        this.persGroupedBackend.store(string);
    }

    public boolean clearPreferences(String string) {
        return this.persGroupedBackend.clear(string);
    }

    @Override
    public void removeCfgItem(String string) {
        if (DBGforce) {
            System.err.println("Cfg: removeCfgItem: name=" + string);
        }
        this.entries.remove(string);
        this.addToRemoveQueue(string);
    }

    @Override
    public CfgItem getCfgItem(String string) {
        if (!this.entries.containsKey(string)) {
            if (DBGforce) {
                System.err.println("Cfg: getCfgItem: name=" + string + " not found - returning null");
            }
            return null;
        }
        return this.entries.get(string);
    }

    @Override
    public void putCfgItem(String string, CfgItem cfgItem) {
        if (DBGforce) {
            System.err.println("Cfg: putCfgItem: name=" + string);
        }
        if (!string.equals(cfgItem.getCiKey())) {
            System.err.println("Cfg: CfgItem is accessed by a different name: " + string + " instead of " + cfgItem.getCiKey());
        }
        this.entries.put(string, cfgItem);
    }

    @Override
    public Enumeration<String> getCfgItemKeys() {
        return this.entries.keys();
    }

    protected Cfg getDefaultCfg() {
        return this.defaultCfg;
    }

    protected void clearAllSettings(boolean bl) {
        Object[] objectArray;
        for (Object object : objectArray = this.entries.keySet().toArray()) {
            if (object == null) continue;
            String string = (String)object;
            CfgItem cfgItem = this.getCfgItem(string);
            if (!bl && (cfgItem.getCiFlags() & 1) != 0) continue;
            if (DBGforce) {
                System.err.println("remove key: " + string);
            }
            this.removeCfgItem(string);
        }
    }

    protected void copyAllSettingsFromDefault(boolean bl) {
        Set<String> set = this.getDefaultCfg().entries.keySet();
        for (String string : set) {
            if (string == null) continue;
            CfgItem cfgItem = this.getDefaultCfg().getCfgItem(string);
            CfgItem cfgItem2 = this.getCfgItem(string);
            if (cfgItem2 != null && !bl) continue;
            if (DBGforce) {
                System.err.println("copying key: " + string);
            }
            this.putCfgItem(string, cfgItem);
        }
    }

    protected int findIndexOfValue(String string, String string2) {
        int n = 0;
        String string3;
        while (this.entries.containsKey(string3 = string + n)) {
            String string4;
            try {
                string4 = this.entries.get(string3).encodeValue();
            }
            catch (Exception exception) {
                continue;
            }
            if (string4.equals(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected boolean hasValueImpl(String string) {
        return this.entries.containsKey(string);
    }

    protected void addToRemoveQueue(String string) {
        if (!this.removeQueue.contains(string)) {
            this.removeQueue.add(string);
            if (DBGforce) {
                System.err.println("added " + string + " to remove queue");
            }
        }
    }

    protected void clearRemoveQueue() {
        this.removeQueue.clear();
    }

    protected void putEncodedCfgItem(String string, String string2) {
        CfgItem cfgItem = CfgItem.createFromEncoded(string, string2);
        this.putCfgItem(cfgItem.getCiKey(), cfgItem);
    }
}

