/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui.settings;

import de.admadic.calculator.appmod.ModuleZipReader;
import de.admadic.calculator.appmod.ModuleZipReaderException;
import de.admadic.util.FileUtil;
import de.admadic.util.PathManager;
import de.admadic.util.VersionName;
import de.admadic.util.VersionUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SettingsUtils {
    static final boolean LOG = true;
    static final Logger logger = Logger.getLogger("de.admadic");
    public static final int RCINS_NOINSTALL = 0;
    public static final int RCINS_NORESTART = 1;
    public static final int RCINS_RESTART = 2;

    protected SettingsUtils() {
    }

    public static File getJarFile(Component component) {
        class JarFilter
        extends FileFilter {
            JarFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                if (string != null) {
                    boolean bl = string.equals("jar");
                    return bl;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Jar Files (*.jar)";
            }
        }
        return SettingsUtils.getFile(component, new JarFilter());
    }

    public static File getZipFile(Component component) {
        class ZipFilter
        extends FileFilter {
            ZipFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                if (string != null) {
                    boolean bl = string.equals("zip");
                    return bl;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Zip Files (*.zip)";
            }
        }
        return SettingsUtils.getFile(component, new ZipFilter());
    }

    public static File getModFile(Component component) {
        class ModFilter
        extends FileFilter {
            ModFilter() {
            }

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                if (string != null) {
                    boolean bl = false;
                    if (string.equals("zip")) {
                        return true;
                    }
                    if (string.equals("jar")) {
                        return true;
                    }
                    return bl;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Module Files (*.zip;*.jar)";
            }
        }
        return SettingsUtils.getFile(component, new ModFilter());
    }

    public static File getFile(Component component, FileFilter fileFilter) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.setFileHidingEnabled(false);
        int n = jFileChooser.showOpenDialog(component);
        switch (n) {
            case 0: {
                file = jFileChooser.getSelectedFile();
                return file;
            }
            case 1: {
                break;
            }
        }
        return null;
    }

    public static int installFile(Component component, PathManager pathManager, File file, int n) {
        if (pathManager == null) {
            if (logger != null) {
                logger.severe("pathManager is not available.");
            }
            if (logger != null) {
                logger.warning("could not install file " + file.getPath());
            }
            JOptionPane.showMessageDialog(component, "Could not detect directory structure of the calculator.\nPlease install the file by yourself:\nFilename = " + file.getPath());
            return 0;
        }
        String string = pathManager.getPathString(n);
        if (string == null) {
            if (logger != null) {
                logger.severe("could not retrieve path for id " + n);
            }
            if (logger != null) {
                logger.warning("could not install file " + file.getPath());
            }
            JOptionPane.showMessageDialog(component, "Could not detect the destination directory for the file.\nPlease install the file by yourself:\nFilename = " + file.getPath());
            return 0;
        }
        File file2 = new File(string);
        try {
            if (file.getCanonicalPath().startsWith(file2.getCanonicalPath())) {
                if (logger != null) {
                    logger.config("install: src and dst are the same, no need to install " + file.getPath());
                }
                return 1;
            }
        }
        catch (IOException iOException) {
            if (logger != null) {
                logger.warning("access error: file=" + file.getPath() + " destdir=" + string);
            }
            JOptionPane.showMessageDialog(component, "Could not access the file or the destination directory.\nPlease install the file by yourself:\nFilename = " + file.getPath() + "\ndestination-dir = " + string);
            return 2;
        }
        if (!SettingsUtils.checkNewerVersion(component, file.getName(), string)) {
            return 1;
        }
        if ((file2 = new File(file2, file.getName())).exists()) {
            int n2;
            long l = file2.lastModified();
            long l2 = file.lastModified();
            if (logger != null) {
                logger.config("install: file exists already:  file=" + file.getPath() + " destfile=" + file2.getPath());
            }
            if ((n2 = JOptionPane.showConfirmDialog(component, "The file already exists in the destination directory.Do you want to copy this file\nFile = " + file.getPath() + "\nTime = " + new Date(l2).toString() + "\nover this file\nFile = " + file2.getPath() + "\nTime = " + new Date(l).toString() + "\n?", "Confirm overwrite", 2)) != 0) {
                if (logger != null) {
                    logger.config("install: file exists already: user cancelled overwrite.");
                }
                return 1;
            }
            if (logger != null) {
                logger.config("install: file exists already: user confirmed overwrite.");
            }
        }
        if (!FileUtil.copyFile(file.getPath(), file2.getPath())) {
            JOptionPane.showMessageDialog(component, "Could not copy the file to the destination directory.\nPlease install the file by yourself:\nFilename = " + file.getPath() + "\nDestination Directory = " + string);
            return 1;
        }
        return 2;
    }

    private static boolean checkNewerVersion(Component component, String string, String string2) {
        Object object;
        VersionName versionName = VersionUtil.getVersionNameFromFileName(string);
        if (versionName == null) {
            return true;
        }
        Vector<VersionName> vector = new Vector<VersionName>();
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return true;
        }
        for (File object2 : fileArray) {
            object = VersionUtil.getVersionNameFromFileName(object2.getName());
            if (object == null || !((VersionName)object).getPrefix().equals(versionName.getPrefix()) || !((VersionName)object).getSuffix().equals(versionName.getSuffix())) continue;
            vector.add((VersionName)object);
        }
        if (vector.size() < 1) {
            return true;
        }
        boolean bl = false;
        Object object3 = null;
        for (VersionName versionName2 : vector) {
            if (versionName2.getVersionRecord().compareTo(versionName.getVersionRecord()) <= 0) continue;
            bl = true;
            object = versionName2.getCombinedName();
            if (object3 == null) {
                object3 = object;
                continue;
            }
            object3 = (String)object3 + "\n" + (String)object;
        }
        if (bl) {
            int n = JOptionPane.showConfirmDialog(component, "Newer versions of the file already exist in the destination directory.\nDo wish to install the file anyway?\nFile = " + string + "\nNewer Versions:\n" + object3, "Confirm installation", 2);
            return n == 0;
        }
        return true;
    }

    public static boolean installFile(Component component, PathManager pathManager, String string, InputStream inputStream, int n) {
        if (pathManager == null) {
            if (logger != null) {
                logger.severe("pathManager is not available.");
            }
            if (logger != null) {
                logger.warning("could not install file (from stream) " + string);
            }
            JOptionPane.showMessageDialog(component, "Could not detect directory structure of the calculator.\nPlease install the file by yourself:\nFilename = " + string);
            return false;
        }
        String string2 = pathManager.getPathString(n);
        if (string2 == null) {
            if (logger != null) {
                logger.severe("could not retrieve path for id " + n);
            }
            if (logger != null) {
                logger.warning("could not install file (from stream) " + string);
            }
            JOptionPane.showMessageDialog(component, "Could not detect the destination directory for the file.\nPlease install the file by yourself:\nFilename = " + string);
            return false;
        }
        File file = new File(string2);
        if (!SettingsUtils.checkNewerVersion(component, string, string2)) {
            return false;
        }
        if (!FileUtil.copyFile(inputStream, (file = new File(file, string)).getPath())) {
            JOptionPane.showMessageDialog(component, "Could not copy the file to the destination directory.\nPlease install the file by yourself:\nFilename = " + string + "\nDestination Directory = " + string2);
            return false;
        }
        return true;
    }

    public static int installModFile(Component component, PathManager pathManager, File file) {
        if (pathManager == null) {
            JOptionPane.showMessageDialog(component, "Could not detect the system module-directory of the \ncalculator. Please contact customer support.\nFilename = " + file.getPath());
            return 0;
        }
        String string = file.getName();
        string.toLowerCase();
        if (string.endsWith(".jar")) {
            return SettingsUtils.installModFileImplJar(component, pathManager, file);
        }
        if (string.endsWith(".zip")) {
            return SettingsUtils.installModFileImplZip(component, pathManager, file);
        }
        JOptionPane.showMessageDialog(component, "This file type is not supported. Only zip and jar are allowed.\nFilename = " + file.getPath());
        return 0;
    }

    public static int installModFileImplZip(Component component, PathManager pathManager, File file) {
        InputStream inputStream;
        ModuleZipReader moduleZipReader = new ModuleZipReader(file.toString());
        try {
            moduleZipReader.open();
            moduleZipReader.buildEntryList();
        }
        catch (ModuleZipReaderException moduleZipReaderException) {
            if (logger != null) {
                logger.severe("error accessing zip file " + file.getPath() + " error=" + moduleZipReaderException.getMessage());
            }
            JOptionPane.showMessageDialog(component, "Could not access the ZIP file.\nFilename = " + file.getPath());
            return 0;
        }
        try {
            if (!moduleZipReader.hasInstallCfg()) {
                if (logger != null) {
                    logger.severe("no install.cfg found in file " + file.getPath());
                }
                JOptionPane.showMessageDialog(component, "The ZIP file is not a valid module archive.\nFilename = " + file.getPath());
                return 0;
            }
            moduleZipReader.readInstallCfg();
            moduleZipReader.parseInstallCfg();
        }
        catch (ModuleZipReaderException moduleZipReaderException) {
            if (logger != null) {
                logger.severe("error reading zip file " + file.getPath() + " error=" + moduleZipReaderException.getMessage());
            }
            JOptionPane.showMessageDialog(component, "Error reading data from the ZIP file.\nIt is not a valid or supported module archive.\nFilename = " + file.getPath() + "\nError = " + moduleZipReaderException.getMessage());
            return 0;
        }
        Vector<String> vector = moduleZipReader.getEntries("lic");
        if (vector != null) {
            for (String string : vector) {
                inputStream = moduleZipReader.getStream(string);
                if (inputStream == null) {
                    if (logger != null) {
                        logger.severe("error getting stream from zip file " + file.getPath() + " for entry " + string);
                    }
                    JOptionPane.showMessageDialog(component, "Error reading data from the ZIP file.\nFilename = " + file.getPath());
                    return 0;
                }
                SettingsUtils.installFile(component, pathManager, string, inputStream, 20);
            }
        }
        if ((vector = moduleZipReader.getEntries("lib")) != null) {
            for (String string : vector) {
                inputStream = moduleZipReader.getStream(string);
                if (inputStream == null) {
                    if (logger != null) {
                        logger.severe("error getting stream from zip file " + file.getPath() + " for entry " + string);
                    }
                    JOptionPane.showMessageDialog(component, "Error reading data from the ZIP file.\nFilename = " + file.getPath());
                    return 0;
                }
                SettingsUtils.installFile(component, pathManager, string, inputStream, 6);
            }
        }
        if ((vector = moduleZipReader.getEntries("mod")) != null) {
            for (String string : vector) {
                inputStream = moduleZipReader.getStream(string);
                if (inputStream == null) {
                    if (logger != null) {
                        logger.severe("error getting stream from zip file " + file.getPath() + " for entry " + string);
                    }
                    JOptionPane.showMessageDialog(component, "Error reading data from the ZIP file.\nFilename = " + file.getPath());
                    return 0;
                }
                SettingsUtils.installFile(component, pathManager, string, inputStream, 17);
            }
        }
        return 2;
    }

    public static int installModFileImplJar(Component component, PathManager pathManager, File file) {
        return SettingsUtils.installFile(component, pathManager, file, 17);
    }
}

