/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui.settings;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.types.CaDouble;
import de.admadic.calculator.types.CaDoubleFormat;
import de.admadic.calculator.ui.settings.AbstractSettingsPanel;
import de.admadic.cfg.Cfg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

public class SettingsPanelNumFmt
extends AbstractSettingsPanel {
    private static final long serialVersionUID = 1L;
    Cfg cfg;
    JComboBox cbNumFmtType;
    JSpinner spNumFmtWidth;
    JLabel lbNumFmtWidth;
    JSpinner spNumFmtPrec;
    JScrollPane spNumFmtSamples;
    JTable tblNumFmtSamples;
    JLabel lbNumFmtPrec;
    JLabel lbNumFmtType;
    SpinnerNumberModel spMdlNumFmtPrec;
    SpinnerNumberModel spMdlNumFmtWidth;
    JSlider sldNumFmtWidth;
    JSlider sldNumFmtPrec;
    boolean updateNumFmtPreviewBusy = false;
    CaDoubleFormat numFmt;
    Double[] tblNumFmtSamplesValues = new Double[]{1.0, 0.001, 1.2345678912345679E8, 1.23456E15};
    String[][] tblNumFmtSamplesData = new String[][]{{this.tblNumFmtSamplesValues[0].toString(), "<output>"}, {this.tblNumFmtSamplesValues[1].toString(), "<output>"}, {this.tblNumFmtSamplesValues[2].toString(), "<output>"}, {this.tblNumFmtSamplesValues[3].toString(), "<output>"}};
    String[] tblNumFmtSamplesColumns = new String[]{"Value", "Output"};
    DefaultTableModel tblMdlNumFmtSamples;

    public SettingsPanelNumFmt(Cfg cfg) {
        this.cfg = cfg;
    }

    @Override
    public void initContents() {
        SettingsPanelNumFmt settingsPanelNumFmt = this;
        this.numFmt = new CaDoubleFormat();
        FormLayout formLayout = new FormLayout("5px, d, 12px, 50dlu, 5px, 50dlu, 12px, 50dlu, 5px, 50dlu, 5px, d:grow, 5px", "5px, d, 5px, d, 1px, d, 5px, d, 5px, d, 5px");
        settingsPanelNumFmt.setLayout(formLayout);
        settingsPanelNumFmt.add((Component)DefaultComponentFactory.getInstance().createSeparator("Number Format:"), new CellConstraints("2, 2, 9, 1, default, default"));
        settingsPanelNumFmt.add((Component)DefaultComponentFactory.getInstance().createSeparator("Samples:"), new CellConstraints("2, 8, 9, 1, default, default"));
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{CaDoubleFormat.type2DisplayString(0), CaDoubleFormat.type2DisplayString(1), CaDoubleFormat.type2DisplayString(2)});
        this.cbNumFmtType = new JComboBox();
        settingsPanelNumFmt.add((Component)this.cbNumFmtType, new CellConstraints("2, 6, 1, 1, default, default"));
        this.cbNumFmtType.setModel(defaultComboBoxModel);
        this.lbNumFmtType = new JLabel();
        settingsPanelNumFmt.add((Component)this.lbNumFmtType, new CellConstraints("2, 4, 1, 1, default, default"));
        this.lbNumFmtType.setText("Type:");
        this.sldNumFmtWidth = new JSlider(0, 20, 0);
        this.sldNumFmtWidth.setPaintLabels(true);
        this.sldNumFmtWidth.setPaintTicks(true);
        this.sldNumFmtWidth.setSnapToTicks(true);
        this.sldNumFmtWidth.setMajorTickSpacing(5);
        this.sldNumFmtWidth.setMinorTickSpacing(1);
        settingsPanelNumFmt.add((Component)this.sldNumFmtWidth, new CellConstraints("4, 6, 3, 1, default, default"));
        this.spMdlNumFmtWidth = new SpinnerNumberModel(0, 0, 20, 1);
        this.spNumFmtWidth = new JSpinner();
        settingsPanelNumFmt.add((Component)this.spNumFmtWidth, new CellConstraints("6, 4, 1, 1, default, default"));
        this.spNumFmtWidth.setModel(this.spMdlNumFmtWidth);
        this.lbNumFmtWidth = new JLabel();
        settingsPanelNumFmt.add((Component)this.lbNumFmtWidth, new CellConstraints("4, 4, 1, 1, default, default"));
        this.lbNumFmtWidth.setText("Width:");
        this.sldNumFmtPrec = new JSlider(0, 20, 0);
        this.sldNumFmtPrec.setPaintLabels(true);
        this.sldNumFmtPrec.setPaintTicks(true);
        this.sldNumFmtPrec.setSnapToTicks(true);
        this.sldNumFmtPrec.setMajorTickSpacing(5);
        this.sldNumFmtPrec.setMinorTickSpacing(1);
        settingsPanelNumFmt.add((Component)this.sldNumFmtPrec, new CellConstraints("8, 6, 3, 1, default, default"));
        this.spMdlNumFmtPrec = new SpinnerNumberModel(0, 0, 20, 1);
        this.spNumFmtPrec = new JSpinner();
        settingsPanelNumFmt.add((Component)this.spNumFmtPrec, new CellConstraints("10, 4, 1, 1, default, default"));
        this.spNumFmtPrec.setModel(this.spMdlNumFmtPrec);
        this.lbNumFmtPrec = new JLabel();
        settingsPanelNumFmt.add((Component)this.lbNumFmtPrec, new CellConstraints("8, 4, 1, 1, default, default"));
        this.lbNumFmtPrec.setText("Precision:");
        this.spNumFmtSamples = new JScrollPane();
        settingsPanelNumFmt.add((Component)this.spNumFmtSamples, new CellConstraints("2, 10, 9, 1, default, default"));
        this.tblMdlNumFmtSamples = new DefaultTableModel();
        this.tblMdlNumFmtSamples.setDataVector(this.tblNumFmtSamplesData, this.tblNumFmtSamplesColumns);
        this.tblNumFmtSamples = new JTable();
        this.spNumFmtSamples.setViewportView(this.tblNumFmtSamples);
        this.tblNumFmtSamples.setModel(this.tblMdlNumFmtSamples);
        this.tblNumFmtSamples.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.tblNumFmtSamples.setFont(new Font("Monospaced", 0, 12));
        this.spMdlNumFmtPrec.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanelNumFmt.this.updateNumFmtPreview(SettingsPanelNumFmt.this.spMdlNumFmtPrec);
            }
        });
        this.spMdlNumFmtWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanelNumFmt.this.updateNumFmtPreview(SettingsPanelNumFmt.this.spMdlNumFmtWidth);
            }
        });
        this.cbNumFmtType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SettingsPanelNumFmt.this.updateNumFmtPreview(SettingsPanelNumFmt.this.cbNumFmtType);
            }
        });
        this.sldNumFmtWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanelNumFmt.this.updateNumFmtPreview(SettingsPanelNumFmt.this.sldNumFmtWidth);
            }
        });
        this.sldNumFmtPrec.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanelNumFmt.this.updateNumFmtPreview(SettingsPanelNumFmt.this.sldNumFmtPrec);
            }
        });
    }

    void updateNumFmtPreview(Object object) {
        int n;
        if (this.updateNumFmtPreviewBusy) {
            return;
        }
        this.updateNumFmtPreviewBusy = true;
        if (object == this.spMdlNumFmtWidth) {
            this.sldNumFmtWidth.setValue((Integer)this.spMdlNumFmtWidth.getValue());
        }
        if (object == this.spMdlNumFmtPrec) {
            this.sldNumFmtPrec.setValue((Integer)this.spMdlNumFmtPrec.getValue());
        }
        if (object == this.sldNumFmtWidth) {
            this.spMdlNumFmtWidth.setValue(this.sldNumFmtWidth.getValue());
        }
        if (object == this.sldNumFmtPrec) {
            this.spMdlNumFmtPrec.setValue(this.sldNumFmtPrec.getValue());
        }
        if ((n = this.cbNumFmtType.getSelectedIndex()) < 0) {
            return;
        }
        int n2 = 0;
        int n3 = (Integer)this.spMdlNumFmtWidth.getValue();
        int n4 = (Integer)this.spMdlNumFmtPrec.getValue();
        this.updateNumFmtPreviewBusy = false;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        for (int i = 0; i < this.tblNumFmtSamplesData.length; ++i) {
            this.tblNumFmtSamplesData[i][0] = this.tblNumFmtSamplesValues[i].toString();
            this.tblNumFmtSamplesData[i][1] = CaDoubleFormat.format(n2, n3, n4, new CaDouble(this.tblNumFmtSamplesValues[i]));
        }
        this.tblMdlNumFmtSamples.setDataVector(this.tblNumFmtSamplesData, this.tblNumFmtSamplesColumns);
    }

    @Override
    public void loadSettings() {
        this.updateNumFmtPreviewBusy = true;
        String string = this.cfg.getStringValue("ui.number.format", "fixed,12,2");
        CaDoubleFormat caDoubleFormat = CaDoubleFormat.valueOf(string);
        if (caDoubleFormat == null) {
            caDoubleFormat = new CaDoubleFormat();
        }
        if (caDoubleFormat.getType() == 0) {
            this.cbNumFmtType.setSelectedIndex(0);
        } else if (caDoubleFormat.getType() == 1) {
            this.cbNumFmtType.setSelectedIndex(1);
        } else if (caDoubleFormat.getType() == 2) {
            this.cbNumFmtType.setSelectedIndex(2);
        } else {
            this.cbNumFmtType.setSelectedIndex(0);
        }
        int n = caDoubleFormat.getWidth();
        int n2 = caDoubleFormat.getPrec();
        this.sldNumFmtWidth.setValue(n);
        this.sldNumFmtPrec.setValue(n2);
        this.spNumFmtWidth.setValue(n);
        this.spNumFmtPrec.setValue(n2);
        this.updateNumFmtPreviewBusy = false;
        this.numFmt = caDoubleFormat;
        this.updateNumFmtPreview(null);
    }

    @Override
    public void storeSettings() {
        int n = this.cbNumFmtType.getSelectedIndex();
        int n2 = this.sldNumFmtWidth.getValue();
        int n3 = this.sldNumFmtPrec.getValue();
        switch (n) {
            case 0: {
                this.numFmt.setType(0);
                break;
            }
            case 1: {
                this.numFmt.setType(1);
                break;
            }
            case 2: {
                this.numFmt.setType(2);
                break;
            }
            default: {
                this.numFmt.setType(0);
            }
        }
        this.numFmt.setWidth(n2);
        this.numFmt.setPrec(n3);
        this.cfg.putStringValue("ui.number.format", this.numFmt.toString());
    }
}

