/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui.settings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.appmod.ModuleSpec;
import de.admadic.calculator.appmod.ModuleUtil;
import de.admadic.calculator.ui.settings.AbstractSettingsPanel;
import de.admadic.calculator.ui.settings.SettingsUtils;
import de.admadic.cfg.Cfg;
import de.admadic.ui.util.ColumnAccessor;
import de.admadic.ui.util.ListRefTableModel;
import de.admadic.util.PathManager;
import de.admadic.util.VersionRecord;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class SettingsPanelModules
extends AbstractSettingsPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    Cfg cfg;
    PathManager pathMan;
    boolean needRestart = false;
    JTable tableModules;
    ListRefTableModel tableModelModules;
    JPanel panelButtons;
    JButton buttonAddModule;
    JButton buttonRemModule;
    JButton buttonUpModule;
    JButton buttonDownModule;
    ArrayList<ModuleSpec> modulesTableData;
    int[] modulesColumnWidths = new int[]{80, 40, 250};
    String[] modulesColNames = new String[]{"Name", "Enable", "Class Name"};
    protected final String CMD_MOD_ADD = "stgs.btn.mod.add";
    protected final String CMD_MOD_REM = "stgs.btn.mod.rem";
    protected final String CMD_MOD_UP = "stgs.btn.mod.up";
    protected final String CMD_MOD_DOWN = "stgs.btn.mod.down";

    public SettingsPanelModules(Cfg cfg, PathManager pathManager) {
        this.cfg = cfg;
        this.pathMan = pathManager;
        this.modulesTableData = new ArrayList();
    }

    @Override
    public void initContents() {
        SettingsPanelModules settingsPanelModules = this;
        FormLayout formLayout = new FormLayout("5px, d:grow, 5px, d, 5px", "5px, d:grow, 5px");
        CellConstraints cellConstraints = new CellConstraints();
        settingsPanelModules.setLayout(formLayout);
        this.tableModelModules = new ListRefTableModel();
        this.tableModelModules.setColumnAccessor(new ModuleSpecColumnAccessor());
        this.tableModelModules.setColumns(this.modulesColNames);
        this.tableModelModules.setData(this.modulesTableData);
        this.tableModules = new JTable();
        this.tableModules.setModel(this.tableModelModules);
        this.tableModules.setPreferredScrollableViewportSize(new Dimension(250, 150));
        JScrollPane jScrollPane = new JScrollPane(this.tableModules);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        settingsPanelModules.add((Component)jScrollPane, cellConstraints.xy(2, 2));
        this.tableModules.setAutoResizeMode(0);
        for (int i = 0; i < this.modulesColumnWidths.length; ++i) {
            this.tableModules.getColumnModel().getColumn(i).setPreferredWidth(this.modulesColumnWidths[i]);
        }
        this.tableModules.setSelectionMode(0);
        this.panelButtons = new JPanel();
        settingsPanelModules.add((Component)this.panelButtons, cellConstraints.xy(4, 2));
        FormLayout formLayout2 = new FormLayout("0px, d, 0px", "0px, d, 5px, d, 5px, d, 5px, d, 0px");
        this.panelButtons.setLayout(formLayout2);
        CellConstraints cellConstraints2 = new CellConstraints();
        this.buttonAddModule = new JButton("Add...");
        this.buttonAddModule.setActionCommand("stgs.btn.mod.add");
        this.buttonAddModule.addActionListener(this);
        this.buttonRemModule = new JButton("Remove...");
        this.buttonRemModule.setActionCommand("stgs.btn.mod.rem");
        this.buttonRemModule.addActionListener(this);
        this.buttonUpModule = new JButton("Up");
        this.buttonUpModule.setActionCommand("stgs.btn.mod.up");
        this.buttonUpModule.addActionListener(this);
        this.buttonDownModule = new JButton("Down");
        this.buttonDownModule.setActionCommand("stgs.btn.mod.down");
        this.buttonDownModule.addActionListener(this);
        this.panelButtons.add((Component)this.buttonAddModule, cellConstraints2.xy(2, 2));
        this.panelButtons.add((Component)this.buttonRemModule, cellConstraints2.xy(2, 4));
        this.panelButtons.add((Component)this.buttonUpModule, cellConstraints2.xy(2, 6));
        this.panelButtons.add((Component)this.buttonDownModule, cellConstraints2.xy(2, 8));
    }

    @Override
    public boolean isNeedRestart() {
        return this.needRestart;
    }

    @Override
    public void loadSettings() {
        Object[] objectArray = this.cfg.getValueArray("module.list.");
        this.modulesTableData.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray = ((String)objectArray[i]).split(":");
            boolean bl = Boolean.parseBoolean(stringArray[2]);
            ModuleSpec moduleSpec = new ModuleSpec(stringArray[0], stringArray[1], bl);
            this.modulesTableData.add(moduleSpec);
        }
    }

    @Override
    public void resetSettings() {
        this.modulesTableData.clear();
    }

    @Override
    public void storeSettings() {
        Object[] objectArray = new Object[this.modulesTableData.size()];
        for (int i = 0; i < this.modulesTableData.size(); ++i) {
            ModuleSpec moduleSpec = this.modulesTableData.get(i);
            objectArray[i] = moduleSpec.getName() + ":" + moduleSpec.getClassName() + ":" + Boolean.toString(moduleSpec.isEnabled());
        }
        this.cfg.putValueArray("module.list.", objectArray);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("stgs.btn.mod.add")) {
            this.doAddMod();
        } else if (string.equals("stgs.btn.mod.rem")) {
            this.doRemMod();
        } else if (string.equals("stgs.btn.mod.up")) {
            this.doUpMod();
        } else if (string.equals("stgs.btn.mod.down")) {
            this.doDownMod();
        }
    }

    void doAddMod() {
        int n;
        Object object;
        File file = SettingsUtils.getModFile(this);
        if (file == null) {
            return;
        }
        ModuleSpec moduleSpec = ModuleUtil.extractModuleSpec(file);
        if (moduleSpec == null) {
            JOptionPane.showMessageDialog(this, "A module specification could not be found in the selected file:\n" + file.toString(), "No module found in file", 0);
            return;
        }
        if (moduleSpec.getRequiredAppVersion() != null) {
            object = moduleSpec.getRequiredAppVersion();
            VersionRecord versionRecord = VersionRecord.valueOf("1.2.0-r199");
            if (object != null && versionRecord != null && ((VersionRecord)object).compareTo(versionRecord) > 0) {
                JOptionPane.showMessageDialog(this, "The module requires at least version " + ((VersionRecord)object).getMjMnMcRvVersionString() + " of the calculator.\nThe calculator which is currently running has the version " + versionRecord.getMjMnMcRvVersionString() + ".\nThe module cannot be installed.\nIf you think this is an error, please contact customer support.", "Invalid version", 0);
                return;
            }
        }
        object = "";
        if (this.existsModuleName(moduleSpec.getName())) {
            object = (String)object + "A module with that name already exists!\n";
        }
        if ((n = JOptionPane.showConfirmDialog(this, (String)object + "Do you wish to add the module named '" + moduleSpec.getName() + "'?", "Confirm adding module", 0)) != 0) {
            return;
        }
        int n2 = SettingsUtils.installModFile(this, this.pathMan, file);
        if (n2 == 0) {
            return;
        }
        if (n2 == 2) {
            this.needRestart = true;
        }
        this.modulesTableData.add(moduleSpec);
        this.tableModelModules.fireTableRowsInserted(this.modulesTableData.size() - 1, this.modulesTableData.size() - 1);
    }

    private boolean existsModuleName(String string) {
        for (ModuleSpec moduleSpec : this.modulesTableData) {
            if (!moduleSpec.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    void doRemMod() {
        int n = this.tableModules.getSelectedRow();
        if (n < 0) {
            JOptionPane.showMessageDialog(this, "Please select a module first.", "Nothing selected", 0);
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, "Please confirm, that the selected module shall be removed.\nThe module can be added again, by choosing 'Add...'.\nIf you only want to disable it, turn off the checkbox in the list of modules.", "Confirm Remove", 2);
        if (n2 != 0) {
            return;
        }
        this.needRestart = true;
        this.modulesTableData.remove(n);
        this.tableModelModules.fireTableDataChanged();
    }

    void doUpMod() {
        int n = this.tableModules.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (n < 1) {
            return;
        }
        this.needRestart = true;
        Collections.swap(this.modulesTableData, n - 1, n);
        this.tableModules.setRowSelectionInterval(n - 1, n - 1);
    }

    void doDownMod() {
        int n = this.tableModules.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (n >= this.modulesTableData.size() - 1) {
            return;
        }
        this.needRestart = true;
        Collections.swap(this.modulesTableData, n + 1, n);
        this.tableModules.setRowSelectionInterval(n + 1, n + 1);
    }

    static class ModuleSpecColumnAccessor
    implements ColumnAccessor {
        ModuleSpecColumnAccessor() {
        }

        @Override
        public void setValueAt(Object object, Object object2, int n) {
            ModuleSpec moduleSpec = (ModuleSpec)object;
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    moduleSpec.setEnabled((Boolean)object2);
                    break;
                }
                case 2: {
                    break;
                }
            }
        }

        @Override
        public Object getValueAt(Object object, int n) {
            ModuleSpec moduleSpec = (ModuleSpec)object;
            switch (n) {
                case 0: {
                    return moduleSpec.getName();
                }
                case 1: {
                    return moduleSpec.isEnabled();
                }
                case 2: {
                    return moduleSpec.getClassName();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return n == 1;
        }

        @Override
        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }
    }
}

