/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui.settings;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.ui.settings.AbstractSettingsPanel;
import de.admadic.cfg.Cfg;
import java.awt.Component;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class SettingsPanelMisc
extends AbstractSettingsPanel {
    private static final long serialVersionUID = 1L;
    Cfg cfg;
    JCheckBox checkLaFEnable;
    JCheckBox checkLoadBtnGfx;
    JCheckBox checkButtonPaintFocus;
    JCheckBox checkCustomBtnFont;
    JCheckBox checkPreloadUI;
    JCheckBox checkSkinMenuFlat;
    JCheckBox checkUseClasspathExtender;
    JCheckBox checkExtendedSettings;
    JCheckBox checkValueInTitle;
    JCheckBox checkShowTxtProtocol;
    JCheckBox checkShowTabProtocol;
    JCheckBox checkGmxSnow;
    boolean needRestart = false;

    public SettingsPanelMisc(Cfg cfg) {
        this.cfg = cfg;
    }

    @Override
    public void initContents() {
        SettingsPanelMisc settingsPanelMisc = this;
        FormLayout formLayout = new FormLayout("12px, d:grow(0.5), 12px, d:grow(0.5), 12px", "12px, d, 5px, d, 5px, d, 5px, d, 5px, d, 5px, d, 5px, d, 5px, d, 5px, d, 5px, d, 5px, d, 5px, d, 5px, d, 12px");
        settingsPanelMisc.setLayout(formLayout);
        settingsPanelMisc.add((Component)DefaultComponentFactory.getInstance().createSeparator("Require Restart of Calculator:"), new CellConstraints("2, 2, 1, 1, default, default"));
        settingsPanelMisc.add((Component)DefaultComponentFactory.getInstance().createSeparator("General:"), new CellConstraints("4, 2, 1, 1, default, default"));
        this.checkLaFEnable = new JCheckBox("Enable Skins (Java Look and Feels)");
        settingsPanelMisc.add((Component)this.checkLaFEnable, new CellConstraints("2, 4, 1, 1, default, default"));
        this.checkLoadBtnGfx = new JCheckBox("Use Custom Graphics for Buttons");
        settingsPanelMisc.add((Component)this.checkLoadBtnGfx, new CellConstraints("2, 6, 1, 1, default, default"));
        this.checkButtonPaintFocus = new JCheckBox("Paint Focus in Buttons");
        settingsPanelMisc.add((Component)this.checkButtonPaintFocus, new CellConstraints("2, 8, 1, 1, default, default"));
        this.checkCustomBtnFont = new JCheckBox("Use Custom Fonts for Buttons");
        settingsPanelMisc.add((Component)this.checkCustomBtnFont, new CellConstraints("2, 10, 1, 1, default, default"));
        this.checkPreloadUI = new JCheckBox("Preload User Interface on Startup");
        settingsPanelMisc.add((Component)this.checkPreloadUI, new CellConstraints("2, 12, 1, 1, default, default"));
        this.checkUseClasspathExtender = new JCheckBox("Internally Extend Classpath");
        settingsPanelMisc.add((Component)this.checkUseClasspathExtender, new CellConstraints("2, 14, 1, 1, default, default"));
        this.checkSkinMenuFlat = new JCheckBox("Flat Skin Menu");
        settingsPanelMisc.add((Component)this.checkSkinMenuFlat, new CellConstraints("2, 16, 1, 1, default, default"));
        this.checkExtendedSettings = new JCheckBox("Show Extended Settings");
        this.checkExtendedSettings.setSelected(true);
        settingsPanelMisc.add((Component)this.checkExtendedSettings, new CellConstraints("4, 4, 1, 1, default, default"));
        this.checkValueInTitle = new JCheckBox("Show Value in Titlebar");
        settingsPanelMisc.add((Component)this.checkValueInTitle, new CellConstraints("4, 6, 1, 1, default, default"));
        this.checkShowTxtProtocol = new JCheckBox("Show plain text protocol");
        settingsPanelMisc.add((Component)this.checkShowTxtProtocol, new CellConstraints("4, 8, 1, 1, default, default"));
        this.checkShowTabProtocol = new JCheckBox("Show tabular/editable protocol");
        settingsPanelMisc.add((Component)this.checkShowTabProtocol, new CellConstraints("4, 10, 1, 1, default, default"));
        this.checkGmxSnow = new JCheckBox("Snow with Xmas-Skin");
        settingsPanelMisc.add((Component)this.checkGmxSnow, new CellConstraints("4, 12, 1, 1, default, default"));
    }

    public void addExtendedSettingsListener(ItemListener itemListener) {
        if (itemListener != null) {
            this.checkExtendedSettings.addItemListener(itemListener);
        }
    }

    @Override
    public void loadSettings() {
        this.checkLaFEnable.setSelected(this.cfg.getBooleanValue("ui.laf.enable", true));
        this.checkLoadBtnGfx.setSelected(this.cfg.getBooleanValue("ui.button.loadgfx", true));
        this.checkButtonPaintFocus.setSelected(this.cfg.getBooleanValue("ui.button.paintfocus", true));
        this.checkCustomBtnFont.setSelected(this.cfg.getBooleanValue("ui.button.customfont", true));
        this.checkPreloadUI.setSelected(this.cfg.getBooleanValue("ui.main.preloadui", true));
        this.checkUseClasspathExtender.setSelected(this.cfg.getBooleanValue("main.classpath.useextender", true));
        this.checkSkinMenuFlat.setSelected(this.cfg.getBooleanValue("ui.main.skinmenu.flat", true));
        this.checkExtendedSettings.setSelected(this.cfg.getBooleanValue("ui.extendedsettings", false));
        this.checkValueInTitle.setSelected(this.cfg.getBooleanValue("ui.main.valueintitle", true));
        this.checkShowTxtProtocol.setSelected(this.cfg.getBooleanValue("ui.main.showtextprot", false));
        this.checkShowTabProtocol.setSelected(this.cfg.getBooleanValue("ui.main.showtabprot", true));
        this.checkGmxSnow.setSelected(this.cfg.getBooleanValue("ui.main.gmx.snow", true));
    }

    @Override
    public void storeSettings() {
        if (this.cfg.getBooleanValue("ui.laf.enable", true) != this.checkLaFEnable.isSelected()) {
            this.needRestart = true;
        }
        if (this.cfg.getBooleanValue("ui.button.loadgfx", true) != this.checkLoadBtnGfx.isSelected()) {
            this.needRestart = true;
        }
        if (this.cfg.getBooleanValue("ui.button.paintfocus", true) != this.checkButtonPaintFocus.isSelected()) {
            this.needRestart = true;
        }
        if (this.cfg.getBooleanValue("ui.button.customfont", true) != this.checkCustomBtnFont.isSelected()) {
            this.needRestart = true;
        }
        if (this.cfg.getBooleanValue("ui.main.preloadui", true) != this.checkPreloadUI.isSelected()) {
            this.needRestart = true;
        }
        if (this.cfg.getBooleanValue("main.classpath.useextender", true) != this.checkUseClasspathExtender.isSelected()) {
            this.needRestart = true;
        }
        if (this.cfg.getBooleanValue("ui.main.skinmenu.flat", true) != this.checkSkinMenuFlat.isSelected()) {
            this.needRestart = true;
        }
        this.cfg.putBooleanValue("ui.extendedsettings", this.checkExtendedSettings.isSelected());
        this.cfg.putBooleanValue("ui.main.valueintitle", this.checkValueInTitle.isSelected());
        this.cfg.putBooleanValue("ui.main.showtextprot", this.checkShowTxtProtocol.isSelected());
        this.cfg.putBooleanValue("ui.main.showtabprot", this.checkShowTabProtocol.isSelected());
        this.cfg.putBooleanValue("ui.main.gmx.snow", this.checkGmxSnow.isSelected());
        this.cfg.putBooleanValue("ui.laf.enable", this.checkLaFEnable.isSelected());
        this.cfg.putBooleanValue("ui.button.loadgfx", this.checkLoadBtnGfx.isSelected());
        this.cfg.putBooleanValue("ui.button.paintfocus", this.checkButtonPaintFocus.isSelected());
        this.cfg.putBooleanValue("ui.button.customfont", this.checkCustomBtnFont.isSelected());
        this.cfg.putBooleanValue("ui.main.preloadui", this.checkPreloadUI.isSelected());
        this.cfg.putBooleanValue("main.classpath.useextender", this.checkUseClasspathExtender.isSelected());
        this.cfg.putBooleanValue("ui.main.skinmenu.flat", this.checkSkinMenuFlat.isSelected());
    }
}

