/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui.settings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.core.LocaleModelEntry;
import de.admadic.calculator.ui.settings.AbstractSettingsPanel;
import de.admadic.cfg.Cfg;
import de.admadic.ui.util.ListRefListModel;
import de.admadic.ui.util.SeparatedComboBoxListener;
import de.admadic.ui.util.SeparatedListCellRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class SettingsPanelLocale
extends AbstractSettingsPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    IAppContext appContext;
    Cfg cfg;
    LocaleRec[] localeRecs;
    String[] localeLabels;
    static final int REC_DEFAULT = 0;
    static final int REC_INPUT = 1;
    static final int REC_OUTPUT = 2;
    static final int REC_EXPORT = 3;
    JList listLanguages;
    JScrollPane scrollLanguages;
    ListRefListModel listModelLanguages;
    SeparatedListCellRenderer listRendererLanguages;
    JList listCountries;
    JScrollPane scrollCountries;
    ListRefListModel listModelCountries;
    SeparatedListCellRenderer listRendererCountries;
    static final String CMD_CUSTOM_DEFAULT = "btn.custom.default";
    static final String CMD_CUSTOM_INPUT = "btn.custom.input";
    static final String CMD_CUSTOM_OUTPUT = "btn.custom.output";
    static final String CMD_CUSTOM_EXPORT = "btn.custom.export";
    static final String CMD_SELECTION = "combo.selection";
    JCheckBox checkSame;
    Vector<LocaleModelEntry> vectorLocales;
    Vector<LocaleModelEntry> vectorLanguages;
    Vector<LocaleModelEntry> vectorCountries;
    Hashtable<String, Hashtable<String, LocaleModelEntry>> bighash;
    boolean needRestart = false;

    public SettingsPanelLocale(IAppContext iAppContext) {
        this.appContext = iAppContext;
        this.cfg = iAppContext.getCfg();
    }

    @Override
    public void initContents() {
        SettingsPanelLocale settingsPanelLocale = this;
        FormLayout formLayout = new FormLayout("12px, p, 5px, min(p;150px):grow(0.4), 5px, p, 12px, min(p;150):grow(0.3), 5px, min(p;150):grow(0.3), 12px", "12px, p, 5px, p, 5px, p, 5px, p, 5px, p, 5px, p, 12px");
        CellConstraints cellConstraints = new CellConstraints();
        settingsPanelLocale.setLayout(formLayout);
        settingsPanelLocale.add((Component)new JLabel("Locales:"), cellConstraints.xy(2, 2));
        Locale locale = this.appContext.getLocaleManager().getDefaultLocale();
        this.vectorLocales = LocaleModelEntry.getLocaleList(true, locale);
        this.vectorLanguages = LocaleModelEntry.getLanguageList(true, locale);
        this.vectorCountries = LocaleModelEntry.getCountryList(true, locale);
        this.buildBigHash();
        this.localeRecs = new LocaleRec[4];
        this.localeLabels = new String[]{"Default:", "Input:", "Output:", "Export:"};
        for (int i = 0; i < 4; ++i) {
            this.localeRecs[i] = new LocaleRec();
            this.localeRecs[i].label = new JLabel(this.localeLabels[i]);
            this.localeRecs[i].comboLocale = new JComboBox();
            this.localeRecs[i].btnCustom = new JButton("<=");
            this.localeRecs[i].btnCustom.setToolTipText("Create from custom selection");
            this.localeRecs[i].btnCustom.addActionListener(this);
            this.localeRecs[i].comboListener = new SeparatedComboBoxListener(this.localeRecs[i].comboLocale);
            this.localeRecs[i].comboModel = new FireableComboBoxModel((Vector<?>)this.vectorLocales);
            this.localeRecs[i].renderer = new SeparatedListCellRenderer();
            this.localeRecs[i].renderer.setDefaultTab(5);
            this.localeRecs[i].comboLocale.setRenderer(this.localeRecs[i].renderer);
            this.localeRecs[i].comboLocale.addActionListener(this.localeRecs[i].comboListener);
            this.localeRecs[i].comboLocale.setModel(this.localeRecs[i].comboModel);
            this.localeRecs[i].comboLocale.addActionListener(this);
            this.localeRecs[i].comboLocale.setActionCommand(CMD_SELECTION);
            int n = i < 1 ? i : i + 1;
            n = 4 + n * 2;
            settingsPanelLocale.add((Component)this.localeRecs[i].label, cellConstraints.xy(2, n));
            settingsPanelLocale.add((Component)this.localeRecs[i].comboLocale, cellConstraints.xy(4, n));
            settingsPanelLocale.add((Component)this.localeRecs[i].btnCustom, cellConstraints.xy(6, n));
        }
        this.localeRecs[0].btnCustom.setActionCommand(CMD_CUSTOM_DEFAULT);
        this.localeRecs[1].btnCustom.setActionCommand(CMD_CUSTOM_INPUT);
        this.localeRecs[2].btnCustom.setActionCommand(CMD_CUSTOM_OUTPUT);
        this.localeRecs[3].btnCustom.setActionCommand(CMD_CUSTOM_EXPORT);
        this.checkSame = new JCheckBox("Same as default");
        settingsPanelLocale.add((Component)this.checkSame, cellConstraints.xywh(2, 6, 3, 1));
        this.checkSame.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SettingsPanelLocale.this.updateSameStatus();
            }
        });
        settingsPanelLocale.add((Component)new JLabel("Languages:"), cellConstraints.xy(8, 2));
        this.listModelLanguages = new ListRefListModel();
        this.listModelLanguages.setData(this.vectorLanguages);
        this.listLanguages = new JList();
        this.listLanguages.setModel(this.listModelLanguages);
        this.listRendererLanguages = new SeparatedListCellRenderer();
        this.listRendererLanguages.setDefaultTab(5);
        this.listLanguages.setCellRenderer(this.listRendererLanguages);
        this.scrollLanguages = new JScrollPane(this.listLanguages, 22, 32);
        settingsPanelLocale.add((Component)this.scrollLanguages, cellConstraints.xywh(8, 4, 1, 9));
        settingsPanelLocale.add((Component)new JLabel("Countries:"), cellConstraints.xy(10, 2));
        this.listModelCountries = new ListRefListModel();
        this.listModelCountries.setData(this.vectorCountries);
        this.listCountries = new JList();
        this.listCountries.setModel(this.listModelCountries);
        this.listRendererCountries = new SeparatedListCellRenderer();
        this.listRendererCountries.setDefaultTab(5);
        this.listCountries.setCellRenderer(this.listRendererCountries);
        this.scrollCountries = new JScrollPane(this.listCountries, 22, 32);
        settingsPanelLocale.add((Component)this.scrollCountries, cellConstraints.xywh(10, 4, 1, 9));
    }

    private void buildBigHash() {
        Hashtable<Object, Object> hashtable;
        String string;
        this.bighash = new Hashtable();
        for (LocaleModelEntry localeModelEntry : this.vectorLanguages) {
            if (localeModelEntry == null) continue;
            string = localeModelEntry.getLocale().getLanguage();
            hashtable = new Hashtable();
            this.bighash.put(string, hashtable);
            hashtable.put("", localeModelEntry);
        }
        if (!this.bighash.contains("")) {
            hashtable = new Hashtable();
            this.bighash.put("", hashtable);
        }
        hashtable = this.bighash.get("");
        for (LocaleModelEntry localeModelEntry : this.vectorCountries) {
            if (localeModelEntry == null) continue;
            string = localeModelEntry.getLocale().getCountry();
            hashtable.put(string, localeModelEntry);
        }
        for (LocaleModelEntry localeModelEntry : this.vectorLocales) {
            if (localeModelEntry == null) continue;
            string = localeModelEntry.getLocale().getLanguage();
            String string2 = localeModelEntry.getLocale().getCountry();
            hashtable = this.bighash.get(string);
            if (hashtable == null || hashtable.containsKey(string2)) continue;
            hashtable.put(string2, localeModelEntry);
        }
    }

    public void addToBigHash(LocaleModelEntry localeModelEntry) {
        String string = localeModelEntry.getLocale().getLanguage();
        String string2 = localeModelEntry.getLocale().getCountry();
        Hashtable<String, LocaleModelEntry> hashtable = this.bighash.get(string);
        if (!hashtable.containsKey(string2)) {
            hashtable.put(string2, localeModelEntry);
        }
    }

    protected void updateSameStatus() {
        boolean bl = this.checkSame.isSelected();
        for (int i = 1; i < 4; ++i) {
            this.localeRecs[i].comboLocale.setEnabled(!bl);
            this.localeRecs[i].btnCustom.setEnabled(!bl);
            this.localeRecs[i].label.setEnabled(!bl);
        }
    }

    @Override
    public void loadSettings() {
        String[] stringArray = new String[]{"ui.main.locale.default", "ui.main.locale.input", "ui.main.locale.output", "ui.main.locale.export"};
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = this.cfg.getStringValue(stringArray[i], null);
            if (string == null) continue;
            String[] stringArray2 = string.split(":");
            String string2 = "";
            String string3 = "";
            if (stringArray2.length > 0) {
                string2 = stringArray2[0];
            }
            if (stringArray2.length > 1) {
                string3 = stringArray2[1];
            }
            if ((n = this.getFirstMatch(this.vectorLocales, string2, string3)) < 0) continue;
            this.localeRecs[i].comboLocale.setSelectedIndex(n);
        }
        if (this.checkSame != null) {
            this.checkSame.setSelected(this.cfg.getBooleanValue("ui.main.locale.sameasdefault", true));
        }
    }

    @Override
    public void storeSettings() {
        String[] stringArray = new String[]{"ui.main.locale.default", "ui.main.locale.input", "ui.main.locale.output", "ui.main.locale.export"};
        boolean bl = this.checkSame.isSelected();
        this.cfg.putBooleanValue("ui.main.locale.sameasdefault", bl);
        for (int i = 0; i < stringArray.length; ++i) {
            LocaleModelEntry localeModelEntry;
            int n = this.localeRecs[i].comboLocale.getSelectedIndex();
            if (n < 0 || (localeModelEntry = this.vectorLocales.get(n)) == null) continue;
            String string = localeModelEntry.getLocale().getLanguage();
            String string2 = localeModelEntry.getLocale().getCountry();
            this.cfg.putStringValue(stringArray[i], string + ":" + string2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CMD_SELECTION)) {
            this.doLocaleSelection(actionEvent.getSource());
        } else if (string.equals(CMD_CUSTOM_DEFAULT)) {
            this.doSetCustom(0);
        } else if (string.equals(CMD_CUSTOM_INPUT)) {
            this.doSetCustom(1);
        } else if (string.equals(CMD_CUSTOM_OUTPUT)) {
            this.doSetCustom(2);
        } else if (string.equals(CMD_CUSTOM_EXPORT)) {
            this.doSetCustom(3);
        }
    }

    private void doSetCustom(int n) {
        int n2;
        LocaleModelEntry localeModelEntry;
        Object e;
        String string = "";
        String string2 = "";
        int n3 = this.listLanguages.getSelectedIndex();
        int n4 = this.listCountries.getSelectedIndex();
        if (n3 < 0 && n4 < 0) {
            JOptionPane.showMessageDialog(null, "No language or country selected.\nYou need to select a language or country or both.", "Nothing selected", 0);
            return;
        }
        if (n3 >= 0 && (e = this.listLanguages.getSelectedValue()) != null) {
            localeModelEntry = (LocaleModelEntry)e;
            string = localeModelEntry.getLocale().getLanguage();
        }
        if (n4 >= 0 && (e = this.listCountries.getSelectedValue()) != null) {
            localeModelEntry = (LocaleModelEntry)e;
            string2 = localeModelEntry.getLocale().getCountry();
        }
        if ((n2 = this.getFirstMatch(this.vectorLocales, string, string2)) < 0) {
            this.addLocaleModelEntry(n, string, string2);
        } else {
            this.localeRecs[n].comboLocale.setSelectedIndex(n2);
        }
    }

    private LocaleModelEntry getLMEFromHash(String string, String string2) {
        if (!this.bighash.containsKey(string)) {
            return null;
        }
        Hashtable<String, LocaleModelEntry> hashtable = this.bighash.get(string);
        if (!hashtable.containsKey(string2)) {
            return null;
        }
        return hashtable.get(string2);
    }

    private int getFirstMatch(Vector<LocaleModelEntry> vector, String string, String string2) {
        LocaleModelEntry localeModelEntry = this.getLMEFromHash(string, string2);
        if (localeModelEntry == null) {
            return -1;
        }
        return vector.indexOf(localeModelEntry);
    }

    private void addLocaleModelEntry(int n, String string, String string2) {
        int n2;
        LocaleModelEntry localeModelEntry = this.vectorLocales.firstElement();
        LocaleModelEntry localeModelEntry2 = new LocaleModelEntry(new Locale(string, string2), localeModelEntry != null ? localeModelEntry.getDisplayLocale() : Locale.getDefault());
        int[] nArray = new int[4];
        for (n2 = 0; n2 < 4; ++n2) {
            nArray[n2] = this.localeRecs[n2].comboLocale.getSelectedIndex();
        }
        this.addToBigHash(localeModelEntry2);
        this.vectorLocales.add(0, localeModelEntry2);
        for (n2 = 0; n2 < 4; ++n2) {
            this.localeRecs[n2].comboModel.fireIntervalAdded(0, 0);
            if (n2 == n) {
                this.localeRecs[n2].comboLocale.setSelectedIndex(0);
                continue;
            }
            if (nArray[n2] < 0) continue;
            this.localeRecs[n2].comboLocale.setSelectedIndex(nArray[n2] + 1);
        }
    }

    private void doLocaleSelection(Object object) {
        int n = -1;
        for (int i = 0; i < 4; ++i) {
            if (object != this.localeRecs[i].comboLocale) continue;
            n = i;
            break;
        }
        if (n < 0) {
            System.out.println("Could not locate source of selection action");
            return;
        }
        if (!this.localeRecs[n].comboLocale.hasFocus()) {
            return;
        }
        Object object2 = this.localeRecs[n].comboLocale.getSelectedItem();
        if (object2 == null) {
            return;
        }
        LocaleModelEntry localeModelEntry = (LocaleModelEntry)object2;
        String string = localeModelEntry.getLocale().getLanguage();
        if (string.equals("")) {
            this.listLanguages.clearSelection();
        } else {
            int n2 = this.getFirstMatch(this.vectorLanguages, string, "");
            if (n2 < 0) {
                this.listLanguages.clearSelection();
            } else {
                this.listLanguages.setSelectedIndex(n2);
                this.listLanguages.ensureIndexIsVisible(n2);
            }
        }
        String string2 = localeModelEntry.getLocale().getCountry();
        if (string2.equals("")) {
            this.listCountries.clearSelection();
        } else {
            int n3 = this.getFirstMatch(this.vectorCountries, "", string2);
            if (n3 < 0) {
                this.listCountries.clearSelection();
            } else {
                this.listCountries.setSelectedIndex(n3);
                this.listCountries.ensureIndexIsVisible(n3);
            }
        }
    }

    class LocaleRec {
        JLabel label;
        JComboBox comboLocale;
        JButton btnCustom;
        SeparatedListCellRenderer renderer;
        SeparatedComboBoxListener comboListener;
        FireableComboBoxModel comboModel;

        LocaleRec() {
        }
    }

    public static class FireableComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;

        public FireableComboBoxModel() {
        }

        public FireableComboBoxModel(Object[] objectArray) {
            super(objectArray);
        }

        public FireableComboBoxModel(Vector<?> vector) {
            super(vector);
        }

        public void fireIntervalAdded(int n, int n2) {
            this.fireIntervalAdded(this, n, n2);
        }

        public void fireIntervalRemoved(int n, int n2) {
            this.fireIntervalRemoved(this, n, n2);
        }

        public void fireContentsChanged(int n, int n2) {
            this.fireContentsChanged(this, n, n2);
        }
    }
}

