/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui.settings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.ui.CustomTableModel;
import de.admadic.calculator.ui.settings.AbstractSettingsPanel;
import de.admadic.calculator.ui.settings.SpinnerCellEditor;
import de.admadic.cfg.Cfg;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SettingsPanelLayout
extends AbstractSettingsPanel {
    private static final long serialVersionUID = 1L;
    static final boolean DBG = false;
    Cfg cfg;
    SpinnerCellEditor editorSpinnerCell1;
    SpinnerCellEditor editorSpinnerCell2;
    JTable tableStyles;
    CustomTableModel tableModelStyles;
    JCheckBox checkBoxFixedCellSize;
    ArrayList<Object[]> cellsTableData;
    String[] cellsTableDataKeys;

    public SettingsPanelLayout(Cfg cfg) {
        this.cfg = cfg;
    }

    @Override
    public void initContents() {
        String[] stringArray = new String[]{"Style", "Width", "Height"};
        SettingsPanelLayout settingsPanelLayout = this;
        FormLayout formLayout = new FormLayout("12px, d:grow, 12px", "12px, d:grow, 5px, d, 12px");
        settingsPanelLayout.setLayout(formLayout);
        this.tableModelStyles = new CustomTableModel();
        this.tableModelStyles.setColumns(stringArray);
        this.tableStyles = new JTable();
        this.tableStyles.setModel(this.tableModelStyles);
        this.tableStyles.setPreferredScrollableViewportSize(new Dimension(300, 150));
        JScrollPane jScrollPane = new JScrollPane(this.tableStyles);
        jScrollPane.setVerticalScrollBarPolicy(22);
        settingsPanelLayout.add((Component)jScrollPane, new CellConstraints("2, 2, 1, 1, fill, fill"));
        this.editorSpinnerCell1 = new SpinnerCellEditor(0, 50, 1);
        this.editorSpinnerCell2 = new SpinnerCellEditor(0, 50, 1);
        this.editorSpinnerCell1.setMe("1");
        this.editorSpinnerCell2.setMe("2");
        this.tableStyles.getColumnModel().getColumn(1).setCellEditor(this.editorSpinnerCell1);
        this.tableStyles.getColumnModel().getColumn(2).setCellEditor(this.editorSpinnerCell2);
        this.editorSpinnerCell1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!SettingsPanelLayout.this.editorSpinnerCell1.isEditing()) {
                    return;
                }
                SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)changeEvent.getSource();
                Integer n = (Integer)spinnerNumberModel.getValue();
                int n2 = SettingsPanelLayout.this.tableStyles.getSelectedRow();
                if (n2 < 0) {
                    return;
                }
                SettingsPanelLayout.this.cellsTableData.get((int)n2)[1] = n;
            }
        });
        this.editorSpinnerCell2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!SettingsPanelLayout.this.editorSpinnerCell2.isEditing()) {
                    return;
                }
                SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)changeEvent.getSource();
                Integer n = (Integer)spinnerNumberModel.getValue();
                int n2 = SettingsPanelLayout.this.tableStyles.getSelectedRow();
                if (n2 < 0) {
                    return;
                }
                SettingsPanelLayout.this.cellsTableData.get((int)n2)[2] = n;
            }
        });
        this.tableModelStyles.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
            }
        });
        this.tableStyles.setSelectionMode(0);
        this.checkBoxFixedCellSize = new JCheckBox("Fixed cell size");
        settingsPanelLayout.add((Component)this.checkBoxFixedCellSize, new CellConstraints("2, 4, 1, 1, default, default"));
    }

    @Override
    public void loadSettings() {
        this.cellsTableData = new ArrayList();
        this.cellsTableDataKeys = new String[3];
        this.cellsTableData.add(0, new Object[]{new String("button.standard"), new Integer(this.cfg.getIntValue("ui.layout.ccl.style.button.standard.width", 7)), new Integer(this.cfg.getIntValue("ui.layout.ccl.style.button.standard.height", 7))});
        this.cellsTableData.add(1, new Object[]{new String("button.small"), new Integer(this.cfg.getIntValue("ui.layout.ccl.style.button.small.width", 7)), new Integer(this.cfg.getIntValue("ui.layout.ccl.style.button.small.height", 7))});
        this.cellsTableData.add(2, new Object[]{new String("mincell"), new Integer(this.cfg.getIntValue("ui.layout.ccl.mincell.width", 4)), new Integer(this.cfg.getIntValue("ui.layout.ccl.mincell.height", 4))});
        this.cellsTableDataKeys[0] = "ui.layout.ccl.style.button.standard";
        this.cellsTableDataKeys[1] = "ui.layout.ccl.style.button.small";
        this.cellsTableDataKeys[2] = "ui.layout.ccl.mincell";
        this.tableModelStyles.setData(this.cellsTableData);
        this.checkBoxFixedCellSize.setSelected(this.cfg.getBooleanValue("ui.layout.ccl.fixedcellsize", true));
    }

    @Override
    public void storeSettings() {
        for (int i = 0; i < this.cellsTableDataKeys.length; ++i) {
            this.cfg.putIntValue(this.cellsTableDataKeys[i] + ".width", (Integer)this.cellsTableData.get(i)[1]);
            this.cfg.putIntValue(this.cellsTableDataKeys[i] + ".height", (Integer)this.cellsTableData.get(i)[2]);
        }
        this.cfg.putBooleanValue("ui.layout.ccl.fixedcellsize", this.checkBoxFixedCellSize.isSelected());
    }

    @Override
    public void resetSettings() {
        this.cellsTableData = null;
        this.cellsTableDataKeys = null;
        this.tableModelStyles.setData(null);
    }
}

