/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui.settings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.ui.CustomTableModel;
import de.admadic.calculator.ui.settings.AbstractSettingsPanel;
import de.admadic.calculator.ui.settings.SettingsUtils;
import de.admadic.cfg.Cfg;
import de.admadic.ui.util.LaFAddDialog;
import de.admadic.util.FileUtil;
import de.admadic.util.JarLister;
import de.admadic.util.PathManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SettingsPanelLaFs
extends AbstractSettingsPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    Cfg cfg;
    PathManager pathMan;
    JTable tableLaFs;
    CustomTableModel tableModelLaFs;
    JTable tableSkins;
    CustomTableModel tableModelSkins;
    boolean needRestart = false;
    JButton buttonAddLaF;
    JButton buttonRemLaF;
    JButton buttonAddTheme;
    JButton buttonRemTheme;
    ArrayList<Object[]> lafsTableData;
    ArrayList<ArrayList<Object[]>> skinsTableDataArray;
    int[] lafColumnWidths = new int[]{100, 30};
    int[] skinsColumnsWidths = new int[]{100, 30};
    String[] lafColNames = new String[]{"Look & Feel", "Enable"};
    protected final String CMD_LAF_ADD = "stgs.btn.laf.add";
    protected final String CMD_LAF_REM = "stgs.btn.laf.rem";
    protected final String CMD_THM_ADD = "stgs.btn.thm.add";
    protected final String CMD_THM_REM = "stgs.btn.thm.rem";

    public SettingsPanelLaFs(Cfg cfg, PathManager pathManager) {
        this.cfg = cfg;
        this.pathMan = pathManager;
    }

    @Override
    public void initContents() {
        SettingsPanelLaFs settingsPanelLaFs = this;
        FormLayout formLayout = new FormLayout("5px, d:grow(0.5), 5px, d:grow(0.5), 5px", "5px, d:grow, 5px, d, 5px, d, 5px");
        settingsPanelLaFs.setLayout(formLayout);
        this.tableModelLaFs = new CustomTableModel();
        this.tableModelLaFs.setColumns(this.lafColNames);
        this.tableLaFs = new JTable();
        this.tableLaFs.setModel(this.tableModelLaFs);
        this.tableLaFs.setPreferredScrollableViewportSize(new Dimension(150, 150));
        JScrollPane jScrollPane = new JScrollPane(this.tableLaFs);
        jScrollPane.setVerticalScrollBarPolicy(22);
        settingsPanelLaFs.add((Component)jScrollPane, new CellConstraints("2, 2, 1, 1, fill, fill"));
        this.tableLaFs.getColumnModel().getColumn(0).setPreferredWidth(this.lafColumnWidths[0]);
        this.tableLaFs.getColumnModel().getColumn(1).setPreferredWidth(this.lafColumnWidths[1]);
        this.tableModelLaFs.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
            }
        });
        this.tableLaFs.setSelectionMode(0);
        this.tableLaFs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                int n = listSelectionModel.isSelectionEmpty() ? -1 : listSelectionModel.getMinSelectionIndex();
                SettingsPanelLaFs.this.updateSkinsTable(n);
            }
        });
        String[] stringArray = new String[]{"Theme", "Enable"};
        this.tableModelSkins = new CustomTableModel();
        this.tableModelSkins.setColumns(stringArray);
        this.tableSkins = new JTable();
        this.tableSkins.setModel(this.tableModelSkins);
        this.tableSkins.setPreferredScrollableViewportSize(new Dimension(150, 150));
        JScrollPane jScrollPane2 = new JScrollPane(this.tableSkins);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        settingsPanelLaFs.add((Component)jScrollPane2, new CellConstraints("4, 2, 1, 1, fill, fill"));
        this.tableSkins.getColumnModel().getColumn(0).setPreferredWidth(this.skinsColumnsWidths[0]);
        this.tableSkins.getColumnModel().getColumn(1).setPreferredWidth(this.skinsColumnsWidths[1]);
        this.tableModelSkins.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
            }
        });
        this.tableSkins.setSelectionMode(0);
        this.buttonAddLaF = new JButton("Add Look and Feel...");
        this.buttonAddLaF.setActionCommand("stgs.btn.laf.add");
        this.buttonAddLaF.addActionListener(this);
        settingsPanelLaFs.add((Component)this.buttonAddLaF, new CellConstraints("2, 4, 1, 1, default, default"));
        this.buttonRemLaF = new JButton("Remove Look and Feel...");
        this.buttonRemLaF.setActionCommand("stgs.btn.laf.rem");
        this.buttonRemLaF.addActionListener(this);
        settingsPanelLaFs.add((Component)this.buttonRemLaF, new CellConstraints("2, 6, 1, 1, default, default"));
        this.buttonAddTheme = new JButton("Add Theme...");
        this.buttonAddTheme.setActionCommand("stgs.btn.thm.add");
        this.buttonAddTheme.addActionListener(this);
        settingsPanelLaFs.add((Component)this.buttonAddTheme, new CellConstraints("4, 4, 1, 1, default, default"));
        this.buttonRemTheme = new JButton("Remove Theme...");
        this.buttonRemTheme.setActionCommand("stgs.btn.thm.rem");
        this.buttonRemTheme.addActionListener(this);
        settingsPanelLaFs.add((Component)this.buttonRemTheme, new CellConstraints("4, 6, 1, 1, default, default"));
    }

    @Override
    public void loadSettings() {
        int n;
        Object object;
        int n2;
        Object[] objectArray = this.cfg.getValueArray("ui.laf.listavail.");
        Object[] objectArray2 = this.cfg.getValueArray("ui.laf.listuse.");
        this.lafsTableData = new ArrayList();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            String[] stringArray = ((String)objectArray[n2]).split(":");
            this.lafsTableData.add(n2, new Object[5]);
            this.lafsTableData.get((int)n2)[0] = stringArray[1];
            this.lafsTableData.get((int)n2)[1] = new Boolean(false);
            this.lafsTableData.get((int)n2)[2] = stringArray[0];
            this.lafsTableData.get((int)n2)[3] = stringArray[2];
            this.lafsTableData.get((int)n2)[4] = stringArray.length > 3 ? stringArray[3] : null;
        }
        for (n2 = 0; n2 < objectArray2.length; ++n2) {
            object = (Integer)objectArray2[n2];
            this.lafsTableData.get((int)((Integer)object).intValue())[1] = new Boolean(true);
        }
        this.tableModelLaFs.setData(this.lafsTableData);
        n2 = -1;
        object = this.cfg.getStringValue("ui.laf.select", null);
        if (object != null) {
            for (n = 0; n < this.lafsTableData.size(); ++n) {
                if (!this.lafsTableData.get(n)[0].equals(object)) continue;
                n2 = n;
            }
        }
        this.tableModelLaFs.setLockedRow(n2);
        this.skinsTableDataArray = new ArrayList();
        for (n = 0; n < this.lafsTableData.size(); ++n) {
            int n3;
            String string = this.cfg.getStringValue("ui.laf.skin.listavail." + this.lafsTableData.get(n)[0] + ".0", null);
            if (string == null) {
                this.skinsTableDataArray.add(n, null);
                continue;
            }
            Object[] objectArray3 = this.cfg.getValueArray("ui.laf.skin.listavail." + this.lafsTableData.get(n)[0] + ".");
            Object[] objectArray4 = this.cfg.getValueArray("ui.laf.skin.listuse." + this.lafsTableData.get(n)[0] + ".");
            this.skinsTableDataArray.add(n, new ArrayList());
            for (n3 = 0; n3 < objectArray3.length; ++n3) {
                String[] stringArray = ((String)objectArray3[n3]).split(":");
                this.skinsTableDataArray.get(n).add(n3, new Object[3]);
                this.skinsTableDataArray.get((int)n).get((int)n3)[0] = stringArray[0];
                this.skinsTableDataArray.get((int)n).get((int)n3)[1] = new Boolean(false);
                this.skinsTableDataArray.get((int)n).get((int)n3)[2] = stringArray[1];
            }
            for (n3 = 0; n3 < objectArray4.length; ++n3) {
                Integer n4 = (Integer)objectArray4[n3];
                this.skinsTableDataArray.get((int)n).get((int)n4.intValue())[1] = new Boolean(true);
            }
        }
        this.tableLaFs.getColumnModel().getColumn(0).setPreferredWidth(this.lafColumnWidths[0]);
        this.tableLaFs.getColumnModel().getColumn(1).setPreferredWidth(this.lafColumnWidths[1]);
        if (this.tableLaFs.getRowCount() > 0) {
            this.tableLaFs.removeRowSelectionInterval(0, this.tableLaFs.getRowCount() - 1);
        }
    }

    @Override
    public void storeSettings() {
        Object[] objectArray = new String[this.lafsTableData.size()];
        Integer[] integerArray = new Integer[this.lafsTableData.size()];
        int n = 0;
        for (int i = 0; i < this.lafsTableData.size(); ++i) {
            Object[] objectArray2 = this.lafsTableData.get(i);
            String string = (String)objectArray2[2] + ":" + (String)objectArray2[0] + ":" + (String)objectArray2[3];
            if (objectArray2[4] != null) {
                string = string + ":" + (String)objectArray2[4];
            }
            objectArray[i] = string;
            Object object = this.lafsTableData.get(i)[1];
            if (((Boolean)object).booleanValue()) {
                integerArray[n] = new Integer(i);
                ++n;
            }
            if (this.skinsTableDataArray.get(i) == null) continue;
            Integer[] integerArray2 = new Integer[this.skinsTableDataArray.get(i).size()];
            int n2 = 0;
            Object[] objectArray3 = new String[this.skinsTableDataArray.get(i).size()];
            for (int j = 0; j < this.skinsTableDataArray.get(i).size(); ++j) {
                Object[] objectArray4 = this.skinsTableDataArray.get(i).get(j);
                String string2 = (String)objectArray4[0] + ":" + (String)objectArray4[2];
                objectArray3[j] = string2;
                Object object2 = this.skinsTableDataArray.get(i).get(j)[1];
                if (!((Boolean)object2).booleanValue()) continue;
                integerArray2[n2] = new Integer(j);
                ++n2;
            }
            Object[] objectArray5 = new Integer[n2];
            System.arraycopy(integerArray2, 0, objectArray5, 0, n2);
            this.cfg.putValueArray("ui.laf.skin.listavail." + this.lafsTableData.get(i)[0] + ".", objectArray3);
            this.cfg.putValueArray("ui.laf.skin.listuse." + this.lafsTableData.get(i)[0] + ".", objectArray5);
        }
        Object[] objectArray6 = new Integer[n];
        System.arraycopy(integerArray, 0, objectArray6, 0, n);
        this.cfg.putValueArray("ui.laf.listavail.", objectArray);
        this.cfg.putValueArray("ui.laf.listuse.", objectArray6);
    }

    @Override
    public void resetSettings() {
        this.lafsTableData = null;
        this.tableModelLaFs.setData(null);
        this.skinsTableDataArray = null;
        this.tableModelSkins.setData(null);
    }

    protected void updateSkinsTable(int n) {
        if (n < 0 || n >= this.skinsTableDataArray.size()) {
            return;
        }
        int n2 = -1;
        if (this.skinsTableDataArray.get(n) == null) {
            this.tableModelSkins.setData(null);
        } else {
            this.tableModelSkins.setData(this.skinsTableDataArray.get(n));
        }
        this.tableModelSkins.setLockedRow(n2);
        if (this.skinsTableDataArray.get(n) == null) {
            this.tableModelSkins.fireTableDataChanged();
            return;
        }
        String string = (String)this.lafsTableData.get(n)[0];
        String string2 = this.cfg.getStringValue("ui.laf.skin." + string, null);
        if (string2 == null) {
            this.tableModelSkins.fireTableDataChanged();
            return;
        }
        for (int i = 0; i < this.skinsTableDataArray.get(n).size(); ++i) {
            if (!((String)this.skinsTableDataArray.get(n).get(i)[0]).equals(string2)) continue;
            n2 = i;
            break;
        }
        this.tableModelSkins.setLockedRow(n2);
        this.tableModelSkins.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("stgs.btn.laf.add")) {
            this.doLaFAdd();
        } else if (string.equals("stgs.btn.laf.rem")) {
            this.doLaFRem();
        } else if (string.equals("stgs.btn.thm.add")) {
            this.doThemeAdd();
        } else if (string.equals("stgs.btn.thm.rem")) {
            this.doThemeRem();
        }
    }

    protected void doLaFAdd() {
        File file = SettingsUtils.getJarFile(this);
        if (file == null) {
            return;
        }
        JarLister jarLister = new JarLister();
        try {
            jarLister.appendList(file.getPath(), null, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Could not access the file:\n" + file.getPath(), "Error accessing file", 0);
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Could not read the file:\n" + file.getPath(), "Error reading file", 0);
            return;
        }
        LaFAddDialog laFAddDialog = new LaFAddDialog((Frame)null);
        laFAddDialog.addClasses(jarLister.getClassListDotted());
        laFAddDialog.updateControls();
        laFAddDialog.setFilter("LookAndFeel");
        laFAddDialog.setVisible(true);
        if (laFAddDialog.getResultCode() != 1) {
            return;
        }
        if (laFAddDialog.getResultNamesCount() == 0) {
            return;
        }
        this.setNeedRestart(true);
        int n = laFAddDialog.getResultNamesCount();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = new Object[]{laFAddDialog.getResultDisplayName(i), new Boolean(true), "x", laFAddDialog.getResultClassName(i), null};
            this.lafsTableData.add(objectArray);
            this.skinsTableDataArray.add(null);
        }
        this.tableModelLaFs.fireTableStructureChanged();
        if (n > 0) {
            SettingsUtils.installFile(this, this.pathMan, file, 7);
        }
    }

    protected void doLaFRem() {
        int n = this.tableLaFs.getSelectedRow();
        if (n < 0) {
            JOptionPane.showMessageDialog(this, "Please select a Look-and-Feel first.", "Nothing selected", 0);
            return;
        }
        if (this.tableModelLaFs.getLockedRow() == n) {
            JOptionPane.showMessageDialog(this, "Cannot remove the active Look-and-Feel.", "Row is locked", 0);
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, "Please confirm, that the selected Look-and-Feel shall be removed.\nThe Look-and-Feel can be added again, by choosing 'Add Look-and-Feel...'.\nIf you only want to disable it, turn off the checkbox in the list of Look-and-Feels.", "Confirm Remove", 2);
        if (n2 != 0) {
            return;
        }
        this.lafsTableData.remove(n);
        this.skinsTableDataArray.remove(n);
        this.tableModelLaFs.fireTableStructureChanged();
    }

    protected void doThemeAdd() {
        boolean bl;
        Object object;
        Object object2;
        File file;
        int n;
        block21: {
            n = this.tableLaFs.getSelectedRow();
            if (n < 0) {
                JOptionPane.showMessageDialog(this, "The SkinLF Look-and-Feel must be selected.", "Nothing selected", 0);
                return;
            }
            String string = (String)this.lafsTableData.get(n)[0];
            if (!string.equals("SkinLF")) {
                JOptionPane.showMessageDialog(this, "The SkinLF Look-and-Feel must be selected.", "Nothing selected", 0);
                return;
            }
            file = SettingsUtils.getZipFile(this);
            if (file == null) {
                return;
            }
            object2 = file.getName();
            if (((String)object2).toLowerCase().endsWith(".zip")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - ".zip".length());
            }
            if (((String)object2).toLowerCase().endsWith("themepack")) {
                object2 = ((String)object2).substring(0, ((String)object2).length() - "themepack".length());
            }
            if (((String)object2).equals("")) {
                object2 = file.getName();
            }
            Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
            Iterator<Object[]> iterator = this.skinsTableDataArray.get(n).iterator();
            while (iterator.hasNext()) {
                Object[] objectArray;
                Object[] objectArray2 = objectArray = iterator.next();
                hashtable.put((String)objectArray2[0], Boolean.TRUE);
            }
            int n2 = 10;
            int n3 = 0;
            while (hashtable.containsKey(object2)) {
                object2 = (String)object2 + "1";
                if (n3++ <= n2) continue;
            }
            n2 = 0;
            while (true) {
                if ((object = JOptionPane.showInputDialog(this, n2 != 0 ? "The theme name existed, this is the suggested name:" : "Please review the name of the theme:", object2)) == null) {
                    return;
                }
                object2 = object;
                if (!hashtable.containsKey(object2)) break;
                int n4 = 10;
                int n5 = 0;
                while (hashtable.containsKey(object2)) {
                    object2 = (String)object2 + "1";
                    if (n5++ <= n4) continue;
                }
                n2 = 1;
            }
            object = null;
            bl = true;
            String string2 = file.getName();
            String string3 = this.pathMan.getPathString(3);
            if (bl) {
                if (string3 == null) {
                    JOptionPane.showMessageDialog(this, "Could not detect the system path for the calculator.\nThe theme will be registered, but you need to copy the themepack\nto the directory by yourself.", "Could not detect LaF-path", 0);
                    bl = false;
                } else {
                    File file2;
                    block20: {
                        String string4 = this.cfg.getStringValue("ui.laf.impl.skinlf.themepack.path", null);
                        if (string4 == null || string4.equals("")) {
                            JOptionPane.showMessageDialog(this, "Could not detect themepack path.\nPlease contact customer support.\nThe theme will not be registered.", "Could not detect themepack path", 0);
                            return;
                        }
                        file2 = new File(string3);
                        file2 = new File(file2, string4);
                        object = new File(file2, string2);
                        try {
                            if (!file.getCanonicalPath().startsWith(file2.getCanonicalPath())) break block20;
                            bl = false;
                            break block21;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    while (((File)object).exists()) {
                        System.out.println("exists: " + ((File)object).toString());
                        String string5 = JOptionPane.showInputDialog(this, "The file already exists. Please choose another name (keep the .zip extension!):", string2);
                        if (string5 == null) {
                            return;
                        }
                        string2 = string5;
                        object = new File(file2, string2);
                    }
                }
            }
        }
        if (bl && object != null && !FileUtil.copyFile(file.getPath(), ((File)object).getPath())) {
            JOptionPane.showMessageDialog(this, "Could not copy the themepack file to the destination:\nFile = " + ((File)object).getPath() + "\nThe themepack will be registered, but you must copy the \nthemepack file manually to the destination.", "Could not copy themepack", 0);
        }
        this.skinsTableDataArray.get(n).add(new Object[]{object2, new Boolean(true), ((File)object).getName()});
        this.tableModelSkins.fireTableStructureChanged();
    }

    protected void doThemeRem() {
        int n;
        int n2 = this.tableLaFs.getSelectedRow();
        if (n2 < 0) {
            JOptionPane.showMessageDialog(this, "Please select a Look-and-Feel first.", "Nothing selected", 0);
            return;
        }
        int n3 = this.tableSkins.getSelectedRow();
        if (n3 < 0) {
            JOptionPane.showMessageDialog(this, "Please select a Skin first.", "Nothing selected", 0);
            return;
        }
        if (this.tableModelLaFs.getLockedRow() == n2) {
            if (this.tableModelSkins.getLockedRow() == n3) {
                JOptionPane.showMessageDialog(this, "Cannot remove the active Skin.", "Row is locked", 0);
                return;
            }
        } else if (this.tableModelSkins.getLockedRow() == n3) {
            JOptionPane.showMessageDialog(this, "That skin is active for another Look-and-Feel.\nTo remove it, activate another skin of that Look-and-Feel\nor simply remove its Look-and-Feel instead.", "Row is locked", 0);
            return;
        }
        if ((n = JOptionPane.showConfirmDialog(this, "Please confirm, that the selected Skin shall be removed.\nThe Skin can be added again, by choosing 'Add skin...'.\nIf you only want to disable it, turn off the checkbox in the list of Skins.", "Confirm Remove", 2)) != 0) {
            return;
        }
        this.tableModelSkins.removeRow(n3);
    }

    @Override
    public boolean isNeedRestart() {
        return this.needRestart;
    }

    public void setNeedRestart(boolean bl) {
        this.needRestart = bl;
    }
}

