/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui.settings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.admadic.calculator.ui.settings.AbstractSettingsPanel;
import de.admadic.calculator.ui.settings.SettingsPanelCallBack;
import de.admadic.cfg.Cfg;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class SettingsPanelAdvanced
extends AbstractSettingsPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    Cfg cfg;
    JButton btnReset;
    JButton btnClearPref;
    protected final String CMD_RESET = "stgs.btn.reset";
    protected final String CMD_CLEAR_PREF = "stgs.btn.clrpref";
    SettingsPanelCallBack callBackForReset;

    public SettingsPanelAdvanced(Cfg cfg) {
        this.cfg = cfg;
    }

    @Override
    public void initContents() {
        SettingsPanelAdvanced settingsPanelAdvanced = this;
        FormLayout formLayout = new FormLayout("5px, d:grow, 5px", "5px, d, 5px, d, 5px");
        settingsPanelAdvanced.setLayout(formLayout);
        this.btnReset = new JButton();
        settingsPanelAdvanced.add((Component)this.btnReset, new CellConstraints("2, 2, 1, 1, left, default"));
        this.btnReset.setText("Reset...");
        this.btnReset.addActionListener(this);
        this.btnReset.setActionCommand("stgs.btn.reset");
        this.btnClearPref = new JButton();
        settingsPanelAdvanced.add((Component)this.btnClearPref, new CellConstraints("2, 4, 1, 1, left, default"));
        this.btnClearPref.setText("Clear Preferences...");
        this.btnClearPref.addActionListener(this);
        this.btnClearPref.setActionCommand("stgs.btn.clrpref");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = actionEvent.getActionCommand();
        if (string.equals("stgs.btn.reset")) {
            int n2 = JOptionPane.showConfirmDialog(this, "You are about to reset the settings of the application to the default values.\nThese settings will be applied immediately and the settings dialog will be closed.\nAre you sure you want to reset the settings?", "Reset configuration", 0, 3);
            if (n2 == 0) {
                this.cfg.setDefaults();
                if (this.callBackForReset != null) {
                    this.callBackForReset.execute(null);
                }
            }
        } else if (string.equals("stgs.btn.clrpref") && (n = JOptionPane.showConfirmDialog(this, "You are about to clear the stored preferences.\nThe current settings will not be changed. To change also the current settings use 'Reset' instead.\nAre you sure you want to clear the stored preferences?", "Clear Stored Preferences", 0, 3)) == 0) {
            if (this.cfg.clearPreferences("/de.admadic.calculator")) {
                JOptionPane.showMessageDialog(this, "The stored preferences were successfully cleared.", "Clear Stored Preferences", 1);
            } else {
                JOptionPane.showMessageDialog(this, "There was an error clearing the stored preferences\nPlease contact customer support.", "Clear Stored Preferences", 0);
            }
        }
    }

    public void setCallBackForReset(SettingsPanelCallBack settingsPanelCallBack) {
        this.callBackForReset = settingsPanelCallBack;
    }
}

