/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.ui.settings;

import de.admadic.calculator.appctx.IAppContext;
import de.admadic.calculator.ui.settings.ISettingsPanel;
import de.admadic.calculator.ui.settings.SettingsPanelAdvanced;
import de.admadic.calculator.ui.settings.SettingsPanelCallBack;
import de.admadic.calculator.ui.settings.SettingsPanelLaFs;
import de.admadic.calculator.ui.settings.SettingsPanelLayout;
import de.admadic.calculator.ui.settings.SettingsPanelLocale;
import de.admadic.calculator.ui.settings.SettingsPanelMisc;
import de.admadic.calculator.ui.settings.SettingsPanelModules;
import de.admadic.calculator.ui.settings.SettingsPanelNumFmt;
import de.admadic.cfg.Cfg;
import de.admadic.ui.util.Dialog;
import de.admadic.util.PathManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SettingsDialog
extends Dialog
implements ActionListener {
    static final boolean DBG = false;
    private static final long serialVersionUID = 1L;
    IAppContext appContext;
    Cfg cfg;
    PathManager pathMan;
    JPanel buttonPanel;
    JButton btnOK;
    JButton btnApply;
    JButton btnCancel;
    SettingsPanelNumFmt tabPanelNumFmt;
    SettingsPanelLocale tabPanelLocale;
    SettingsPanelLayout tabPanelLayout;
    SettingsPanelLaFs tabPanelLaFs;
    SettingsPanelMisc tabPanelMisc;
    SettingsPanelAdvanced tabPanelAdvanced;
    SettingsPanelModules tabPanelModules;
    ArrayList<ISettingsPanel> settingsPanels;
    int[] tabIdxForExt;
    JTabbedPane tabbedPane;
    JFrame parentFrame;
    protected final String CMD_OK = "stgs.btn.ok";
    protected final String CMD_CANCEL = "stgs.btn.cancel";
    protected final String CMD_APPLY = "stgs.btn.apply";

    public SettingsDialog(IAppContext iAppContext, JFrame jFrame) {
        super(jFrame);
        this.appContext = iAppContext;
        this.cfg = iAppContext.getCfg();
        this.pathMan = iAppContext.getPathManager();
        this.parentFrame = jFrame;
        this.settingsPanels = new ArrayList();
        this.initGUI();
    }

    private void initTabLayout() {
        this.tabPanelLayout = new SettingsPanelLayout(this.cfg);
        this.settingsPanels.add(this.tabPanelLayout);
        this.tabPanelLayout.initContents();
    }

    private void initTabLaFs() {
        this.tabPanelLaFs = new SettingsPanelLaFs(this.cfg, this.pathMan);
        this.settingsPanels.add(this.tabPanelLaFs);
        this.tabPanelLaFs.initContents();
    }

    protected void updateExtendedSettingsStatus(boolean bl) {
        if (this.tabIdxForExt == null) {
            return;
        }
        for (int i = 0; i < this.tabIdxForExt.length; ++i) {
            this.tabbedPane.setEnabledAt(this.tabIdxForExt[i], bl);
        }
    }

    private void initTabMisc() {
        this.tabPanelMisc = new SettingsPanelMisc(this.cfg);
        this.settingsPanels.add(this.tabPanelMisc);
        this.tabPanelMisc.initContents();
        this.tabPanelMisc.addExtendedSettingsListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                SettingsDialog.this.updateExtendedSettingsStatus(bl);
            }
        });
    }

    private void initTabNumFmt() {
        this.tabPanelNumFmt = new SettingsPanelNumFmt(this.cfg);
        this.settingsPanels.add(this.tabPanelNumFmt);
        this.tabPanelNumFmt.initContents();
    }

    private void initTabLocale() {
        this.tabPanelLocale = new SettingsPanelLocale(this.appContext);
        this.settingsPanels.add(this.tabPanelLocale);
        this.tabPanelLocale.initContents();
    }

    private void initTabAdvanced() {
        this.tabPanelAdvanced = new SettingsPanelAdvanced(this.cfg);
        this.settingsPanels.add(this.tabPanelAdvanced);
        this.tabPanelAdvanced.initContents();
        this.tabPanelAdvanced.setCallBackForReset(new SettingsPanelCallBack(){

            @Override
            public void execute(Object object) {
                SettingsDialog.this.setResultCode(2);
                SettingsDialog.this.dispose();
            }
        });
    }

    private void initTabModules() {
        this.tabPanelModules = new SettingsPanelModules(this.cfg, this.pathMan);
        this.settingsPanels.add(this.tabPanelModules);
        this.tabPanelModules.initContents();
    }

    private void initGUI() {
        try {
            this.setModal(true);
            this.setTitle("Calculator Settings");
            this.buttonPanel = new JPanel();
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.btnOK = new JButton();
            this.buttonPanel.add(this.btnOK);
            this.btnOK.setText("OK");
            this.btnCancel = new JButton();
            this.buttonPanel.add(this.btnCancel);
            this.btnCancel.setText("Cancel");
            this.btnApply = new JButton();
            this.buttonPanel.add(this.btnApply);
            this.btnApply.setText("Apply");
            this.btnOK.setActionCommand("stgs.btn.ok");
            this.btnCancel.setActionCommand("stgs.btn.cancel");
            this.btnApply.setActionCommand("stgs.btn.apply");
            this.btnOK.addActionListener(this);
            this.btnCancel.addActionListener(this);
            this.btnApply.addActionListener(this);
            this.tabbedPane = new JTabbedPane();
            this.getContentPane().add((Component)this.tabbedPane, "Center");
            this.initTabNumFmt();
            this.initTabLocale();
            this.initTabMisc();
            this.initTabLaFs();
            this.initTabModules();
            this.initTabLayout();
            this.initTabAdvanced();
            this.tabbedPane.addTab("Number Format", null, this.tabPanelNumFmt, null);
            this.tabbedPane.addTab("Locale", null, this.tabPanelLocale, null);
            this.tabbedPane.addTab("Misc", null, this.tabPanelMisc, null);
            this.tabbedPane.addTab("Look & Feels", null, this.tabPanelLaFs, null);
            this.tabbedPane.addTab("Modules", null, this.tabPanelModules, null);
            this.tabbedPane.addTab("Layout", null, this.tabPanelLayout, null);
            this.tabbedPane.addTab("Advanced", null, this.tabPanelAdvanced, null);
            this.tabIdxForExt = new int[]{5, 6};
            this.registerEnterAction(this.btnOK);
            this.pack();
            this.updateGUIPlacement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateGUIPlacement() {
        this.setLocationRelativeTo(this.parentFrame);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("stgs.btn.ok")) {
            this.storeSettings();
            this.setResultCode(1);
            this.dispose();
        } else if (string.equals("stgs.btn.apply")) {
            this.storeSettings();
        } else if (string.equals("stgs.btn.cancel")) {
            this.setResultCode(2);
            this.dispose();
        }
    }

    public void resetSettings() {
        for (ISettingsPanel iSettingsPanel : this.settingsPanels) {
            iSettingsPanel.resetSettings();
        }
    }

    public void loadSettings() {
        if (this.cfg == null) {
            return;
        }
        for (ISettingsPanel iSettingsPanel : this.settingsPanels) {
            iSettingsPanel.loadSettings();
        }
    }

    public void storeSettings() {
        if (this.cfg == null) {
            return;
        }
        for (ISettingsPanel object : this.settingsPanels) {
            object.storeSettings();
        }
        boolean bl = false;
        for (ISettingsPanel iSettingsPanel : this.settingsPanels) {
            bl |= iSettingsPanel.isNeedRestart();
        }
        if (bl) {
            JOptionPane.showMessageDialog(this, "Please restart the Calculator to let all changes apply", "Restart the Program", 2);
        }
    }
}

